package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.ConfesscompanyundoDao;
import com.bcxin.ars.dao.sb.ConfesscompanyundoDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanyundoSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Confesscompanyundo;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.ConfesscompanyundoService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author：huangzp
 * @date：2018/04/09
 * @description：自招单位撤销备案实现类
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = Confesscompanyundo.class)
public class ConfesscompanyundoServiceImpl implements ConfesscompanyundoService {

    private Logger logger = LoggerFactory.getLogger(ConfesscompanyundoServiceImpl.class);

    @Autowired
    private ConfesscompanyundoDao confesscompanyundoDao;

    @Autowired
    private ConfesscompanyundoDaoAop confesscompanyundoDaoAop;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private PoliceDao policeDao;

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    @Override
    public Confesscompanyundo findById(long id) {
        Confesscompanyundo result = confesscompanyundoDao.findById(id);

        if (result != null) {
            //查询审批日志信息
            Approval approval = approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.ZZBACX);
            result.setApproval(approval);
            if(result.getOrgid()!=null) {
                //查询机构信息
                Police police = policeDao.findById(result.getOrgid());
                result.setPolice(police);
            }
        }
        return result;
    }

    @Override
    public  List<Confesscompanyundo> findByBatchId(List<Approval> approvalList){
        return  confesscompanyundoDao.findByBatchId(approvalList);
    }
    @Override
    public  void updateBatch(List<Confesscompanyundo> list){
        confesscompanyundoDaoAop.updateBatch(list);
    }

    @Override
    public List<Confesscompanyundo> findAll() {
        return confesscompanyundoDao.findAll();
    }

    /**
     * 根据用户id获取对应单据
     * @param userId
     * @return
     */
    @Override
    public Confesscompanyundo findUNSubmitByUser(Long userId){
        return confesscompanyundoDao.findUNSubmitByUser(userId);
    }

    /**
     * 新增或者修改
     * @param confesscompanyundo 自行招用撤销信息
     */
    @Override
    public void saveOrUpdate(Confesscompanyundo confesscompanyundo) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(confesscompanyundo.getOrgid() == null){
            if(confesscompanyundo.getDistrictOrgId() != null){
                confesscompanyundo.setOrgid(Long.parseLong(confesscompanyundo.getDistrictOrgId()));
            }else if(confesscompanyundo.getCityOrgId() != null){
                confesscompanyundo.setOrgid(Long.parseLong(confesscompanyundo.getCityOrgId()));
            }
        }

        if(currentUser.getPlatform() == Constants.PLATFORM_COMPANY || currentUser.getPlatform() == Constants.PLATFORM_NATURAL_PERSON  ){//公司或自然人
            confesscompanyundo.setUserid(currentUser.getId());
        }
        confesscompanyundo.setCompanyname(confesscompanyundo.getCompanyname().trim());
        boolean activity = true;
        //根据企业名称验证单据时候重新提交，排除 暂存和审批不通过状态，PS只有提交状态(待审批)才需要做控制
        if(Constants.APPROVALSTATE_DSP.equals(confesscompanyundo.getApprovalstate())) {
            if (checkDupliCompanyundo(confesscompanyundo.getCompanyname(),confesscompanyundo.getId())) {
                throw new ArsException(confesscompanyundo.getCompanyname() + "已重复，不能重复提交！");
            }
        }

        if (confesscompanyundo.getId() == null) {
            confesscompanyundo.setActive(true);
            confesscompanyundo.setCreateTime(new Date());
            confesscompanyundo.setUpdateTime(new Date());
            confesscompanyundo.setUpdateBy(currentUser.getUsername());
            confesscompanyundoDao.save(confesscompanyundo);
        }else{
            //重新获取
            Confesscompanyundo oldConfesscompanyundo = confesscompanyundoDao.findById(confesscompanyundo.getId());

            if(StringUtil.isNotEmpty(oldConfesscompanyundo.getApprovalstate()) && oldConfesscompanyundo.getApprovalstate().equals(ApprovalState.DSH)){
                if(oldConfesscompanyundo.getOrgid().toString().equals(confesscompanyundo.getOrgid().toString())){
                    activity = false;
                    if(!oldConfesscompanyundo.getCompanyname().equals(confesscompanyundo.getCompanyname())) {
                        Approval approval = approvalDAO.findBybusinessidAndType(confesscompanyundo.getId(), BusinessType.ZZBACX);
                        if (approval != null) {
                            approvalUtil.updateContent(approval, confesscompanyundo.getCompanyname());
                        }
                    }
                }
            }

            if(ApprovalState.WTJ.equals(confesscompanyundo.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(confesscompanyundo,oldConfesscompanyundo,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(confesscompanyundo,oldConfesscompanyundo,true);
            }

            oldConfesscompanyundo.setActive(true);
            oldConfesscompanyundo.setUpdateTime(new Date());
            oldConfesscompanyundo.setUpdateBy(currentUser.getUsername());
            confesscompanyundoDaoAop.update(oldConfesscompanyundo);
        }

        //触发流程
        if (ApprovalState.DSH.equals(confesscompanyundo.getApprovalstate())) {
            confesscompanyundo.setCensorstatus("");
            //保存审批信息
            if (activity) {
                approvalUtil.saveApproval(BusinessType.ZZBACX, confesscompanyundo.getId(), Constants.ACTIVITI_PROCESS_CONFESSCOMPANYUNDO);
            }
        }
    }


    /**
     * 导入专用
     * @param confesscompanyundo
     */
    @Override
    public void updateForImport(Confesscompanyundo confesscompanyundo) {
        confesscompanyundo.setUpdateTime(new Date());
        //重新获取
        Confesscompanyundo oldConfesscompanyundo = confesscompanyundoDao.findById(confesscompanyundo.getId());
        Long userId=oldConfesscompanyundo.getUserid();


        if(ApprovalState.WTJ.equals(confesscompanyundo.getApprovalstate())){
            BeanUtils.copyPropertiesIgnore(confesscompanyundo,oldConfesscompanyundo,"active,createTime,userid",true);
        }else{
            BeanUtils.copyPropertiesIgnore(confesscompanyundo,oldConfesscompanyundo,true);
        }
        oldConfesscompanyundo.setUpdateTime(new Date());
        //防止申请被修改为当前用户，需重新赋值
        oldConfesscompanyundo.setUserid(userId);
        confesscompanyundoDaoAop.update(oldConfesscompanyundo);
    }


    /**
     * 逻辑删除
     * @param id
     */
    @Override
    public void delete(Long id) {
        Confesscompanyundo confesscompanyundo =new Confesscompanyundo();
        confesscompanyundo.setId(id);
        confesscompanyundo.setUpdateTime(new Date());
        confesscompanyundoDaoAop.delete(confesscompanyundo);
    }

    /**
     * 审批
     * @param confesscompanyundo
     */
    @Override
    public void approve(Confesscompanyundo confesscompanyundo){
        User currentUser = arsUtil.getCurrentUser();
        confesscompanyundo.setApprovalperson(currentUser.getId().toString());
        confesscompanyundo.setUpdateTime(new Date());
        confesscompanyundoDaoAop.approve(confesscompanyundo);
    }


    /**
     * 搜索查询
     * @param dto
     * @return
     */
    @Override
    public ConfesscompanyundoSearchDto search(ConfesscompanyundoSearchDto dto) {
        ConfesscompanyundoSearchDto resultDto = new ConfesscompanyundoSearchDto();
        User currentUser = arsUtil.getCurrentUser();

        //机构信息
        Police police =null;// policeDao.findById(currentUser.getOrgid());
        String areacode =  police.getAreacode();
        if(areacode.endsWith("0000")){//省
            dto.setDistrict(areacode.substring(0,2)+"____");
        }else if(areacode.endsWith("00")){//市
            dto.setDistrict(areacode.substring(0,4)+"__");
        }else{//区
            dto.setDistrict(areacode);
        }

        List<Confesscompanyundo> list = confesscompanyundoDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(confesscompanyundoDao.searchCount(dto));
        return resultDto;
    }

    /**
     * 查询需同步的撤销备案记录
     * @param dto
     * @return
     */
    @Override
    public List<Confesscompanyundo> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return confesscompanyundoDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdateForDS(Confesscompanyundo confesscompanyundo) {
        if (confesscompanyundo.getActive() == null) {
            confesscompanyundo.setActive(true);
        }
        Confesscompanyundo dbConfesscompanyundo = confesscompanyundoDao.findById(confesscompanyundo.getId());
        if (dbConfesscompanyundo != null) {
            if (confesscompanyundo.getUpdateTime().getTime() > dbConfesscompanyundo.getUpdateTime().getTime()) {
                confesscompanyundoDaoAop.update(confesscompanyundo);
            }
        } else {
            confesscompanyundoDao.save(confesscompanyundo);
        }
    }

    /**
     * 根据企业名称验证时候重复提交单据
     * @param companyName
     * @param filterId 自身id
     */
    @Override
    public boolean checkDupliCompanyundo(String companyName,Long filterId){
        Map<String,Object> map=new HashMap<String,Object>();
        map.put("companyname",companyName);
        List<String> notIncludeStateList=new ArrayList<String>();
        notIncludeStateList.add(Constants.APPROVALSTATE_WTJ);
        notIncludeStateList.add(Constants.APPROVALSTATE_BTG);
        map.put("notincludestatelist",notIncludeStateList);
        if(filterId!=null){
            map.put("filterId",filterId);
        }
        int num=confesscompanyundoDao.checkDupliCompanyundo(map);
        if(num>0){
            return true;
        }
        return false;
    }


    /**
     * 搜索查询
     * @param p
     * @return
     */
    @Override
    public PageResult searchConfesscompanyundoList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }
           if(police!=null){
        if (police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
        }
    }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
                    p.put("userid",currentUser.getId());
                } else{
                    //角色列表
                    List<PoliceRole> roles = currentUser.getRoles();
                    if(roles!=null&&roles.size()>0) {
                        p.put("roles",roles);
                    }
                }
            }
        }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }
        return new PageResult(confesscompanyundoDao.countConfesscompanyundoList(p), confesscompanyundoDao.searchConfesscompanyundoList(p));
    }


    /**
     * 更新审查状态
     * @param confesscompanyundo
     */
    @Override
    public void updateCensorStatus(Confesscompanyundo confesscompanyundo) {
        confesscompanyundo.setUpdateTime(new Date());
        confesscompanyundoDaoAop.updateCensorStatus(confesscompanyundo);
    }

    /**
     * 根据单据id查询申请人信息
     * @param id
     * @return
     */
    @Override
    public Map<String,Object> selectApplyUserInfoWithId(Long id){
        return confesscompanyundoDao.selectApplyUserInfoWithId(id);
    }



    @Override
    public void searchForPage(ConfesscompanyundoSearchDto dto, AjaxPageResponse<Confesscompanyundo> page) {
        arsUtil.setPoliceSearch(dto);
        User currentUser = arsUtil.getCurrentUser();

        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            if (currentUser != null) {
                dto.setUserid(currentUser.getId());
            }
        }
        confesscompanyundoDao.searchForPage(dto,page);

    }

    /**
     * 实体复制
     * @param dest 目标对象
     * @param orig 源对象
     * @return
     */
    private Confesscompanyundo copyProperties(Confesscompanyundo dest,Confesscompanyundo orig){
        User currentUser = arsUtil.getCurrentUser();
        dest.setAddress(orig.getAddress());
        dest.setApprovaldate(orig.getApprovaldate());
        dest.setApprovalperson(orig.getApprovalperson());
        dest.setApprovalreason(orig.getApprovalreason());
        dest.setApprovalstate(orig.getApprovalstate());
        dest.setBadate(orig.getBadate());
        dest.setCancelapplyfj(orig.getCancelapplyfj());
        dest.setCanceldate(orig.getCanceldate());
        dest.setCancelreson(orig.getCancelreson());
        dest.setCity(orig.getCity());
        dest.setDistrict(orig.getDistrict());
        dest.setProvince(orig.getProvince());
        dest.setCompanyname(orig.getCompanyname());
        dest.setLegalcard(orig.getLegalcard());
        dest.setLegalzmcl(orig.getLegalzmcl());
        dest.setLegalcardpicf(orig.getLegalcardpicf());
        dest.setLegalcardpicz(orig.getLegalcardpicz());
        dest.setLegalname(orig.getLegalname());
        dest.setLegalphone(orig.getLegalphone());
        dest.setLoginnum(orig.getLoginnum());
        dest.setOrgid(orig.getOrgid());
        dest.setActive(orig.getActive());
        dest.setUpdateBy(currentUser.getUsername());
        dest.setUpdateTime(new Date());
        dest.setUserid(currentUser.getId());
        //地区格式化
        dest.setSzss(orig.getSzss().replaceAll("/",""));
        dest.setServicearea(orig.getServicearea());
        dest.setCensorstatus(orig.getCensorstatus());

        return dest;
    }

}
