package com.bcxin.ars.service.sb.impl;

import java.util.Date;
import java.util.List;

import com.bcxin.ars.util.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.sb.ChargeworkDao;
import com.bcxin.ars.dto.sb.ChargeworkSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Chargework;
import com.bcxin.ars.service.sb.ChargeworkService;
import com.bcxin.ars.service.util.ArsUtil;

@Service
@Transactional
public class ChargeworkServiceImpl implements ChargeworkService{

	@Autowired
	private ChargeworkDao chargeworkDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Chargework findById(long id) {
		return chargeworkDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Chargework chargework) {
		User currentUser = arsUtil.getCurrentUser();
		if(chargework.getId() == null){
			chargework.setActive(true);
			chargework.setCreateTime(new Date());
			chargework.setUpdateTime(new Date());
			chargework.setUpdateBy(currentUser.getUsername());
			chargeworkDao.save(chargework);
		}else{
			Chargework dbChargework = chargeworkDao.findById(chargework.getId());
			dbChargework.setUpdateTime(new Date());
			dbChargework.setUpdateTime(new Date());
			//BeanUtils.copyPropertiesIgnore(currentUser,dbChargework,"updateBy,companyname,enddate,post,startdate",false);
			dbChargework.setUpdateBy(currentUser.getUsername());
			dbChargework.setCompanyname(chargework.getCompanyname());
			dbChargework.setEnddate(chargework.getEnddate());
			dbChargework.setPost(chargework.getPost());
			dbChargework.setStartdate(chargework.getStartdate());
			
			chargeworkDao.update(dbChargework);
		}
		
	}

	@Override
	public ChargeworkSearchDto search(ChargeworkSearchDto dto) {
		ChargeworkSearchDto resultDto = new ChargeworkSearchDto();
		List<Chargework> list =  chargeworkDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(chargeworkDao.searchCount(dto));
		return resultDto;
	}

}
