package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.ArmorgteachDao;
import com.bcxin.ars.dao.sb.ArmorgteachDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ArmorgteachSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Armorgteach;
import com.bcxin.ars.service.sb.ArmorgteachService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Armorgteach.class)
public class ArmorgteachServiceImpl implements ArmorgteachService{

	@Autowired
	private ArmorgteachDao armorgteachDao;

	@Autowired
	private ArmorgteachDaoAop armorgteachDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Armorgteach findById(long id) {
		return armorgteachDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Armorgteach shareholder) {
		User currentUser = arsUtil.getCurrentUser();
		if(shareholder.getId() == null){
			shareholder.setActive(true);
			shareholder.setCreateTime(new Date());
			shareholder.setUpdateTime(new Date());
			shareholder.setUpdateBy(currentUser.getUsername());
			armorgteachDao.save(shareholder);
		}else{
			Armorgteach dbArmorgteach = armorgteachDao.findById(shareholder.getId());
			dbArmorgteach.setUpdateTime(new Date());
			dbArmorgteach.setUpdateBy(currentUser.getUsername());
			dbArmorgteach.setJyage(shareholder.getJyage());
			dbArmorgteach.setJygunnum(shareholder.getJygunnum());
			dbArmorgteach.setJyidnum(shareholder.getJyidnum());
			dbArmorgteach.setJysex(shareholder.getJysex());
			dbArmorgteach.setJyname(shareholder.getJyname());
			armorgteachDao.update(dbArmorgteach);
		}
	}

	@Override
	public void saveOrUpdateForDS(Armorgteach shareholder) {
		if(shareholder.getActive() == null){
			shareholder.setActive(true);
		}
		
		Armorgteach dbArmorgteach = armorgteachDao.findById(shareholder.getId());
		if (dbArmorgteach != null) {
			if(shareholder.getUpdateTime().getTime() > dbArmorgteach.getUpdateTime().getTime()){
				shareholder.setCensorstatus(dbArmorgteach.getCensorstatus());
				armorgteachDao.update(shareholder);
			}
		} else {
			armorgteachDao.saveForDS(shareholder);
		}
	}

	@Override
	public ArmorgteachSearchDto search(ArmorgteachSearchDto dto) {
		ArmorgteachSearchDto resultDto = new ArmorgteachSearchDto();
		List<Armorgteach> list =  armorgteachDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(armorgteachDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<Armorgteach> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return armorgteachDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteBySid(String sponsorlicenseid){
		armorgteachDao.deleteBySid(sponsorlicenseid);
	}

	@Override
	public void updateCensorStatus(Armorgteach armorgteach) {
		armorgteach.setUpdateTime(new Date());
		armorgteachDaoAop.updateCensorStatus(armorgteach);
	}
}
