package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.ArmorgchargeDao;
import com.bcxin.ars.dao.sb.ArmorgchargeDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ArmorgchargeSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Armorgcharge;
import com.bcxin.ars.service.sb.ArmorgchargeService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Armorgcharge.class)
public class ArmorgchargeServiceImpl implements ArmorgchargeService{

	@Autowired
	private ArmorgchargeDao armorgchargeDao;

	@Autowired
	private ArmorgchargeDaoAop armorgchargeDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Armorgcharge findById(long id) {
		return armorgchargeDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Armorgcharge shareholder) {
		User currentUser = arsUtil.getCurrentUser();
		if(shareholder.getId() == null){
			shareholder.setActive(true);
			shareholder.setCreateTime(new Date());
			shareholder.setUpdateTime(new Date());
			shareholder.setUpdateBy(currentUser.getUsername());
			armorgchargeDao.save(shareholder);
		}else{
			Armorgcharge dbArmorgcharge = armorgchargeDao.findById(shareholder.getId());
			dbArmorgcharge.setUpdateTime(new Date());
			dbArmorgcharge.setUpdateBy(currentUser.getUsername());
			dbArmorgcharge.setName(shareholder.getName());
			dbArmorgcharge.setIdnum(shareholder.getIdnum());
			dbArmorgcharge.setPhone(shareholder.getPhone());
			armorgchargeDao.update(dbArmorgcharge);
		}
	}

	@Override
	public void saveOrUpdateForDS(Armorgcharge shareholder) {
		if(shareholder.getActive() == null){
			shareholder.setActive(true);
		}
		
		Armorgcharge dbArmorgcharge = armorgchargeDao.findById(shareholder.getId());
		if (dbArmorgcharge != null) {
			if(shareholder.getUpdateTime().getTime() > dbArmorgcharge.getUpdateTime().getTime()){
				shareholder.setCensorstatus(dbArmorgcharge.getCensorstatus());
				armorgchargeDao.update(shareholder);
			}
		} else {
			armorgchargeDao.saveForDS(shareholder);
		}
	}

	@Override
	public ArmorgchargeSearchDto search(ArmorgchargeSearchDto dto) {
		ArmorgchargeSearchDto resultDto = new ArmorgchargeSearchDto();
		List<Armorgcharge> list =  armorgchargeDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(armorgchargeDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<Armorgcharge> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return armorgchargeDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteBySid(String sponsorlicenseid){
		armorgchargeDao.deleteBySid(sponsorlicenseid);
	}

	@Override
	public void updateCensorStatus(Armorgcharge armorgcharge) {
		armorgcharge.setUpdateTime(new Date());
		armorgchargeDaoAop.updateCensorStatus(armorgcharge);
	}
}
