package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dao.RoleDao;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dto.UserRoleSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.service.UserRoleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
public class UserRoleServiceImpl implements UserRoleService{

	@Autowired
	private UserRoleDao userRoleDao;
	
	@Autowired
	private PoliceRoleDao policeRoleDao;
	
	@Autowired
	private RoleDao roleDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public UserRole findById(long id) {
		return userRoleDao.findById(id);
	}

	@Override
	public void saveOrUpdate(UserRole userRole) {
		User currentUser = arsUtil.getCurrentUser();
		if(userRole.getId() == null){
			userRole.setActive(true);
			userRole.setCreateTime(new Date());
			userRole.setUpdateTime(new Date());
			userRole.setUpdateBy(currentUser.getUsername());
			userRoleDao.save(userRole);
		}else{
			UserRole dbUserRole = userRoleDao.findById(userRole.getId());
			dbUserRole.setUpdateBy(currentUser.getUsername());
			dbUserRole.setUpdateTime(new Date());
			dbUserRole.setUserid(userRole.getUserid());
			dbUserRole.setRoleid(userRole.getRoleid());
			userRoleDao.update(dbUserRole);
		}
		
	}

	@Override
	public UserRoleSearchDto search(UserRoleSearchDto dto) {
		UserRoleSearchDto resultDto = new UserRoleSearchDto();
		List<UserRole> list =  userRoleDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(userRoleDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(UserRole userRole) {
		User currentUser = arsUtil.getCurrentUser();
		userRole.setUpdateBy(currentUser.getUsername());
		userRole.setUpdateTime(new Date());
		userRoleDao.delete(userRole);
	}

	@Override
	public List<UserRole> findByUserId(Long userid) {
		return userRoleDao.findByUserId(userid);
	}

	@Override
	public List<UserRole> findByRoleId(Long roleid) {
		return userRoleDao.findByRoleId(roleid);
	}

	@Override
	public List<UserRole> findByUserIdAndRoleType(Long userid,String roleType) {
		List<UserRole> userRoles = userRoleDao.findByUserIdAndRoleType(userid,roleType);
		for (UserRole userRole : userRoles) {
			if(roleType.equals(Constants.ROLETYPE_POLICEROLE)) {
				userRole.setPoliceRole(policeRoleDao.findById(userRole.getRoleid()));
			}else if(roleType.equals(Constants.ROLETYPE_ROLE)) {
				userRole.setRole(roleDao.findById(userRole.getRoleid()));
			}
		}
		return userRoles;
	}

	@Override
	public List<UserRole> findByRoleIdAndRoleType(Long roleid,String roleType) {
		List<UserRole> userRoles = userRoleDao.findByRoleIdAndRoleType(roleid,roleType);
		for (UserRole userRole : userRoles) {
			if(roleType.equals(Constants.ROLETYPE_POLICEROLE)) {
				userRole.setPoliceRole(policeRoleDao.findById(userRole.getRoleid()));
			}else if(roleType.equals(Constants.ROLETYPE_ROLE)) {
				userRole.setRole(roleDao.findById(userRole.getRoleid()));
			}
		}
		return userRoles;
	}

	@Override
	public UserRole findByUserIdAndRoleId(Long userId, Long roleId) {
		return userRoleDao.findByUserIdAndRoleId(userId,roleId);
	}

	@Override
	public List<UserRole> findAll() {
		return userRoleDao.findAll();
	}

	@Override
	public void saveOrUpdateForDS(UserRole userRole) {
		UserRole dbUserRole = userRoleDao.findByUserIdAndRoleId(userRole.getUserid(), userRole.getRoleid());
		if(dbUserRole != null){
			if(userRole.getUpdateTime().getTime() > dbUserRole.getUpdateTime().getTime()){
				userRoleDao.update(userRole);
			}
		}else{
			if(userRole.getActive()) {
				userRoleDao.save(userRole);
			}
		}
	}

}
