package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.PersonSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.util.MapDistance;
import com.bcxin.ars.util.StringUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Darren on 2017/3/29.
 */
public class UrgentTaskThread extends Thread{

    private static final Logger logger = LoggerFactory.getLogger(UrgentTaskThread.class);

    private TaskDao taskDao;

	private SecurityPersonDao personDao;

	private TaskService taskService;

//	private int count = 0;

    private int minute;

    private Long taskId;

    public void run() {
            try {
                Task task = taskDao.findUrgentById(taskId);
                if(task==null){
                    logger.error("获取不到任务信息!!!!");
                    return;
                }
                //判断任务是否结束
                if(task.getTaskStatus()!=null && task.getTaskStatus().getId().equals(3)){
                    logger.error("任务结束 !!!!");
                    return;
                }

                /**
                 * 地点经度
                 */
                String longitude =  task.getLongitude();
                /**
                 * 地点纬度
                 */
                String latitude =  task.getLatitude();
                Map map = MapDistance.getAround(latitude,longitude,(task.getScope()+task.getSendcount() *3000)+"");
                //获取在线人员
                PersonSearchDto dto = new PersonSearchDto();
                /*位置纬度区间*/
                String minLat =   (String)map.get("minLat");
                dto.setMinLat(minLat);
                String maxLat =   (String)map.get("maxLat");
                dto.setMaxLat(maxLat);
                /*位置经度区间*/
                String minLng =   (String)map.get("minLng");
                dto.setMinLng(minLng);
                String maxLng =   (String)map.get("maxLng");
                dto.setMaxLng(maxLng);
                dto.setNativeCode(task.getNativeCode());
                //判断应急员还是在线人员
                if(task.getPeopletype()!=null && !"".equals(task.getPeopletype())){
                    String types[]  =  task.getPeopletype().split(",");
                    for (String type :
                            types) {
                        //应急人员
                        if(type.equals("1")){
                            dto.setUrgenttemp(true);
                        }
                        //在线人员
                        if(type.equals("2")){
                            dto.setOnline(true);
                        }
                    }
                }
               /* SecurityPerson securityPerson = personDao.findById(193l);
                taskService.saveUrgentTaskPerson(task,securityPerson);*/
                //获取应急人员和在线人员
                List<SecurityPerson> onlinePersons = personDao.findOnlineOrUrgentPersons(dto);
                for (SecurityPerson securityPerson : onlinePersons) {
                        //判断人员当前是否有紧急任务，如果有则不推送
                        List<Task> list = taskDao.findAllByPersonId(securityPerson.getId());
                        if(list!=null && list.size()>0){
                            continue;
                        }
                        if(!taskService.saveUrgentTaskPerson(task,securityPerson)){//关联保安人员并且做消息推送，若人员满了返回false
                            return;
                        }
				}
                //超过15公园不再更新
                if(task.getSendcount()!=null && task.getSendcount()>10){
                    return;
                }
                //更新推送次数
                task.setSendcount(task.getSendcount()+1);
                task.setUpdateTime(new Date());
                taskDao.updateSendCount(task.getId(),task.getSendcount());
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
                return;
            }
    }


    public SecurityPersonDao getPersonDao() {
        return personDao;
    }

    public TaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setPersonDao(SecurityPersonDao personDao) {
        this.personDao = personDao;
    }
    public TaskDao getTaskDao() {
        return taskDao;
    }

    public void setTaskDao(TaskDao taskDao) {
        this.taskDao = taskDao;
    }

    public int getMinute() {
        return minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
}
