package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityGoodThingDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGoodThingDetailDTO;
import com.bcxin.ars.dto.SecurityGoodThingDto;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.SecurityGoodThingService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 保安员好人好事要闻服务类
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityGoodThing.class)
public class SecurityGoodThingServiceImpl implements SecurityGoodThingService {

    @Autowired
    private SecurityGoodThingDao securityGoodThingDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public void save(SecurityGoodThing securityGoodThing) {
        Long id = arsUtil.getCurrentUser().getId();
        String realname = arsUtil.getCurrentUser().getRealname();
        if (arsUtil.getCurrentUser().getPlatform() == 2) {
            securityGoodThing.setUserid(arsUtil.getCurrentUser().getId());
        }

        SecurityPerson dbPerson = securityPersonDao.findById(securityGoodThing.getPersonId());
        securityGoodThing.setUserid(id);
        securityGoodThing.setCreateTime(new Date());
        securityGoodThing.setUpdateTime(new Date());
        securityGoodThing.setActive(true);
        securityGoodThing.setUpdateBy(realname);
        securityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
        securityGoodThing.setPhone(dbPerson.getPhone());
        securityGoodThing.setIdNumber(dbPerson.getIdNumber());
        securityGoodThingDao.save(securityGoodThing);
    }

    @Override
    public List<SecurityGoodThing> findByUserid(Long userid) {
        return securityGoodThingDao.findByUserid(userid);
    }

    @Override
    public SecurityGoodThing findById(Long id) {
        return securityGoodThingDao.findById(id);
    }

    @Override
    public SecurityGoodThingDto search(SecurityGoodThingDto dto) {
        List<SecurityGoodThing> securityGoodThings = securityGoodThingDao.search(dto);
        Long searchCount = securityGoodThingDao.searchCount(dto);
        dto.setData(securityGoodThings);
        dto.setTotalCount(searchCount);
        return dto;
    }

    @Override
    public AjaxResult searchGoodThing(SecurityGoodThingDto dto) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
                result.setData(search(dto));
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @Override
    public SecurityGoodThing updateById(SecurityGoodThing securityGoodThing) {
        String realname = arsUtil.getCurrentUser().getRealname();
        SecurityGoodThing dbSecurityGoodThing = securityGoodThingDao.findById(securityGoodThing.getId());
        SecurityPerson dbPerson = securityPersonDao.findById(securityGoodThing.getPersonId());
        dbSecurityGoodThing.setUpdateTime(new Date());
        dbSecurityGoodThing.setActive(true);
        dbSecurityGoodThing.setUpdateBy(realname);
        dbSecurityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
        dbSecurityGoodThing.setContent(securityGoodThing.getContent());
        dbSecurityGoodThing.setDepartment(securityGoodThing.getDepartment());
        dbSecurityGoodThing.setGoodThingDate(securityGoodThing.getGoodThingDate());
        dbSecurityGoodThing.setIdNumber(dbPerson.getIdNumber());
        dbSecurityGoodThing.setName(securityGoodThing.getName());
        dbSecurityGoodThing.setPersonId(securityGoodThing.getPersonId());
        dbSecurityGoodThing.setPhone(dbPerson.getPhone());
        dbSecurityGoodThing.setRemark(securityGoodThing.getRemark());
        return securityGoodThingDao.updateById(dbSecurityGoodThing);
    }

    @Override
    public AjaxResult deleteGoodThing(long id) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                SecurityGoodThing securityGoodThing = new SecurityGoodThing();
                securityGoodThing.setId(id);
                securityGoodThing.setUpdateBy(user.getRealname());
                securityGoodThing.setUserid(user.getId());
                securityGoodThing.setUpdateTime(new Date());
                securityGoodThingDao.delete(securityGoodThing);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @Override
    public AjaxResult deleteAllGoodThing() {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                SecurityGoodThing securityGoodThing = new SecurityGoodThing();
                securityGoodThing.setUserid(user.getId());
                securityGoodThing.setUpdateBy(user.getUsername());
                securityGoodThing.setUpdateTime(new Date());
                securityGoodThingDao.deleteByUserid(securityGoodThing);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @Override
    public List<SecurityGoodThing> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return securityGoodThingDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForDS(SecurityGoodThing securityGoodThing) {

        if (securityGoodThing.getActive() == null) {
            securityGoodThing.setActive(true);
        }

        if (!securityGoodThing.getActive()) {
            securityGoodThingDao.delete(securityGoodThing);
        } else {
            SecurityGoodThing dbSecurityGoodThing = securityGoodThingDao.findById(securityGoodThing.getId());
            if (dbSecurityGoodThing == null) {
                securityGoodThingDao.saveForDS(securityGoodThing);
            } else {
                if (securityGoodThing.getUpdateTime().getTime() > dbSecurityGoodThing.getUpdateTime().getTime()) {
                    securityGoodThingDao.updateById(securityGoodThing);
                }
            }
        }
    }

    @Override
    public SecurityGoodThingDetailDTO findByIdForPerson(Long id) {
        return securityGoodThingDao.findByIdForPerson(id);
    }

    @Override
    public void exportSecurityGoodThing(List<SecurityGoodThing> data, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("好人好事信息");
//			wb.setSheetHidden(1, true);
            //标题
            String[] handers = {"姓名", "身份证号", "手机号", "所属公司", "日期", "好人好事内容"}; //列标题
            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            //写标题

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                //   cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;
            for (SecurityGoodThing securityGoodThing : data) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell = row.createCell(0);
                // nameCell.setCellStyle(style);
                nameCell.setCellValue(securityGoodThing.getName()); //往单元格里写数据

                HSSFCell socialCodeCell = row.createCell(1);
                // socialCodeCell.setCellStyle(style);
                socialCodeCell.setCellValue(securityGoodThing.getIdNumber());

                HSSFCell legalPersonCell = row.createCell(2);
                // legalPersonCell.setCellStyle(style);
                legalPersonCell.setCellValue(securityGoodThing.getPhone()); //往单元格里写数据

                HSSFCell phoneCell = row.createCell(3);
                // phoneCell.setCellStyle(style);
                phoneCell.setCellValue(securityGoodThing.getCompanyName()); //往单元格里写数据


                HSSFCell addressCell = row.createCell(4);
                //addressCell.setCellStyle(style);
                addressCell.setCellValue(securityGoodThing.getGoodThingDate()); //往单元格里写数据

                HSSFCell locationCell = row.createCell(5);
                //   locationCell.setCellStyle(style);
                locationCell.setCellValue(securityGoodThing.getContent()); //往单元格里写数据

            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PageResult searchSecuritygoodthingList_table(Map<Object, Object> p) {
        return new PageResult(securityGoodThingDao.countSecuritygoodthingList(p), securityGoodThingDao.searchSecuritygoodthingList(p));
    }

    @Override
    public void deleteGoodThingByGoodDeedsId(Long goodDeedsId) {
           securityGoodThingDao.deleteGoodThingByGoodDeedsId(goodDeedsId);
    }

    @Override
    public void saveOrUpdateForSAAS(SecurityGoodThing securityGoodThing) {

        User user = arsUtil.getCurrentUser();
        SecurityPerson dbPerson = securityPersonDao.findById(securityGoodThing.getPersonId());
        //判断是否存在，如果存在则为更新否则为保存
        SecurityGoodThing dbSecurityGoodThing = securityGoodThingDao.findByGoodDeedsId(securityGoodThing.getGoodDeedsId());
        if (dbSecurityGoodThing != null) {
            String realname = user.getRealname();
            dbSecurityGoodThing.setUpdateTime(new Date());
            dbSecurityGoodThing.setActive(true);
            dbSecurityGoodThing.setUpdateBy(realname);
            if (null != dbPerson && null != dbPerson.getRelation() && null != dbPerson.getRelation().getCompany()) {
                dbSecurityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
            }

            dbSecurityGoodThing.setContent(securityGoodThing.getContent());
            dbSecurityGoodThing.setDepartment(securityGoodThing.getDepartment());
            dbSecurityGoodThing.setGoodThingDate(securityGoodThing.getGoodThingDate());
            if (null != dbPerson ) {
                dbSecurityGoodThing.setIdNumber(dbPerson.getIdNumber());
            }

            dbSecurityGoodThing.setName(securityGoodThing.getName());
            dbSecurityGoodThing.setPersonId(securityGoodThing.getPersonId());
            if (null != dbPerson) {
                dbSecurityGoodThing.setPhone(dbPerson.getPhone());
            }

            if(StringUtil.isEmpty(securityGoodThing.getGoodDeedsType())){
                dbSecurityGoodThing.setGoodDeedsType(securityGoodThing.getGoodDeedsType());
            }
            dbSecurityGoodThing.setRemark(securityGoodThing.getRemark());
            securityGoodThingDao.updateByGoodDeedsId(dbSecurityGoodThing);
        } else {
            Long id = arsUtil.getCurrentUser().getId();
            String realname = arsUtil.getCurrentUser().getRealname();
            if (arsUtil.getCurrentUser().getPlatform() == 2) {
                securityGoodThing.setUserid(arsUtil.getCurrentUser().getId());
            }

            securityGoodThing.setUserid(id);
            securityGoodThing.setCreateTime(new Date());
            securityGoodThing.setUpdateTime(new Date());
            securityGoodThing.setActive(true);
            securityGoodThing.setUpdateBy(realname);
            if (null != dbPerson && null != dbPerson.getRelation() && null != dbPerson.getRelation().getCompany()) {
                securityGoodThing.setCompanyName(dbPerson.getRelation().getCompany().getName());
            }
            if (null != dbPerson) {
                securityGoodThing.setPhone(dbPerson.getPhone());
            }
            if (null != dbPerson ) {
                securityGoodThing.setIdNumber(dbPerson.getIdNumber());
            }


            securityGoodThingDao.save(securityGoodThing);


        }
    }

    @Override
    public SecurityGoodThing findByGoodDeedsId(Long goodDeedsId) {
        return securityGoodThingDao.findByGoodDeedsId(goodDeedsId);
    }

    @Override
    public List<SecurityGoodThing> query(SecurityGoodThingDto dto, AjaxPageResponse<SecurityGoodThing> ajaxPageResponse) {
        return securityGoodThingDao.query(dto,ajaxPageResponse);
    }
}
