package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SearchHistoryDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.HistorySearchDto;
import com.bcxin.ars.model.SearchHistory;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SearchHistoryService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 搜索历史服务类
 * @author Ethan
 */

@Service
@Transactional
public class SearchHistoryServiceImpl implements SearchHistoryService{

	@Autowired
	private SearchHistoryDao searchHistoryDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void save(SearchHistory searchHistory) {
		searchHistoryDao.save(searchHistory);
	}

	@Override
	public List<SearchHistory> findByUserid(Long userid) {
		return searchHistoryDao.findByUserid(userid);
	}

	@Override
	public SearchHistory findById(Long id) {
		return searchHistoryDao.findById(id);
	}

	@Override
	public void save(String context,String searchType,User user){
		SearchHistory searchHistory = new SearchHistory();
		searchHistory.setActive(true);
		searchHistory.setContext(context);
		searchHistory.setSearchType(searchType);
		searchHistory.setCreateTime(new Date());
		searchHistory.setUpdateBy(user.getRealname());
		searchHistory.setUpdateTime(new Date());
		searchHistory.setUserid(user.getId());
		searchHistoryDao.save(searchHistory);
	}

	@Override
	public void saveOrUpdate(String context,String searchType,User user){
		HistorySearchDto dto = new HistorySearchDto();
		dto.setContext(context);
		dto.setSearchType(searchType);
		dto.setUserid(user.getId());
		dto.setPaging(false);
		SearchHistory searchHistory = null;
		List<SearchHistory> data = searchHistoryDao.search(dto);
		if(data == null || data.size() <1){
			searchHistory = new SearchHistory();
			searchHistory.setActive(true);
			searchHistory.setContext(context);
			searchHistory.setSearchType(searchType);
			searchHistory.setCreateTime(new Date());
			searchHistory.setUpdateBy(user.getRealname());
			searchHistory.setUpdateTime(new Date());
			searchHistory.setUserid(user.getId());
			searchHistoryDao.save(searchHistory);
		}else{
			searchHistory = data.get(0);
			searchHistory.setUpdateTime(new Date());
			searchHistoryDao.update(searchHistory);
		}
	}
	
	@Override
	public HistorySearchDto search(HistorySearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null) {
			return null;
		}
		List<SearchHistory> data = searchHistoryDao.search(dto);
		Long count = searchHistoryDao.searchCount(dto);
		dto.setData(data);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public AjaxResult searchHistory(HistorySearchDto dto){
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null){
				dto.setUserid(user.getId());
				result.setData(search(dto));
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
				result.setMsg("当前用户信息错误");
			}
		} catch(Exception e) {
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

	@Override
	public AjaxResult deleteHistory(long id) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null){
				SearchHistory searchHistory = new SearchHistory();
				searchHistory.setId(id);
				searchHistory.setUpdateBy(user.getUsername());
				searchHistory.setUpdateTime(new Date());
				searchHistoryDao.delete(searchHistory);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
				result.setMsg("当前用户信息错误");
			}
		} catch(Exception e) {
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

	@Override
	public AjaxResult deleteAllHistory() {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null){
				SearchHistory searchHistory = new SearchHistory();
				searchHistory.setUserid(user.getId());
				searchHistory.setUpdateBy(user.getUsername());
				searchHistory.setUpdateTime(new Date());
				searchHistoryDao.deleteByUserid(searchHistory);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
				result.setMsg("当前用户信息错误");
			}
		} catch(Exception e) {
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

	@Override
	public void searchForPage(HistorySearchDto searchDto, AjaxPageResponse<SearchHistory> page) {
		User user = arsUtil.getCurrentUser();
		searchDto.setUserid(user.getId());
		searchHistoryDao.seachForPage(searchDto,page);
	}

}