package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.RoleDao;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Role;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.service.RoleService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Role.class)
public class RoleServiceImpl implements RoleService {

	@Autowired
	private RoleDao roleDao;

	@Autowired
	private UserRoleDao userRoleDao;
	
	@Autowired
	private UserDao userDao;
	
	@Autowired
	private SecurityCompanyPersonDao companyPersonDao;

	@Autowired
	private ArsUtil arsUtil;

	@Override
	public List<Role> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
		return roleDao.searchForDataSynchronization(dto);
	}

	@Override
	public void saveOrUpdate(Role role) {

		Role checkRole = roleDao.findByCompanyRoleName(role.getCompany().getId(), role.getName());
		if(role.getId() == null) {
			if(checkRole != null){
				throw new ArsException("角色名已存在！");
			}
			role.setNativeCode(arsUtil.getCurrentNatvie());
			role.setActive(true);
			role.setCreateTime(new Date());
			role.setUpdateTime(new Date());
			role.setUpdateBy(arsUtil.getCurrentUser().getUsername());
			roleDao.save(role);
		} else {
			if(checkRole != null && checkRole.getId() != role.getId()){
				throw new ArsException("角色名已存在！");
			}
			Role dbRole = roleDao.findById(role.getId());
			if(dbRole != null){
				dbRole.setUpdateTime(new Date());
				dbRole.setUpdateBy(arsUtil.getCurrentUser().getUsername());
				if(!StringUtils.isEmpty(role.getName())){
					dbRole.setName(role.getName());
				}
				if(role.getCompany() != null && role.getCompany().getId() != null && role.getCompany().getId() > 0){
					dbRole.setCompany(role.getCompany());
				}
				roleDao.update(dbRole);
			}
		}
	}

	@Override
	public void delete(Role role) {
		List<UserRole> userRoleList = userRoleDao.findByRoleId(role.getId());
		if(userRoleList.size() > 0) {
			/*Role dbRole = roleDao.findById(role.getId());
			String error = "无法删除“" + dbRole.getName() + "”角色, 请先变更如下人员角色：";
			for(UserRole cp : userRoleList) {
				User user = userDao.findById(cp.getUserid());
				if(user != null) {
					error += user.getRealname() + ",";
				}
			}
			throw new ArsException(error);*///#7643
			throw new ArsException("该角色已被引用，不允许删除。");
		} else {
			role.setUpdateTime(new Date());
			role.setUpdateBy(arsUtil.getCurrentUser().getUsername());
			roleDao.delete(role);
		}
	}

	@Override
	public Role findById(Long id) {
		return roleDao.findById(id);
	}

	@Override
	public List<Role> findByCompany(Long companyId) {
		return roleDao.findByCompany(companyId);
	}

	@Override
	public List<Role> findByCompanyAll(Long companyId) {
		return roleDao.findByCompanyAll(companyId);
	}
	@Override
	public void saveOrUpdateForDS(Role role) {

		if(role.getActive() == null){
			role.setActive(true);
		}
		
		if(!role.getActive()){
			roleDao.delete(role);
			return;
		}
		Role dbRole = findById(role.getId());
		if(dbRole == null) {
			roleDao.saveForDS(role);
		} else {
			if(role.getUpdateTime().getTime() > dbRole.getUpdateTime().getTime()){
				roleDao.update(role);
			}
		}
	}

	@Override
	public List<Role> findByUserId(Long userId) {
		return roleDao.findByUserId(userId);
	}

	@Override
	public List<Role> findByUserIdCompanyId(Long userId, Long companyId) {
		return roleDao.findByUserIdCompanyId(userId, companyId);
	}

}
