package com.bcxin.ars.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.service.ProjectChangeService;
import com.bcxin.ars.service.ProjectChangeService;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ProjectChangeServiceImpl implements ProjectChangeService {
    private Logger logger = LoggerFactory.getLogger(ProjectChangeService.class);
    @Autowired
    private ProjectChangeDao projectChangeDao;


    @Override
    public List<ProjectChange> getProjectChangeList() {
        List<ProjectChange> lis = projectChangeDao.getProjectChangeList();
        return lis;
    }

    @Override
    public ProjectChange findById(Long id) {
        return projectChangeDao.findById(id);
    }
    @Override
    public AjaxResult saveOrUpdate(ProjectChange projectChange, User user){
        AjaxResult ajaxResult=new AjaxResult();
        if (projectChange.getId() != null){
            ProjectChange dbProjectChange = projectChangeDao.findById(projectChange.getId());
            if (dbProjectChange!=null){
                dbProjectChange.setUpdateTime(new Date());
                dbProjectChange.setUpdateBy(user.getUsername());
                BeanUtils.copyPropertiesIgnore(projectChange,dbProjectChange,true);
                projectChangeDao.update(dbProjectChange);
            }else{
                projectChange.setCreateTime(new Date());
                projectChange.setUpdateTime(new Date());
                projectChange.setUserid(user.getId());
                projectChange.setUpdateBy(user.getUsername());
                projectChangeDao.save(projectChange);
            }
        }
        return  ajaxResult;
    }

    @Override
    public List<ProjectChange> findByCertificateIdAndType(String certificateId,String type) {
        return projectChangeDao.findByCertificateIdAndType(certificateId,type);
    }

}
