package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.ProblemPersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.service.util.SysDictUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional
@DataSyncAnnotation(getClazz = ProblemPerson.class)
@DataSyncOutAnnotation(getClazz = ProblemPerson.class)
public class ProblemPersonServiceImpl implements ProblemPersonService {


	/***
	 * 日志
	 */
	private static final Logger logger = LoggerFactory.getLogger(ProblemPersonServiceImpl.class);

	@Autowired
	private ProblemPersonDao problemPersonDao;

	@Autowired
	private ProblemPersonDaoAop problemPersonDaoAop;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;

	@Autowired
	private SecurityPersonDao personDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private SysDictUtils sysDictUtils;
	@Autowired
	private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
	@Autowired
	private SAASInterfaceUtil saasInterfaceUtil;

	@Override
	public void search(ProblemPersonSearchDto searchDto, AjaxPageResponse page) {
		//当前用户
		User currentUser = arsUtil.getCurrentUser();
		arsUtil.setPoliceSearch(searchDto);
//		公安端
		if(Constants.PLATFORM_POLICE == currentUser.getPlatform()) {
			//机构信息,所属区域过滤
			arsUtil.setPoliceSearch(searchDto);
		}else{
			//公司端
			SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
			searchDto.setCompanyId(company.getId());
		}

		problemPersonDao.search(searchDto,page);
	}
	@Override
	public void searchall(ProblemPersonSearchDto searchDto, AjaxPageResponse page) {
		//当前用户
		User currentUser = arsUtil.getCurrentUser();
		arsUtil.setPoliceSearch(searchDto);
//		公安端
		if(Constants.PLATFORM_POLICE == currentUser.getPlatform()) {
			//机构信息,所属区域过滤
			arsUtil.setPoliceSearch(searchDto);
		}else{
			//公司端
			SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
			searchDto.setCompanyId(company.getId());
		}

		problemPersonDao.searchall(searchDto,page);
	}

	@Override
	public void saveOrUpdate(ProblemPerson problemPerson) {
		User currentUser = arsUtil.getCurrentUser();
		if(problemPerson.getId() == null) {
			problemPerson.setCreateTime(new Date());
			problemPerson.setUpdateflag(true);
			problemPerson.setUpdateBy(currentUser.getUsername());
			problemPersonDao.save(problemPerson);
		}else {
			ProblemPerson dbProblemPerson = problemPersonDao.findById(problemPerson.getId());
			dbProblemPerson.setCompanyid(problemPerson.getCompanyid());
			dbProblemPerson.setCompanyname(problemPerson.getCompanyname());
			dbProblemPerson.setDispose(problemPerson.getDispose());
			dbProblemPerson.setIdnumber(problemPerson.getIdnumber());
			dbProblemPerson.setName(problemPerson.getName());
			dbProblemPerson.setPhone(problemPerson.getPhone());
			dbProblemPerson.setProblemtype(problemPerson.getProblemtype());
			dbProblemPerson.setSex(problemPerson.getSex());
			dbProblemPerson.setSuggestion(problemPerson.getSuggestion());
			dbProblemPerson.setUpdateBy(currentUser.getUsername());
			dbProblemPerson.setUpdateTime(new Date());
			dbProblemPerson.setCz(problemPerson.getCz());
			dbProblemPerson.setXd(problemPerson.getXd());
			dbProblemPerson.setZt(problemPerson.getZt());
			dbProblemPerson.setWf(problemPerson.getWf());
			dbProblemPerson.setUpdateflag(true);
			problemPersonDaoAop.update(dbProblemPerson);
		}

	}

	@Override
	public void delete(ProblemPerson problemPerson) {
		User currentUser = arsUtil.getCurrentUser();
		problemPerson.setUpdateBy(currentUser.getUsername());
		problemPerson.setUpdateTime(new Date());
		problemPerson.setUpdateflag(true);
		problemPersonDaoAop.delete(problemPerson);
	}

	@Override
	public ProblemPerson findById(Long id) {
		return problemPersonDao.findById(id);
	}

	@Override
	public void saveDispose(ProblemPerson problemPerson) {
		User currentUser = arsUtil.getCurrentUser();
		ProblemPerson dbProblemPerson = problemPersonDao.findById(problemPerson.getId());
		//处理状态
		dbProblemPerson.setDispose(problemPerson.getDispose());
		//处理意见
		dbProblemPerson.setSuggestion(problemPerson.getSuggestion());
		//通知企业
		dbProblemPerson.setInform(problemPerson.getInform());
		//处理人员
		dbProblemPerson.setUpdateBy(currentUser.getUsername());
		//处理人员
		dbProblemPerson.setHandler(currentUser.getRealname());
        //处理人机构
        dbProblemPerson.setHandlerOrg(currentUser.getPolice().getOrgname());
        //更新时间
		dbProblemPerson.setUpdateTime(new Date());
		//更新标记
		dbProblemPerson.setUpdateflag(true);
		//内部意见
        dbProblemPerson.setReson(problemPerson.getReson());
        //抓获状态
        dbProblemPerson.setCatchState(problemPerson.getCatchState());
		dbProblemPerson.setHandleDate(new Date());

		problemPersonDaoAop.update(dbProblemPerson);
	}


    @Override
    public void saveCompanyDispose(ProblemPerson problemPerson) {
        ProblemPerson dbProblemPerson = problemPersonDao.findById(problemPerson.getId());
        //处理状态
        dbProblemPerson.setDisposeCompany(problemPerson.getDisposeCompany());
        //处理意见
        dbProblemPerson.setCompanyReson(problemPerson.getCompanyReson());
        //更新时间
        dbProblemPerson.setUpdateTime(new Date());
		dbProblemPerson.setComHandleDate(new Date());
        problemPersonDaoAop.updateForCompany(dbProblemPerson);
    }

	@Override
	public ProblemPersonReportDto getDataReport(ProblemPersonSearchDto searchDto) {
		ProblemPersonReportDto reportDto = problemPersonDao.getProblemPersonReport(searchDto);
		PersonSearchDto dto = new PersonSearchDto();
		User user = arsUtil.getCurrentUser();
		dto.setUserid(user.getId());
		dto.setPath(user.getPolice().getPath());
		Long totalCount = personDao.searchAllCount(dto);
		reportDto.setTotalCount(totalCount);
		reportDto.setCensorCount(totalCount);

		return reportDto;
	}

	@Override
	public void saveOrUpdateForDS(ProblemPerson problemPerson) {
		if(problemPerson.getActive() == null){
			problemPerson.setActive(true);
		}
		if(!problemPerson.getActive()){
			problemPersonDaoAop.delete(problemPerson);
		}else{
			ProblemPerson dbProblemPerson = problemPersonDao.findById(problemPerson.getId());
			//问题人员是内网新增，只有更新
            if(problemPerson.getUpdateTime().getTime() > dbProblemPerson.getUpdateTime().getTime()){
                //外网更新到内网，更新字段有：阅读状态、更新时候、更新标识、单位处理状态、单位处理意见，SaaS消息ID
                problemPersonDaoAop.updateDS(problemPerson);
            }
		}
	}

	@Override
	public List<ProblemPerson> findProblemPersonList() {
		return problemPersonDao.findProblemPersonList();
	}



	@Override
	public List<ProblemPerson> findDSOutList(String startDate) {
		return problemPersonDao.searchForExport(startDate);
	}


	@Override
	public List<String> queryProblemType(String personType) {
		//获取问题人员类型列表
		List<String> list = problemPersonDao.queryProblemType(personType);
		//返回的字符串
		List<String> result =  new ArrayList<>();
		//临时存储
		Map<String,String> map= new HashMap<>();
		//循环获取问题人员类型列表
		for (String s:
				list) {
			//判断是否为空
			if(StringUtil.isNotEmpty(s)) {
				//以逗号分隔
				String[] types = s.split(",");
				for (String type:
						types) {
                    if(map.get(type)==null ){
                        result.add(type);
                        map.put(type,type);
                    }
				}
			}
		}
		return result;
	}
    @Override
    public List<String> queryProblemTypeForCompanyId(Long companyId) {
        //获取问题人员类型列表
        List<String> list = problemPersonDao.queryProblemTypeForCompanyId(companyId);
        //返回的字符串
        List<String> result =  new ArrayList<>();
        //临时存储
        Map<String,String> map= new HashMap<>();
        //循环获取问题人员类型列表
        for (String s:
                list) {
            //判断是否为空
            if(StringUtil.isNotEmpty(s)) {
                //以逗号分隔
                String[] types = s.split(",");
                for (String type:
                        types) {
                    //如果为空，则加到列表中
                    if(map.get(type)==null){
                        result.add(type);
                        map.put(type,type);
                    }
                }
            }
        }
        return result;
    }

	@Override
	public void updateReadstateByidArr(Long[] newIds) {
		problemPersonDaoAop.updateReadstateByidArr(newIds);
	}

    @Override
    public Map<Object, Object> countAlarm() {
        Map<Object, Object> result  = new HashMap<>();
        User currentUser = arsUtil.getCurrentUser();
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        if (config.getValue().equals(Constants.POLICE_IN)   && currentUser!=null) {
            //机构信息
            Police police = policeDao.findById(currentUser.getOrgid());
            //机构信息
            String areacode = police.getAreacode();
            //问题人员个数
            ProblemPersonSearchDto problemPersonSearchDto = new ProblemPersonSearchDto();
            if (areacode.endsWith("0000")) {
                problemPersonSearchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                problemPersonSearchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {// 区
                problemPersonSearchDto.setAreaCode(areacode);
            }
            //判断是否为派出所
            if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
                problemPersonSearchDto.setOrgId(police.getId());
            }

            //前科人员
            problemPersonSearchDto.setPersonType(Constants.PERSONTYPE_CRIMINAL);
            result.put("problemCount", problemPersonDao.getProblemTotalOver12(problemPersonSearchDto));
            //在逃人员
            problemPersonSearchDto.setPersonType(Constants.PERSONTYPE_LARGE);
            result.put("atLargePersonCount", problemPersonDao.getProblemTotalOver12(problemPersonSearchDto));
            //重要信息有误
			problemPersonSearchDto.setPersonType(Constants.PERSONTYPE_INFO);
			result.put("infoErrorPersonCount", problemPersonDao.getProblemTotalOver12(problemPersonSearchDto));

            //统计企业未处理问题人员
            result.put("problemFirmCount", problemPersonDao.getProblemFirmTotalOver12(problemPersonSearchDto));
        }
        return result;
    }


	@Override
	public Long getUnDisposeQty() {
		User currentUser = arsUtil.getCurrentUser();
		SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
		return problemPersonDao.getUnDisposeQty(company.getId());
	}

	/**
	 * 批量导入
	 * @param list
	 */
	@Override
	public void importBatch(List<ProblemPerson> list) {
        List<ProblemPerson> dbList = problemPersonDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size() > 0) {
            List<Long> idList = list.stream().map(ProblemPerson::getCompanyid).collect(Collectors.toList());
            /****
             * 步骤1 先更新子站问题人员数据，再异步调用saas保存消息ID
             */
            //问题类型只保留：主项信息不符合、姓名信息错误
            for (ProblemPerson detail : list) {
                //问题类型只保留：身份证号不存在、姓名信息错误
                StringBuffer problemtype = new StringBuffer();
                if (StringUtil.isNotEmpty(detail.getProblemtype())) {
                    if (detail.getProblemtype().indexOf(Constants.LIBRARYTYPE_CZ_FAIL) >= 0) {
                        problemtype.append(Constants.LIBRARYTYPE_CZ_FAIL).append(",");
                    }
                    if (detail.getProblemtype().indexOf(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE) >= 0) {
                        problemtype.append(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE).append(",");
                    }
                    if (problemtype.length() > 0) {
                        problemtype.deleteCharAt(problemtype.length() - 1);
                        detail.setProblemtype(problemtype.toString());
                    } else {
                        detail.setProblemtype(null);
                    }
                }
                detail.setUpdateflag(false);
                try {
                    detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
            //批量保存
            problemPersonDaoAop.saveBatch(list);
            /***
             * 步骤2 异常调用saas保存消息ID
             */
            new Thread(() -> {
                List<SaaSCompany> companyList = securityCompanyDao.findUserNameByBatchId(idList);
                if (companyList != null && companyList.size() > 0) {
                    Map<String, String> localMap = companyList.stream().collect(Collectors.toMap(SaaSCompany::getId, SaaSCompany::getComId));
                    for (ProblemPerson detail : list) {
                                try {
                                    /**
                                     * 满足下面三个条件 调saas消息通知接口
                                     * 告知企业
                                     * saas回传消息id为空
                                     * 处理意见不为空
                                     */
                                    if (Constants.DISPOSE_YES.equals(detail.getDispose())
                                            && StringUtil.isEmpty(detail.getNewId())
                                            && StringUtil.isNotEmpty(detail.getSuggestion())) {
                                        SAASMessageDto messageDto = new SAASMessageDto();
                                        messageDto.setTitle(Constants.PROBLEMPERSON_TITLE);
                                        //内容
                                        String context = Constants.PROBLEMPERSON_CONTENT;
                                        //姓名
                                        context = context.replace("{name}", detail.getName());
                                        //身份证号
                                        context = context.replace("{idnumber}", detail.getIdnumber());
                                        //公安建议处理措施
                                        String inform = sysDictUtils.getDictTypeValue("inform", detail.getInform());
                                        context = context.replace("{inform}", inform);
                                        //公安意见
                                        context = context.replace("{suggestion}", detail.getSuggestion());
                                        messageDto.setContent(context);
                                        String comId = localMap.get(detail.getCompanyid() + "");
                                        if (StringUtil.isEmpty(comId)) {
                                            logger.error("保百盾公司id:" + detail.getCompanyid() + "没有对应的saas公司id");
                                            return;
                                        }
                                        messageDto.setComIds(comId);
                                        messageDto.setMessageType(Constants.MESSAGETYPE_050302);
                                        messageDto.setPoliceRegionId(detail.getAreaCode());
                                        //兼容旧数据，如果处理人机构没有则发送监管机构
                                        if (StringUtil.isNotEmpty(detail.getHandlerOrg())) {
                                            messageDto.setSendPer(detail.getHandlerOrg());
                                        } else {
                                            messageDto.setSendPer(detail.getOrgName());
                                        }
                                        messageDto.setIsNeedCallBackBBD("1");
                                        AjaxResult result = saasInterfaceUtil.sendSaasMsg(messageDto);
                                        if (result.isSuccessful()) {
                                            //存储公共服务平台消息ID，用于后续已读消息使用
                                            detail.setNewId(result.getData().toString());
                                        }
                                        //保存数据
                                        problemPersonDaoAop.updateNewId(detail);
                                    }

                                } catch (Exception e) {
                                    logger.error(e.getMessage(), e);
                                } finally {
                                }
                    }
                }
            }).start();
        }
    }


	@Override
	public List<ProblemPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
		return problemPersonDao.searchForDataSynchronization(dto);
	}

}
