package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.sys.ModulePermissionDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PoliceRoleSearchDto;
import com.bcxin.ars.dto.page.PoliceRoleDto;
import com.bcxin.ars.dto.page.RolePageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sys.ModulePermission;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Transactional
@DataSyncAnnotation(getClazz = PoliceRole.class)
@DataSyncOutAnnotation(getClazz = PoliceRole.class)
public class PoliceRoleServiceImpl implements PoliceRoleService{
    /**
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(PoliceRoleServiceImpl.class);
	@Autowired
	private PoliceRoleDao policeRoleDao;
	
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private PermissionDao permissionDao;

	@Autowired
	private OperationDao operationDao;

	@Autowired
	private DataAuthDao dataAuthDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private ModulePermissionDao modulePermissionDao;

	@Autowired
	private IdWorker idWorker;

	@Value("${personcertificate-download-folder}")
	private String tempftpFolder;
	@Override
	public PoliceRole findById(long id) {
		return policeRoleDao.findById(id);
	}

	@Override
	public void saveOrUpdate(PoliceRole policeRole,Long[] operationIds,String orgIds) {
		User currentUser = arsUtil.getCurrentUser();
		//判断数据是否有重复名称
		PoliceRole checkRole = findByOrgIdAndRoleName(policeRole.getOrgid(),policeRole.getRolename());
        //新增
		if(policeRole.getId() == null){
            if(checkRole != null){
                throw new ArsException("该机构下，已存在此角色名称!");
            }
			policeRole.setActive(true);
			policeRole.setCreateTime(new Date());
			policeRole.setUpdateTime(new Date());
			policeRole.setCreaterorg(currentUser.getOrgName());
			policeRole.setUpdateBy(currentUser.getUsername());
			policeRole.setUpdateflag(true);
			policeRoleDao.save(policeRole);
		}else{
		    //更新
            if(checkRole != null && checkRole.getId().intValue() != policeRole.getId().intValue()){
                throw new ArsException("该机构下，已存在此角色名称!");
            }
            PoliceRole dbPoliceRole = policeRoleDao.findById(policeRole.getId());
            dbPoliceRole.setUpdateBy(currentUser.getUsername());
            dbPoliceRole.setUpdateTime(new Date());
            //值复制
            BeanUtils.copyPropertiesIgnore(policeRole,dbPoliceRole,true);
            dbPoliceRole.setUpdateflag(true);
            policeRoleDao.update(dbPoliceRole);

            //删除功能权限和数据权限
            permissionDao.deleteByRole(policeRole.getId(), Constants.ROLETYPE_POLICEROLE);
            dataAuthDao.deleteByRole(policeRole.getId());
		}
		//批量新增角色
        if(operationIds != null && operationIds.length > 0) {
            List<Permission> permissionList = new ArrayList<>();
            List<Operation> operationList =  operationDao.findByIdArray(operationIds);
            for (Long operationId : operationIds) {
                Permission permission = new Permission();
                permission.setNativeCode(arsUtil.getCurrentNatvie());
                permission.setRoleid(policeRole.getId());
                Operation operation = null;
                for (Operation temp:operationList
                     ) {
                    if(temp.getId().longValue() ==  operationId.longValue()){
                        operation =  temp;
                    }
                }
                if(operation == null){
                    continue;
                }
                permission.setOperation(operation);
                permission.setModule(operation.getModule());
                permission.setRoletype(Constants.ROLETYPE_POLICEROLE);
                permissionList.add(permission);
            }
            permissionDao.insertBatch(permissionList);
        }
        /***
         * 批量新增数据权限
         */
        //前端传过来的参数以，为分割符
        if(StringUtil.isNotEmpty(orgIds)) {
            List<DataAuth> dataAuthList =  new ArrayList<>();
            for (String orgid : orgIds.split(",")) {
                if (StringUtil.isNotEmpty(orgid)) {
                    //定义临时数据权限对象
                    DataAuth auth = new DataAuth();
                    auth.setActive(true);
                    auth.setCreateTime(new Date());
                    auth.setUpdateTime(new Date());
                    auth.setUpdateBy(currentUser.getUsername());
                    //角色ID
                    auth.setRoleid(policeRole.getId());
                    //机构
                    auth.setOrgid(Long.parseLong(orgid));
                    dataAuthList.add(auth);
                }
            }
            dataAuthDao.insertBatch(dataAuthList);
        }
	}

	@Override
	public String findApprovalRole(PoliceRoleSearchDto dto) {

		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 1) {
			return null;
		}

		String key = "sp";
		String areaCode ="";
		Police police = null;
		if(StringUtil.isEmpty(dto.getOrgIds()) && user.getOrgid() != null){
			dto.setOrgIds(user.getOrgid()+"");
			//获取当前机构信息
			police = policeDao.findById(user.getOrgid());

		}else{
			police = policeDao.findById(Long.parseLong(dto.getOrgIdList()[dto.getOrgIdList().length-1]));//Long.parseLong(dto.getOrgIds()+"")
		}
		//区域
		if(police!=null) {
			areaCode = police.getAreacode();
			if(areaCode.endsWith("0000")){//省
				areaCode = areaCode.substring(0,2)+"0000";
			}else {
				areaCode = areaCode.substring(0,4)+"00";
			}
		}
		key +=areaCode+police.getOrgtype();

		Config approvalrole = configDao.findByKey(key);
		if(approvalrole!=null){
			return approvalrole.getValue();
		}
		return null;
	}

	/**
	 * 根据公安机构ID删除公安角色
	 * @param orgId
	 * by llc 2018-08-28
	 */
	@Override
	public  void deleteRoleByOrgId(Long orgId){
		policeRoleDao.deleteRoleByOrgId(orgId);
	}

	private PoliceRole findByOrgIdAndRoleName(Long orgid, String rolename) {
		return policeRoleDao.findByOrgIdAndRoleName(orgid,rolename);
	}

	@Override
	public PoliceRoleSearchDto search(PoliceRoleSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 1) {
			return null;
		}


		if(dto.getOrgid() == null && user.getOrgid() != null){
			dto.setOrgid(user.getOrgid());
			//获取当前机构信息
			Police police = policeDao.findById(user.getOrgid());
			if(dto.getQueryType()==null || dto.getQueryType().equals("")) {
				//判断是否为市级
				if(police.getOrgtype()!=null) {
					if (police.getOrgtype().equals("4")) {//派出所
						dto.setOrgtype("4");
					} else if (police.getOrgtype().equals("1")) {//省
						dto.setOrgtype("1");
					} else if (police.getOrgtype().equals("2")) {//市
						dto.setOrgtype("2");
					} else {//区
						dto.setOrgtype("3");
					}
				}
			}
		}else{
			Police police = policeDao.findById(dto.getOrgid());//Long.parseLong(dto.getOrgIds()+"")
			if(dto.getQueryType()==null || dto.getQueryType().equals("")) {
				//判断是否为市级
				if(police.getOrgtype()!=null) {
					if (police.getOrgtype().equals("4")) {//派出所
						dto.setOrgtype("4");
					} else if (police.getOrgtype().equals("1")) {//省
						dto.setOrgtype("1");
					} else if (police.getOrgtype().equals("2")) {//市
						dto.setOrgtype("2");
					} else {//区
						dto.setOrgtype("3");
					}
				}
			}
		}
//		if(StringUtil.isEmpty(dto.getOrgIds()) && user.getOrgid() != null){
//			dto.setOrgIds(user.getOrgid()+"");
//		}
		List<PoliceRole> list =  policeRoleDao.search(dto);
		Long count = policeRoleDao.searchCount(dto);
		dto.setData(list);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public void delete(PoliceRole policeRole) {
		User currentUser = arsUtil.getCurrentUser();
		PoliceRoleSearchDto dto = new PoliceRoleSearchDto();
		dto.setRoleid(policeRole.getId());
		dto.setRoletype(Constants.ROLETYPE_POLICEROLE);
		List<PoliceRole> roles = policeRoleDao.findByRoleId(dto);
		if(roles != null && roles.size() > 0){
			throw new ArsException("该角色已有用户，不允许删除！");
		}
		
		policeRole.setUpdateBy(currentUser.getUsername());
		policeRole.setUpdateTime(new Date());
		policeRole.setUpdateflag(true);
		policeRoleDao.delete(policeRole);
	}

	@Override
	public List<PoliceRole> findByUserId(Long userid) {
		return policeRoleDao.findByUserId(userid);
	}

	@Override
	public List<PoliceRole> findByRoleId(Long roleid) {
		PoliceRoleSearchDto dto = new PoliceRoleSearchDto();
		dto.setRoleid(roleid);
		dto.setRoletype(Constants.ROLETYPE_POLICEROLE);
		return policeRoleDao.findByRoleId(dto);
	}

	@Override
	public List<PoliceRole> findAll() {
		return policeRoleDao.findAll();
	}

	/**
	 * 外网导内网专用 （修改内网导外网完成标记）
	 */
	@Override
	public void saveOrUpdateForDS(PoliceRole policeRole) {
		PoliceRole dbPoliceRole = policeRoleDao.findById(policeRole.getId());
		if(dbPoliceRole == null){
//			policeRoleDao.saveForDS(policeRole);//公安角色只在内网创建，所以外网导内网不新增。
		}else{
			if(policeRole.getUpdateTime().getTime() > dbPoliceRole.getUpdateTime().getTime()){
				if(!policeRole.getActive()){
					policeRoleDao.delete(policeRole);
				}else{
					policeRoleDao.update(policeRole);
				}
			}
		}
	}

	@Override
	public PoliceRoleSearchDto searchForUser(PoliceRoleSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 1) {
			return null;
		}
		List<PoliceRole> list =  policeRoleDao.searchForUser(dto);
		dto.setData(list);
		return dto;
	}

	private void writeTxtFile(String readStr, String type) {
//    	System.out.println(type);
		try {
			String basePath = tempftpFolder;    //路径
			String filePath = basePath + com.bcxin.ars.util.DateUtil.getCurrentDate() + File.separator;//保存路径

			String fileName = type;
			String fileType = ".data";
			File file = new File(filePath);
			if (!file.exists()) {
				file.mkdirs();
				System.out.println("文件夹已创建");
			}
			String fullFilePath = filePath + fileName + "_"+ com.bcxin.ars.util.DateUtil.getCurrentDateTime(com.bcxin.ars.util.DateUtil.FORMAT8) + fileType;

			//文件处理：写入文件
			File newFile = new File(fullFilePath);
			Files.write(readStr.getBytes(), newFile);
		} catch (Exception e) {
			System.out.println("导出失败！");
		}
	}

	@Override
	public void autoExportPoliceRole() {
		List<PoliceRole> policeRoleList = policeRoleDao.searchForExport();

		if (policeRoleList != null && policeRoleList.size() > 0) {
			try {
				for (PoliceRole p:policeRoleList) {

					p.setUpdateflag(false);
					String policeRoleStr = JSONArray.toJSONString(p);
					System.out.println(policeRoleStr);
					String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(policeRoleStr.getBytes(), Constants.APPROVAL_KEY));
					writeTxtFile(content, "policerole");


					List<Permission> permissionList = permissionDao.findByRoleid(p.getId().toString());
					if (permissionList != null && permissionList.size() > 0) {

						String permissionListStr = JSONArray.toJSONString(permissionList);
						String permissionListcontent = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(permissionListStr.getBytes(), Constants.APPROVAL_KEY));
						writeTxtFile(permissionListcontent, "permission");

					}


					policeRoleDao.updateFlag(p);


				}

			} catch (Exception e) {
				System.out.println("导出失败！");
			}
		}

	}

	@Override
	@Deprecated
	public void saveOrUpdateForImport(PoliceRole policeRole) {
		policeRole.setUpdateflag(false);
		PoliceRole dbPoliceRole = policeRoleDao.findById(policeRole.getId());
		if(dbPoliceRole == null){
			policeRole.setUpdateTime(new Date());
			policeRoleDao.saveForDS(policeRole);
			List<Permission> permissionlist = policeRole.getPermissionlist();
			permissionDao.deleteByRole(policeRole.getId(), Constants.ROLETYPE_POLICEROLE);
			if(permissionlist != null  && permissionlist.size() > 0){
				for (Permission permission : permissionlist) {
					permissionDao.save(permission);
				}
			}
			List<DataAuth> dataAuthlist = policeRole.getDataAuthlist();
			dataAuthDao.deleteByRole(policeRole.getId());
			for (DataAuth dataAuth : dataAuthlist) {
				dataAuthDao.save(dataAuth);
			}
			
		}else{
			if(policeRole.getUpdateTime().getTime() > dbPoliceRole.getUpdateTime().getTime()){
				policeRole.setUpdateTime(new Date());
				policeRoleDao.update(policeRole);
				List<Permission> permissionlist = policeRole.getPermissionlist();
				permissionDao.deleteByRole(policeRole.getId(), Constants.ROLETYPE_POLICEROLE);
				if(permissionlist != null  && permissionlist.size() > 0){
					for (Permission permission : permissionlist) {
						permissionDao.save(permission);
					}
				}
				List<DataAuth> dataAuthlist = policeRole.getDataAuthlist();
				dataAuthDao.deleteByRole(policeRole.getId());
				for (DataAuth dataAuth : dataAuthlist) {
					dataAuthDao.save(dataAuth);
				}
			}
		}
	}

	@Override
	public List<PoliceRole> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return policeRoleDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public List<PoliceRole> findDSOutList(String startDate) {
		return policeRoleDao.searchFromInToOutForExport(startDate);
	}

	/**
	 * 批量导入
	 * @param list
	 */
	@Override
	public void importBatch(List<PoliceRole> list){
		List<PoliceRole> dbList = policeRoleDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);

		if (list.size()>0){
			for(PoliceRole detail:list){
				detail.setUpdateflag(false);
				try {
					detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
				}catch (Exception e){
				    logger.error(e.getMessage(),e);
				}
				List<Permission> permissionlist = detail.getPermissionlist();
				permissionDao.deleteByRole(detail.getId(), Constants.ROLETYPE_POLICEROLE);
				if(permissionlist != null  && permissionlist.size() > 0){
					permissionDao.saveBatch(permissionlist);
				}
				List<DataAuth> dataAuthlist = detail.getDataAuthlist();
				dataAuthDao.deleteByRole(detail.getId());
				if(dataAuthlist != null  && dataAuthlist.size() > 0) {
					dataAuthDao.insertBatch(dataAuthlist);
				}
			}
			//批量保存
			policeRoleDao.saveBatch(list);
		}
	}

	@Override
	public void searchForPage(RolePageSearchDto dto, AjaxPageResponse<PoliceRoleDto> page) {
		policeRoleDao.searchForPage(dto,page);
	}

	@Override
	public void save(PoliceRole policeRole,String[] menuIds, String[] orgIds) {

		User currentUser = arsUtil.getCurrentUser();
		//判断数据是否有重复名称
		PoliceRole checkRole = findByOrgIdAndRoleName(policeRole.getOrgid(),policeRole.getRolename());
		//新增
		if(policeRole.getId() == null){
			if(checkRole != null){
				throw new ArsException("该机构下，已存在此角色名称!");
			}
            policeRole.setId(idWorker.nextId());
			policeRole.setActive(true);
			policeRole.setCreateTime(new Date());
			policeRole.setUpdateTime(new Date());
			policeRole.setCreaterorg(currentUser.getOrgName());
			policeRole.setUpdateBy(currentUser.getUsername());
			policeRole.setUpdateflag(true);
			policeRoleDao.save(policeRole);
		}else{
			//更新
			if(checkRole != null && checkRole.getId().intValue() != policeRole.getId().intValue()){
				throw new ArsException("该机构下，已存在此角色名称!");
			}
			PoliceRole dbPoliceRole = policeRoleDao.findById(policeRole.getId());
			dbPoliceRole.setUpdateBy(currentUser.getUsername());
			dbPoliceRole.setUpdateTime(new Date());
			//值复制
			BeanUtils.copyPropertiesIgnore(policeRole,dbPoliceRole,true);
			dbPoliceRole.setUpdateflag(true);
			policeRoleDao.update(dbPoliceRole);

			//删除功能权限和数据权限
			modulePermissionDao.deleteByRoleId(policeRole.getId());
			dataAuthDao.deleteByRole(policeRole.getId());
		}
		//批量新增角色
		if(menuIds != null && menuIds.length > 0) {

            List<ModulePermission> dbList = modulePermissionDao.findByRoleId(policeRole.getId());
            Map<Long, ModulePermission> dbMap = new HashMap<>();
            if(dbList.size() > 0){
                dbMap = dbList.stream().collect(Collectors.toMap(ModulePermission::getModuleMenuId, Function.identity()));
            }
			List<ModulePermission> permissionList = new ArrayList<>();

			ModulePermission permission = null;
			for (String menuIdStr : menuIds) {
			    Long menuId = Long.parseLong(menuIdStr);
			    if(menuId<=1){
			        continue;
                }
                if(dbMap.get(menuId) != null){
                    permission =dbMap.get(menuId);
                }else{
                    permission = new ModulePermission();
                    permission.setId(idWorker.nextId());
                    permission.setActive(true);
                    permission.setCreateTime(new Date());
                    permission.setModuleMenuId(menuId);
                    permission.setRoleId(policeRole.getId());
                }
                permission.setActive(true);
                permission.setUpdateTime(new Date());
                permission.setUpdateflag(true);
                permission.setUpdateBy(currentUser.getUsername());
				permissionList.add(permission);
			}
			modulePermissionDao.saveBatch(permissionList);
		}
		/***
		 * 批量新增数据权限
		 */
		if(orgIds != null && orgIds.length > 0) {
			List<DataAuth> dataAuthList =  new ArrayList<>();
            DataAuth auth = null;
			for (String orgIdStr : orgIds) {
			    Long orgId = Long.parseLong(orgIdStr);
                //定义临时数据权限对象
                auth = new DataAuth();
                auth.setId(idWorker.nextId());
                auth.setActive(true);
                auth.setCreateTime(new Date());
                auth.setUpdateTime(new Date());
                auth.setUpdateBy(currentUser.getUsername());
                //角色ID
                auth.setRoleid(policeRole.getId());
                //机构
                auth.setOrgid(orgId);
                dataAuthList.add(auth);
			}
			dataAuthDao.insertBatch(dataAuthList);
		}
	}
}
