package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.PersonBlackListDao;
import com.bcxin.ars.dto.PerBlackListDto;
import com.bcxin.ars.dto.PoliceDto;
import com.bcxin.ars.dto.page.PersonBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBlackList;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.PersonBlackListService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.bcxin.ars.enums.ImportType;
import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/05/13 0013 11:01
 */
@Service
@DataSyncOutAnnotation(getClazz = PersonBlackList.class,getImportType = ImportType.BATCH)
public class PersonBlackListServiceImpl implements PersonBlackListService {

    @Autowired
    private PersonBlackListDao personBlackListDao;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;



    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ConfigUtils configUtils;

    @Override
    public PersonBlackList findById(Long id) {
        return personBlackListDao.findById(id);
    }

    @Override
    public void update(PersonBlackList detail) {
        User currentUser = arsUtil.getCurrentUser();
        //detail.setSex(IdNumUtil.getSexByIdCard(detail.getIdNum()));
        if(detail.getId() == null){
            detail.setId(idGeneratorUtil.createID());
            detail.setCreateTime(new Date());
            detail.setActive(true);
            detail.setAreaCode(currentUser.getPolice().getAreacode());
        }else{
            PersonBlackList dbPersonBlackList = personBlackListDao.findById(detail.getId());
            BeanUtils.copyPropertiesIgnore(detail,dbPersonBlackList,true);
            BeanUtils.copyPropertiesIgnore(dbPersonBlackList,detail,true);
        }
        detail.setUpdateTime(new Date());
        detail.setUpdateBy(currentUser.getUsername());
        detail.setUpdateflag(true);
        personBlackListDao.save(detail);
    }

    @Override
    public void delete(PersonBlackList detail) {
        User currentUser = arsUtil.getCurrentUser();
        detail.setUpdateflag(true);
        detail.setUpdateTime(new Date());
        detail.setUpdateBy(currentUser.getUsername());
        personBlackListDao.delete(detail);
    }

    @Override
    public List<PersonBlackList> searchForPage(PersonBlackListPageSearchDto dto, AjaxPageResponse<PersonBlackListDto> ajaxPageResponse) {
        return personBlackListDao.searchForPage(dto,ajaxPageResponse);
    }

    @Override
    public List<PersonBlackList> findByBatchId(List<PersonBlackList> list) {
        return personBlackListDao.findByBatchId(list);
    }

    @Override
    public void saveBatch(List<PersonBlackList> list) {
        List<PersonBlackList> dbList = personBlackListDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for(PersonBlackList detail:list){
                detail.setUpdateflag(false);
                try {
                    detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                }catch (Exception e){

                }
            }
            //批量保存
            personBlackListDao.saveBatch(list);
        }
    }
    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    public List<PersonBlackList> findDSOutList(String startDate) {
        return personBlackListDao.findDSOutList(startDate);
    }

    /**
     * 内网数据同步到外网
     * @param list
     */
    public void importBatch(List<PersonBlackList> list) {
        List<PersonBlackList> dbList = personBlackListDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (PersonBlackList personBlackList : list) {
                personBlackList.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        personBlackList.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, personBlackList.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            personBlackListDao.saveBatch(list);
        }
    }

    /**
     * 定时抽取行业黑名单
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public List<PerBlackListDto> findBlackPersonList(Date startTime, Date endTime) {
        //获取省份id
        Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
        Integer province = Integer.parseInt(provinceConfig.getValue());
        List<PerBlackListDto> perBlackListDtoList = personBlackListDao.selectBlackByUpdateTime(startTime,endTime);
        perBlackListDtoList.forEach(perBlackListDto -> {
            perBlackListDto.setProvince(province);
            //saas是否删除
            perBlackListDto.setIsDelete(Constants.ISDELETE_No);
        });
        return perBlackListDtoList;
    }
}
