package com.bcxin.ars.service.impl;

import java.util.Date;
import java.util.List;

import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.model.PoliceRole;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bcxin.ars.dao.OperationDao;
import com.bcxin.ars.dao.PermissionDao;
import com.bcxin.ars.model.Operation;
import com.bcxin.ars.model.Permission;
import com.bcxin.ars.service.PermissionService;
import com.bcxin.ars.service.util.ArsUtil;

@Service
public class PermissionServiceImpl implements PermissionService {

	@Autowired
	private PermissionDao permissionDao;
	
	@Autowired
	private OperationDao operationDao;

	@Autowired
	private PoliceRoleDao policeRoleDao;

	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public List<Permission> findByRole(Long roleid, String roletype,String moduletype) {
		return permissionDao.findByRole(roleid, roletype,moduletype);
	}

	@Override
	public void save(Permission permission) {
		permissionDao.save(permission);
	}
	
	@Override
	public void saveOrUpdate(Long roleid, Long[] operationIds, String roletype) {
		permissionDao.deleteByRole(roleid, roletype);
		for (Long operationId : operationIds) {
			Permission permission = new Permission();
			permission.setNativeCode(arsUtil.getCurrentNatvie());
			permission.setRoleid(roleid);
			Operation operation = operationDao.findById(operationId);
			permission.setOperation(operation );
			permission.setModule(operation.getModule());
			permission.setRoletype(roletype);
			permissionDao.save(permission);
		}

		//已授权
		if(roletype.equals("2")){
			PoliceRole policeRole = policeRoleDao.findById(roleid);
			policeRole.setOprole("1");
			policeRole.setUpdateTime(new Date());
			policeRoleDao.update(policeRole);
		}
	}

	@Override
	public void delete(Permission permission) {
		permissionDao.delete(permission);
	}

	@Override
	public void deleteByRole(Long roleid, String roletype) {
		permissionDao.deleteByRole(roleid, roletype);
	}

	@Override
	public List<Permission> findByUserId(Long userid) {
		return permissionDao.findByUserId(userid);
	}


	@Override
	public List<Permission> findByGAUserId(Long userid) {
		return permissionDao.findByGAUserId(userid);
	}

	@Override
	public List<Permission> findAllForPlatform(Integer platform) {
		return permissionDao.findAllForPlatform(platform);
	}

	@Override
	public void saveOrUpdateForDS(Permission permission) {
		Permission dbPermission = permissionDao.findByOperationIdAndRoleId(permission.getOperationid(), permission.getRoleid());
		if(dbPermission == null){
			permissionDao.save(permission);
		}
	}
}
