package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.OrganizationDao;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.OrganizationSAASDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.OrganizationService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Organization.class)
public class OrganizationServiceImpl implements OrganizationService {

    @Autowired
    private OrganizationDao orgDao;

    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public Organization findById(long id) {
        return orgDao.findById(id);
    }

    @Override
    public List<Organization> findByParentId(long parentId) {
        return orgDao.findByParentId(parentId);
    }

    @Override
    public void delete(Organization org) {
        List<Organization> childrenOrgs = orgDao.findByParentId(org.getId());
        List<SecurityCompanyPerson> companyPerson = companyPersonDao.findByOrgId(org.getId());
        if (childrenOrgs != null && childrenOrgs.size() > 0) {
            throw new ArsException("请先删除下级部门");
        } else if (companyPerson.size() > 0) {
            String error = "无法删除ID为：" + org.getId() + " 组织结构, 请先变更如下人员结构：";
            for (SecurityCompanyPerson cp : companyPerson) {
                error += cp.getPerson().getRealName() + ",";
            }
            throw new ArsException(error);
        } else {
            org.setUpdateTime(new Date());
            org.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            orgDao.delete(org);
        }
    }

    @Override
    public List<Organization> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return orgDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdate(Organization org) {
        Organization dbOrg = orgDao.findById(org.getId());
        if (dbOrg == null) {
            org.setNativeCode(arsUtil.getCurrentNatvie());
            org.setActive(true);
            org.setCreateTime(new Date());
            org.setUpdateTime(org.getCreateTime());
            org.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            orgDao.save(org);
        } else {

            if (dbOrg != null) {
                dbOrg.setUpdateTime(new Date());
                dbOrg.setUpdateBy(arsUtil.getCurrentUser().getUsername());
                if (!StringUtils.isEmpty(org.getName())) {
                    dbOrg.setName(org.getName());
                }
                if (org.getCompany() != null && org.getCompany().getId() != null && org.getCompany().getId() > 0) {
                    dbOrg.setCompany(org.getCompany());
                }
                //如果没有传父级部门则清空
                if (org.getParent() != null && org.getParent().getId() != null && org.getParent().getId() > 0) {
                    dbOrg.setParent(org.getParent());
                }else{
                    dbOrg.setParent(null);
                }
                orgDao.update(dbOrg);
            }
        }
    }

    @Override
    public void saveOrUpdateBatch(List<OrganizationSAASDTO> organizationSAASDTOList, SecurityCompany company) {
        List<OrganizationSAASDTO> noExistList = new ArrayList<>();
        List<OrganizationSAASDTO> organizationList = new ArrayList<>();
        List<Organization> dbOrgList = orgDao.findByBatchId(organizationSAASDTOList);
      String username=  arsUtil.getCurrentUser().getUsername();
      Date newDate=  new Date();

        for (OrganizationSAASDTO org : organizationSAASDTOList) {
            noExistList.add(org);
            //数据库存在
            if (dbOrgList.size() > 0) {
                for (Organization dbOrg : dbOrgList) {
                    if (dbOrg.getId().equals(org.getId())) {
                        noExistList.remove(org);

                        OrganizationSAASDTO organizationSAASDTO =new OrganizationSAASDTO();
                        BeanUtils.copyPropertiesIgnore(dbOrg, organizationSAASDTO,true);
                        organizationSAASDTO.setUpdateTime(newDate);
                        organizationSAASDTO.setUpdateBy(username);
                        if (!StringUtils.isEmpty(org.getName())) {
                            organizationSAASDTO.setName(org.getName());
                        }
                        if (company != null && company.getId() != null && company.getId() > 0) {
                            organizationSAASDTO.setCompanyId(company.getId());
                        }
                        if (org.getParentId() != null&& org.getParentId() > 0) {
                            organizationSAASDTO.setParentId(org.getParentId());
                        }
                        organizationList.add(organizationSAASDTO);
                    }

                }
            }
            //数据库不存在
            if (noExistList.size()>0){
                for (OrganizationSAASDTO noExist:noExistList){
                    noExist.setNativeCode(arsUtil.getCurrentNatvie());
                    noExist.setActive(true);
                    noExist.setCreateTime(newDate);
                    noExist.setUpdateTime(org.getCreateTime());
                    noExist.setUpdateBy(username);
                    organizationList.add(noExist);
                }
            }

        }
        orgDao.updateBatch(organizationList);
    }

    @Override
    public List<Organization> findByCompany(long companyId) {
        return orgDao.findByCompany(companyId);
    }

    @Override
    public void saveOrUpdateForDS(Organization organization) {

        if (organization.getActive() == null) {
            organization.setActive(true);
        }

        if (!organization.getActive()) {
            orgDao.delete(organization);
            return;
        }
        Organization dbOrganization = findById(organization.getId());
        if (dbOrganization == null) {
            orgDao.saveForDS(organization);
        } else {
            if (organization.getUpdateTime().getTime() > dbOrganization.getUpdateTime().getTime()) {
                orgDao.update(organization);
            }
        }
    }

    @Override
    public Long queryCount(Organization organization) {
        return orgDao.queryCount(organization);
    }

    /***
     * 通过单位ID查出所有部门信息
     * @param companyId
     * @return
     * by llc 2018-08-29
     */
    @Override
    public List<OrganizationDto> findOrgInfoByCompanyId(long companyId) {
        return orgDao.findOrgInfoByCompanyId(companyId);
    }

    @Override
    public List<OrganizationDto> findByParentIdAndCompanyId(OrganizationDto orgDto) {
        return orgDao.findByParentIdAndCompanyId(orgDto);
    }
}
