package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.OrderTransactionDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.OrderTransaction;
import com.bcxin.ars.service.OrderTransactionService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 交易订单服务类
 * @author Ethan
 */

@Service
@Transactional
//@DataSyncAnnotation(getClazz = OrderTransaction.class)
public class OrderTransactionServiceImpl implements OrderTransactionService{

	@Autowired
	private OrderTransactionDao orderTransactionDao;

	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void save(OrderTransaction orderTransaction) {
		orderTransactionDao.save(orderTransaction);
	}

	@Override
	public OrderTransaction findById(Long id) {
		return orderTransactionDao.findById(id);
	}

	@Override
	public OrderTransaction findByOrderId(Long orderId) {
		return orderTransactionDao.findByOrderId(orderId);
	}

	@Override
	public void update(OrderTransaction transaction) {
		// TODO Auto-generated method stub
		transaction.setUpdateTime(new Date());
		orderTransactionDao.update(transaction);
	}

	@Override
	public OrderTransaction findByOrderNo(String orderNo) {
		return orderTransactionDao.findByOrderNo(orderNo);
	}

	@Override
	public List<OrderTransaction> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return orderTransactionDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(OrderTransaction orderTransaction) {

		if(orderTransaction.getActive() == null){
			orderTransaction.setActive(true);
		}
		
		if(!orderTransaction.getActive()){
			orderTransactionDao.delete(orderTransaction);
		}else{
			OrderTransaction dbOrderTransaction = orderTransactionDao.findById(orderTransaction.getId());
			if(dbOrderTransaction == null){
				orderTransactionDao.saveForDS(orderTransaction);
			}else{
				if(orderTransaction.getUpdateTime().getTime() > dbOrderTransaction.getUpdateTime().getTime()){
					orderTransactionDao.update(orderTransaction);
				}
				
			}
		}
	}
	
}