package com.bcxin.ars.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.OrderNoLogDao;
import com.bcxin.ars.model.OrderNoLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.OrderNoLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;

@Service
@Transactional
public class OrderNoLogServiceImpl implements OrderNoLogService {

	@Autowired
	private OrderNoLogDao orderNoLogDao;

	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void save(OrderNoLog orderNoLog) {
		orderNoLogDao.save(orderNoLog);
	}

	@Override
	public OrderNoLog findById(Long id) {
		return orderNoLogDao.findById(id);
	}

	@Override
	public List<OrderNoLog> findListByDate(String date) {
		return orderNoLogDao.findListByDate(date);
	}

	@Override
	public Long findMaxSerialNoByDate(String date) {
		return orderNoLogDao.findMaxSerialNoByDate(date);
	}

	@Override
	public String getNewOrderNo() {
		User user = arsUtil.getCurrentUser();
		String today = DateUtil.getCurrentDate("yyyyMMdd");
		Long serialNo = orderNoLogDao.findMaxSerialNoByDate(today);
		if(serialNo == null){
			serialNo = 1l;
		}else{
			serialNo = serialNo + 1;
		}
		String orderNo = today + StringUtil.addZero(serialNo+"", 3);
		
		OrderNoLog orderNoLog = new OrderNoLog();
		orderNoLog.setActive(true);
		orderNoLog.setCreateTime(new Date());
		orderNoLog.setDate(today);
		orderNoLog.setOrderNo(orderNo);
		orderNoLog.setSerialNo(serialNo);
		orderNoLog.setUpdateBy(user.getUsername());
		orderNoLog.setUpdateTime(new Date());
		
		orderNoLogDao.save(orderNoLog);
		return orderNo;
	}
	
}
