package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.ModuleDao;
import com.bcxin.ars.dao.PermissionDao;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.model.Module;
import com.bcxin.ars.model.Permission;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ModuleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class ModuleServiceImpl implements ModuleService {

	@Autowired
	private ModuleDao moduleDao;

	@Autowired
	private PermissionDao permissionDao;

	@Autowired
	private ArsUtil arsUtil;
	@Override
	public List<Module> findByUserId(Long userid) {
		return moduleDao.findByUserId(userid);
	}

	@Override
	public Map<Long, Module> findAll() {
		List<Module> list = moduleDao.findAll();
		Map<Long, Module> data = new HashMap<Long, Module>();
		for(Module module : list) {
			data.put(module.getId(), module);
		}
		return data;
	}

	@Override
	public List<Module> findAllPerson() {
		return moduleDao.findAllPerson();
	}

	@Override
	public List<Module> findAllPolice(Long userId) {
		//参数
		Module module= new Module();
		module.setModuletype(Constants.POLICE_ROLE);
		module.setUserId(userId);
		return moduleDao.findByType(module);
	}

	/**
	 * 获取角色权限树形
	 * @return
	 */
	@Override
	public List<ZTree> getModuleTree() {
		User user = arsUtil.getCurrentUser();
		//参数
		Module module= new Module();
		//角色类型：公安
		module.setModuletype(Constants.POLICE_ROLE);
		//用户id
		module.setUserId(user.getId());
		List<ZTree> list = moduleDao.getModuleTreeForAdmin(module);
		List<ZTree> resultList = new ArrayList<>();
		//判断是否有权限
		if(Constants.ADMIN_YES.equals(user.getIsAdmin())) {
			//超管获取全部菜单权限
			return list;
		}else{
			//非超管根据用户ID获取权限
			List<Permission> permissionList = permissionDao.findByGAUserId(user.getId());
			List<Long> ids = permissionList.stream().map(Permission::getModulePId).collect(Collectors.toList());
			Map<String, String> mKeyMap = new HashMap<>();
			if(ids != null) {
				List<Module> modules = moduleDao.findByIdArray(ids);
				for (Module dbModule : modules) {
					mKeyMap.put("M" +dbModule.getpId(),dbModule.getpId()+"");
				}
			}
			Map<String, String> oKeyMap = new HashMap<>();
			for (Permission permission : permissionList) {
				mKeyMap.put("M" +permission.getModulePId(),permission.getModulePId()+"");
				mKeyMap.put("M" +permission.getModule().getId(),permission.getModule().getId()+"");
				oKeyMap.put(permission.getOperation().getId()+"",permission.getOperation().getId()+"");

			}
			for (ZTree zTree : list) {
				if( zTree.getType().equals("0")){
					if(StringUtil.isEmpty(zTree.getpId()) || mKeyMap.get(zTree.getId()) != null){
						resultList.add(zTree);
					}
				}else{
					if(oKeyMap.get(zTree.getId()) != null){
						resultList.add(zTree);
					}
				}
			}
			return resultList;
		}
	}

	@Override
	public List<Module> findByIdArray(List<Long> ids) {
		return moduleDao.findByIdArray(ids);
	}
}
