package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.Bdgk_baDao;
import com.bcxin.ars.model.Bdgk_ba;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.Bdgk_baService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.zw.dao.PctinfoDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class Bdgk_baServiceImpl implements Bdgk_baService {


    public static void main(String[] args) {
        System.out.println("于  海".replaceAll(" ", ""));
    }


    @Autowired
    private Bdgk_baDao bdgk_baDao;

    @Autowired
    private PctinfoDao pctinfoDao;



    private static BackGroupCensorService backGroupCensorService;


    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }
    /**
     * 获取所有数据
     * @return
     */
    @Override
    public List<Bdgk_ba> findAll(){
        return  bdgk_baDao.findAll();
    }
    /***
     * 更新
     * @param ba
     * @return
     */
    @Override
   public void update(Bdgk_ba ba){
       ba.setName(ba.getName().replaceAll(" ", ""));
       try {
           getBackGroupCensorService();
           //八大库
           String reson = backGroupCensorService.getCensorResult(ba.getCard(), ba.getName());
           //String reson =   clientUtil.queryAndBGInfo(ba.getCard(),ba.getName());
           if (StringUtil.isNotEmpty(reson)) {
               ba.setReson(reson);
               //修改调用方法 根据不同环境，调用不同接口获取
               PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(ba.getCard(),false);
               if(personBaseInfo != null) {
                   ba.setRealname(personBaseInfo.getName());
               }
           } else {
               ba.setReson("正常");
           }
           bdgk_baDao.update(ba);
       }catch (Exception e){
           e.printStackTrace();
       }
    }

    @Override
    public void updateHandleData() {
       List<Bdgk_ba> list =  findAll();
        getBackGroupCensorService();
        for (Bdgk_ba ba : list) {
            //八大库
             String reson =   backGroupCensorService.getCensorResult(ba.getCard(),ba.getName());
            //String reson =   clientUtil.queryAndBGInfo(ba.getCard(),ba.getName());
             if(StringUtil.isNotEmpty(reson)){
                 ba.setReson(reson);
             }else{
                 ba.setReson("正常");
             }
            //指纹库
            List listZW  =  pctinfoDao.findByIdnumber(ba.getCard());
            if(listZW!=null && listZW.size()>0){
                Pctinfo pctinfo = (Pctinfo)listZW.get(0);
                ba.setZw(pctinfo.getBarcode());
            }
            bdgk_baDao.update(ba);
        }
    }
}
