package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.certificate.GradeCompleteCerDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeCompleteCerPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.net.URLEncoder;
import java.util.Date;
import java.util.List;

/**
 * 保安员等级证报名结业证书Service实现类
 *
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradeCompleteCer.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
@DataSyncOutAnnotation(getClazz = GradeCompleteCer.class)
public class GradeCompleteCerServiceImpl extends BaseService implements GradeCompleteCerService {

    Logger logger = LoggerFactory.getLogger(GradeCompleteCerServiceImpl.class);


    @Value("${BBD_H5_URL}")
    private String bbdH5Url;

    @Autowired
    private GradeCompleteCerDao gradeCompleteCerDao;

    @Autowired
    private PersonGradeDao personGradeDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(GradeCompleteCer gradeCompleteCer) {
        User currentUser = arsUtil.getCurrentUser();
        gradeCompleteCer.setUpdateTime(new Date());
        gradeCompleteCer.setUpdateBy(currentUser.getUsername());
        return gradeCompleteCerDao.delete(gradeCompleteCer);
    }

    @Override
    public int save(GradeCompleteCer gradeCompleteCer) {
        User currentUser = arsUtil.getCurrentUser();
        if(gradeCompleteCer.getId() == null){
            gradeCompleteCer.setCreateTime(new Date());
        }else{
            GradeCompleteCer dbGradeCompleteCer = gradeCompleteCerDao.findById(gradeCompleteCer.getId());
            BeanUtils.copyPropertiesIgnore(gradeCompleteCer,dbGradeCompleteCer,true);
            BeanUtils.copyPropertiesIgnore(dbGradeCompleteCer,gradeCompleteCer,false);
        }

        gradeCompleteCer.setActive(true);
        gradeCompleteCer.setUpdateBy(currentUser.getUsername());
        gradeCompleteCer.setUpdateTime(new Date());
        gradeCompleteCer.setUpdateflag(true);
        gradeCompleteCer.setAreaCode(currentUser.getPolice().getAreacode());
        return gradeCompleteCerDao.save(gradeCompleteCer);
    }

    @Override
    public GradeCompleteCer findById(Long id) {
        return gradeCompleteCerDao.findById(id);
    }

    @Override
    public void searchForPage(GradeCompleteCerPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        gradeCompleteCerDao.searchForPage(dto,page);
    }


    @Override
    public void importBatch(List<GradeCompleteCer> list) {
        List<GradeCompleteCer> dbList = gradeCompleteCerDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (GradeCompleteCer gradeCompleteCer : list) {
                gradeCompleteCer.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        gradeCompleteCer.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, gradeCompleteCer.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gradeCompleteCerDao.saveBatch(list);
        }
    }

    @Override
    public List<GradeCompleteCer> findByBatchId(List<GradeCompleteCer> list) {
        return gradeCompleteCerDao.findByBatchId(list);
    }

    @Override
    public List<GradeCompleteCer> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return gradeCompleteCerDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdateForDS(List<GradeCompleteCer> list) {
        //将每一条数据导入内网
        //根据id在内网中查询是否存在，若存在，满足条件外网时间大于内网时间则更新
        //若不存在直接将数据新增到表中
        for (GradeCompleteCer gradeCompleteCer : list) {
            GradeCompleteCer gradeCompleteCerIn = gradeCompleteCerDao.findById(gradeCompleteCer.getId());
            if (gradeCompleteCerIn == null) {
                gradeCompleteCer.setUpdateflag(false);
                gradeCompleteCerDao.insert(gradeCompleteCer);
            } else {
                if (gradeCompleteCer.getUpdateTime().getTime() > gradeCompleteCerIn.getUpdateTime().getTime()) {
                    gradeCompleteCerDao.update(gradeCompleteCer);
                }
            }
        }

    }

    @Override
    public List<GradeCompleteCer> findDSOutList(String startDate) {
        return gradeCompleteCerDao.findDSOutList(startDate);
    }

    @Override
    public void updateSelective(GradeCompleteCer gradeCompleteCer) {
        User currentUser = arsUtil.getCurrentUser();
        gradeCompleteCer.setUpdateTime(new Date());
        gradeCompleteCer.setUpdateBy(currentUser.getUsername());
        gradeCompleteCerDao.updateSelective(gradeCompleteCer);
    }

    @Override
    public GradeCompleteCer findByPersonGradeId(Long personGradeId) {
        return gradeCompleteCerDao.findByPersonGradeId(personGradeId);
    }

    @Override
    @Deprecated
    public GradeCompleteCer findByPersonGradeIdWithQRCode(Long personGradeId) throws Exception {
        PersonGrade personGrade = personGradeDao.findById(personGradeId);
        GradeCompleteCer completeCer = gradeCompleteCerDao.findByIdNum(personGrade.getIdNum(),personGrade.getGradeLevel());
        try {
            completeCer.setHeadImg("data:image/jpg;base64,"+ GetPersonImgUtil.GetImageStr(getResourcePath(personGrade.getHeadImg())));
            completeCer.setQrCode(this.createRQCode(completeCer.getId().toString()));
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        return completeCer;
    }

    /**
     * 生成结业证书二维码
     * @param cerId
     * @return
     * @throws Exception
     */
    @Override
    public String createRQCode(String cerId) throws Exception {
        return QRCodeUtil.generateBase64QRCode(getBbdH5Url(cerId),100,100,"jpg");
    }

    /**
     * 获取结业证书前端H5访问地址
     * @param cerId
     * @return
     * @throws Exception
     */
    @Override
    public String getBbdH5Url(String cerId) throws Exception {
        String cerUrl = configUtils.getValueByKey("PERCERURL"+configUtils.getCurrentProvince());
        cerId = DES3.encode(cerId);
        cerId = URLEncoder.encode(cerId,"UTF-8");
        return cerUrl+Constants.GRADEIATEREGISTARATION+cerId;
    }

    @Override
    public GradeCompleteCer findByIdNum(String idNum, String gradeLevel) {
        return gradeCompleteCerDao.findByIdNum(idNum,gradeLevel);
    }

}
