package com.bcxin.ars.service.bean.factory;

import com.bcxin.ars.service.singleLogin.SingleLoginService;
import com.bcxin.ars.service.util.SpringContextUtil;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/***
 * 单点登陆工厂类
 */
@Configuration
public class SingleLoginBeanFactory {
    /***
     * 根据服务名称获取实现类
     * @param singleLoginServiceName
     * @return
     */
    public static SingleLoginService getSingleLoginHandleBean(String singleLoginServiceName){
        SingleLoginService result = null;
        //获背景筛查spring容器的AppealHandle接口实现类列表
        Map<String, SingleLoginService> list =  SpringContextUtil.getBeansOfType(SingleLoginService.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, SingleLoginService> entry : list.entrySet()){
            String key = entry.getKey();
            //匹配，找到各个环境的实在
            if(key.equals(singleLoginServiceName)){
                result  = entry.getValue();
                break;
            }
        }
        return result;

    }
}
