package com.bcxin.ars.service.bean.factory;

import com.bcxin.ars.service.sb.CustomPersoncertificateService;
import com.bcxin.ars.service.util.SpringContextUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.springframework.context.annotation.Configuration;

import java.util.Map;
import java.util.ResourceBundle;

/***
 * 根据不同环境返回不同打回实现类
 * @author subh
 */
@Configuration
public class CustomPersoncertificateBeanFactory {
    /***
     * 实现类
     */
    public  static String className;
    static {
        //获取到config.propertites配置信息
        ResourceBundle rb = ResourceBundle.getBundle(Constants.CONFIG);
        className = rb.getString(Constants.PERSONCERTIFICATECLASSNAME);
    }
    /***
     * 根据环境获取相应的实现
     * @return
     */
    public static CustomPersoncertificateService getPersoncertificateBean(){
        CustomPersoncertificateService result = null;
        //如果为空，使用默认值
        if(StringUtil.isEmpty(className)){
            className =  Constants.PERSONCERTIFICATECLASSNAME_DEFAULT;
        }
        //获取保安员证spring容器的CustomPersoncertificateService接口实现类列表
        Map<String, CustomPersoncertificateService> list =  SpringContextUtil.getBeansOfType(CustomPersoncertificateService.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, CustomPersoncertificateService> entry : list.entrySet()){
            CustomPersoncertificateService customPersoncertificateService = entry.getValue();
            //匹配，找到各个环境的实在
            if(customPersoncertificateService.getClass().getName().equals(className)){
                result =  customPersoncertificateService;
                break;
            }
        }
        return result;
    }
}
