package com.bcxin.ars.service.bean.factory;

import com.bcxin.ars.service.util.SpringContextUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.springframework.context.annotation.Configuration;

import java.util.Map;
import java.util.ResourceBundle;

/**
 * @author linqinglin
 * @date 2019/04/19 0019 13:55
 */
@Configuration
public class BackGroupCensorServiceBeanFactory {
    /***
     * 实现类
     */
    public  static String className;
    static {
        //获取到config.propertites配置信息
        ResourceBundle rb = ResourceBundle.getBundle(Constants.CONFIG);
        className = rb.getString(Constants.BACKGROUPCENSORCLASSNAME);
    }
    public static BackGroupCensorService getBackGroupCensorServiceBean(){
        BackGroupCensorService result = null;
        //如果为空，使用默认值
        if(StringUtil.isEmpty(className)){
            className =  Constants.BACKGROUPCENSOR_DEFAULT;
        }
        //获背景筛查spring容器的BackGroupCensorService接口实现类列表
        Map<String, BackGroupCensorService> list =  SpringContextUtil.getBeansOfType(BackGroupCensorService.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, BackGroupCensorService> entry : list.entrySet()){
            BackGroupCensorService backGroupCensorService = entry.getValue();
            //匹配，找到各个环境的实在
            if(backGroupCensorService.getClass().getName().equals(className)){
                result =  backGroupCensorService;
                break;
            }
        }
        return result;

    }

}
