/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.XmlUtil;
import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.webservice.MinisterialResponse;
import com.bcxin.ars.webservice.MinisterialResponseData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class MinisterialUtil {
    private static Logger logger = LoggerFactory.getLogger(MinisterialUtil.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private BjRestLogDao bjRestLogDao;
    @Value(value="${SIGNATURE}")
    private String SIGNATURE;
    @Value(value="${ACCOUNT_ID}")
    private String ACCOUNT_ID;
    @Value(value="${ORG_CODE}")
    private String ORG_CODE;
    @Value(value="${ORG_NAME}")
    private String ORG_NAME;
    @Value(value="${PASSWORD}")
    private String PASSWORD;
    @Value(value="${serviceAddress}")
    private String SERVICEADDRESS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(MinisterialDataType dataType, List list) {
        String current_native = this.configUtils.getValueByKey("current_native");
        BjRestLog bjRestLog = new BjRestLog();
        bjRestLog.setResttype(dataType.getCode());
        String className = dataType.getDataClazz().getSimpleName();
        try {
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty("javax.xml.soap.character-set-encoding", (Object)"utf-8");
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("dat", "http://datarecord.webservice.ssis.com");
            envelope.addNamespaceDeclaration("web", "http://webservice.entity.ssis.com");
            envelope.addNamespaceDeclaration(className.toLowerCase().substring(0, 3), "http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com");
            SOAPBody body = envelope.getBody();
            SOAPElement entityElement = null;
            entityElement = className.equals("Babzjl") ? body.addChildElement(envelope.createQName("xxba_" + className + "xx", "dat")) : body.addChildElement(envelope.createQName("xxba_" + className, "dat"));
            SOAPElement licenseElement = entityElement.addChildElement(envelope.createQName("LICENSE", "dat"));
            licenseElement.addChildElement("SIGNATURE", "web").addTextNode(this.SIGNATURE);
            SOAPElement userElement = licenseElement.addChildElement("USERINFO", "web");
            userElement.addChildElement("ACCOUNT_ID", "web").addTextNode(this.ACCOUNT_ID);
            userElement.addChildElement("ORG_CODE", "web").addTextNode(this.ORG_CODE);
            userElement.addChildElement("ORG_NAME", "web").addTextNode(this.ORG_NAME);
            userElement.addChildElement("PASSWORD", "web").addTextNode(this.PASSWORD);
            String lowerClassName = className.toLowerCase().substring(0, 3);
            SOAPElement packageElement = entityElement.addChildElement(envelope.createQName("PACKAGE", "dat"));
            SOAPElement dataElement = packageElement.addChildElement(envelope.createQName("DATA", lowerClassName));
            String fieldValue = "";
            for (Object o : list) {
                SOAPElement recordElement = dataElement.addChildElement(envelope.createQName("RECORD", lowerClassName));
                for (Field field : o.getClass().getDeclaredFields()) {
                    fieldValue = "";
                    Object obj = ReflectUtil.getFieldValue(o, (String)field.getName());
                    MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                    if (resource != null) {
                        fieldValue = resource.defaultValue();
                        if (obj != null) {
                            fieldValue = resource.DATA_FORMAT().getMinDataFormatStrategy().format(field, obj);
                        }
                    }
                    recordElement.addChildElement(field.getName().toUpperCase(), lowerClassName).addTextNode(fieldValue);
                }
            }
            String FSSJ = DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmssSSS");
            String JYLCH = "00" + current_native + FSSJ + MinisterialUtil.getRadom(11);
            SOAPElement packageheadElement = packageElement.addChildElement(envelope.createQName("PACKAGEHEAD", lowerClassName));
            packageheadElement.addChildElement("DQY", "web");
            packageheadElement.addChildElement("FSSJ", "web").addTextNode(FSSJ);
            packageheadElement.addChildElement("JLS", "web");
            packageheadElement.addChildElement("JYLCH", "web").addTextNode(JYLCH);
            packageheadElement.addChildElement("MYJLS", "web");
            packageheadElement.addChildElement("SBH", "web").addTextNode(current_native);
            packageheadElement.addChildElement("SID", "web");
            message.saveChanges();
            ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)requestStream);
            if (!dataType.getCode().equals("xxba_zpxxb")) {
                bjRestLog.setRequestContext(requestStream.toString("utf-8"));
            }
            URL url = new URL(this.SERVICEADDRESS);
            logger.error("\u4e0a\u62a5\u90e8\u7ea7\u8bf7\u6c42\u5730\u5740\uff1a", (Object)url.toString());
            SOAPMessage reply = connection.call(message, (Object)url);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Source sourceContent = reply.getSOAPPart().getContent();
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(responseStream);
            transformer.transform(sourceContent, result);
            String responseStreamString = responseStream.toString("utf-8");
            bjRestLog.setResponseContext(responseStreamString);
            connection.close();
            Document document = XmlUtil.readXML((String)responseStreamString);
            Element rootElement = XmlUtil.getRootElement((Document)document);
            Element soapBody = XmlUtil.getElement((Element)rootElement, (String)"soap:Body");
            Element response = XmlUtil.getElement((Element)soapBody, (String)"ns1:xxba_BayxxbResponse");
            Element responsePackage = XmlUtil.getElement((Element)response, (String)"ns1:PACKAGE");
            Element packageHead = XmlUtil.getElement((Element)responsePackage, (String)"PACKAGEHEAD");
            MinisterialResponse ministerialResponse = (MinisterialResponse)XmlUtil.xmlToBean((Node)packageHead, MinisterialResponse.class);
            ArrayList<MinisterialResponseData> responseDataList = new ArrayList<MinisterialResponseData>();
            Element packageData = XmlUtil.getElement((Element)responsePackage, (String)"DATA");
            if (packageData != null) {
                List record = XmlUtil.getElements((Element)packageData, (String)"RECORD");
                for (Element element : record) {
                    MinisterialResponseData ministerialResponseData = (MinisterialResponseData)XmlUtil.xmlToBean((Node)element, MinisterialResponseData.class);
                    responseDataList.add(ministerialResponseData);
                }
            }
            ministerialResponse.setMinisterialResponseData(responseDataList);
            logger.error("\u4e0a\u62a5\u90e8\u7ea7\u8fd4\u56de\u7ed3\u679c:{}", (Object)ministerialResponse);
            if ("10".equals(ministerialResponse.getCODE())) {
                bjRestLog.setCode("10");
                bjRestLog.setMsg(ministerialResponse.getMSG());
            }
            String string = JYLCH;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            bjRestLog.setCode("500");
            bjRestLog.setMsg(e.getMessage());
        }
        finally {
            bjRestLog.setCreateTime(new Date());
            bjRestLog.setActive(Boolean.valueOf(true));
            bjRestLog.setUpdateTime(new Date());
            bjRestLog.setUpdateBy("system");
            logger.error("\u4e0a\u62a5\u90e8\u7ea7\u6267\u884c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)bjRestLog));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AjaxResult sendList(MinisterialDataType dataType, List list) {
        String current_native = this.configUtils.getValueByKey("current_native");
        BjRestLog bjRestLog = new BjRestLog();
        bjRestLog.setResttype(dataType.getCode());
        String className = dataType.getDataClazz().getSimpleName();
        try {
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty("javax.xml.soap.character-set-encoding", (Object)"utf-8");
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("dat", "http://datarecord.webservice.ssis.com");
            envelope.addNamespaceDeclaration("web", "http://webservice.entity.ssis.com");
            envelope.addNamespaceDeclaration(className.toLowerCase().substring(0, 3), "http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com");
            SOAPBody body = envelope.getBody();
            SOAPElement entityElement = body.addChildElement(envelope.createQName("xxba_" + className, "dat"));
            SOAPElement licenseElement = entityElement.addChildElement(envelope.createQName("LICENSE", "dat"));
            licenseElement.addChildElement("SIGNATURE", "web").addTextNode(this.SIGNATURE);
            SOAPElement userElement = licenseElement.addChildElement("USERINFO", "web");
            userElement.addChildElement("ACCOUNT_ID", "web").addTextNode(this.ACCOUNT_ID);
            userElement.addChildElement("ORG_CODE", "web").addTextNode(this.ORG_CODE);
            userElement.addChildElement("ORG_NAME", "web").addTextNode(this.ORG_NAME);
            userElement.addChildElement("PASSWORD", "web").addTextNode(this.PASSWORD);
            String lowerClassName = className.toLowerCase().substring(0, 3);
            SOAPElement packageElement = entityElement.addChildElement(envelope.createQName("PACKAGE", "dat"));
            SOAPElement dataElement = packageElement.addChildElement(envelope.createQName("DATA", lowerClassName));
            String fieldValue = "";
            for (Object o : list) {
                SOAPElement recordElement = dataElement.addChildElement(envelope.createQName("RECORD", lowerClassName));
                for (Field field : o.getClass().getDeclaredFields()) {
                    fieldValue = "";
                    Object obj = ReflectUtil.getFieldValue(o, (String)field.getName());
                    MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                    if (resource != null) {
                        fieldValue = resource.defaultValue();
                        if (obj != null) {
                            fieldValue = resource.DATA_FORMAT().getMinDataFormatStrategy().format(field, obj);
                        }
                    }
                    recordElement.addChildElement(field.getName().toUpperCase(), lowerClassName).addTextNode(fieldValue);
                }
            }
            String FSSJ = DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmssSSS");
            String JYLCH = "00" + current_native + FSSJ + MinisterialUtil.getRadom(11);
            SOAPElement packageheadElement = packageElement.addChildElement(envelope.createQName("PACKAGEHEAD", lowerClassName));
            packageheadElement.addChildElement("DQY", "web");
            packageheadElement.addChildElement("FSSJ", "web").addTextNode(FSSJ);
            packageheadElement.addChildElement("JLS", "web");
            packageheadElement.addChildElement("JYLCH", "web").addTextNode(JYLCH);
            packageheadElement.addChildElement("MYJLS", "web");
            packageheadElement.addChildElement("SBH", "web").addTextNode(current_native);
            packageheadElement.addChildElement("SID", "web");
            message.saveChanges();
            ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)requestStream);
            if (!dataType.getCode().equals("xxba_zpxxb")) {
                bjRestLog.setRequestContext(requestStream.toString("utf-8"));
            }
            URL url = new URL(this.SERVICEADDRESS);
            SOAPMessage reply = connection.call(message, (Object)url);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Source sourceContent = reply.getSOAPPart().getContent();
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(responseStream);
            transformer.transform(sourceContent, result);
            String responseStreamString = responseStream.toString("utf-8");
            bjRestLog.setResponseContext(responseStreamString);
            connection.close();
            Document document = XmlUtil.readXML((String)responseStreamString);
            Element rootElement = XmlUtil.getRootElement((Document)document);
            Element soapBody = XmlUtil.getElement((Element)rootElement, (String)"soap:Body");
            Element soapFault = XmlUtil.getElement((Element)soapBody, (String)"soap:Fault");
            if (soapFault == null) {
                AjaxResult ajaxResult = AjaxResult.error((String)"\u540c\u6b65\u5931\u8d25");
                return ajaxResult;
            }
            Element response = XmlUtil.getElement((Element)soapBody, (String)("ns1:xxba_" + className + "Response"));
            Element responsePackage = XmlUtil.getElement((Element)response, (String)"ns1:PACKAGE");
            Element packageData = XmlUtil.getElement((Element)responsePackage, (String)"DATA");
            if (packageData != null) {
                Element element;
                MinisterialResponseData ministerialResponseData;
                List record = XmlUtil.getElements((Element)packageData, (String)"RESRECORD");
                int successCount = 0;
                AjaxResult ajaxResult = record.iterator();
                while (ajaxResult.hasNext() && "10".equals((ministerialResponseData = (MinisterialResponseData)XmlUtil.xmlToBean((Node)(element = (Element)ajaxResult.next()), MinisterialResponseData.class)).getCODE())) {
                    ++successCount;
                }
                if (successCount >= record.size()) {
                    ajaxResult = AjaxResult.success(null, (Object)JYLCH);
                    return ajaxResult;
                }
            }
            AjaxResult ajaxResult = AjaxResult.success(null, null);
            return ajaxResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            bjRestLog.setCode("500");
            bjRestLog.setMsg(e.getMessage());
        }
        finally {
            bjRestLog.setCreateTime(new Date());
            bjRestLog.setActive(Boolean.valueOf(true));
            bjRestLog.setUpdateTime(new Date());
            bjRestLog.setUpdateBy("system");
            logger.error("\u4e0a\u62a5\u90e8\u7ea7\u6267\u884c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)bjRestLog));
        }
        return AjaxResult.error((String)"\u540c\u6b65\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AjaxResult send(MinisterialDataType dataType, Object object) {
        String current_native = this.configUtils.getValueByKey("current_native");
        BjRestLog bjRestLog = new BjRestLog();
        bjRestLog.setResttype(dataType.getCode());
        String className = dataType.getDataClazz().getSimpleName();
        try {
            List record;
            Element element;
            MinisterialResponseData ministerialResponseData;
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty("javax.xml.soap.character-set-encoding", (Object)"utf-8");
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("dat", "http://datarecord.webservice.ssis.com");
            envelope.addNamespaceDeclaration("web", "http://webservice.entity.ssis.com");
            envelope.addNamespaceDeclaration(className.toLowerCase().substring(0, 3), "http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com");
            SOAPBody body = envelope.getBody();
            SOAPElement entityElement = body.addChildElement(envelope.createQName("xxba_" + className, "dat"));
            SOAPElement licenseElement = entityElement.addChildElement(envelope.createQName("LICENSE", "dat"));
            licenseElement.addChildElement("SIGNATURE", "web").addTextNode(this.SIGNATURE);
            SOAPElement userElement = licenseElement.addChildElement("USERINFO", "web");
            userElement.addChildElement("ACCOUNT_ID", "web").addTextNode(this.ACCOUNT_ID);
            userElement.addChildElement("ORG_CODE", "web").addTextNode(this.ORG_CODE);
            userElement.addChildElement("ORG_NAME", "web").addTextNode(this.ORG_NAME);
            userElement.addChildElement("PASSWORD", "web").addTextNode(this.PASSWORD);
            String lowerClassName = className.toLowerCase().substring(0, 3);
            SOAPElement packageElement = entityElement.addChildElement(envelope.createQName("PACKAGE", "dat"));
            SOAPElement dataElement = packageElement.addChildElement(envelope.createQName("DATA", lowerClassName));
            String fieldValue = "";
            SOAPElement recordElement = dataElement.addChildElement(envelope.createQName("RECORD", lowerClassName));
            for (Field field : object.getClass().getDeclaredFields()) {
                fieldValue = "";
                Object obj = ReflectUtil.getFieldValue((Object)object, (String)field.getName());
                MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                if (resource != null) {
                    fieldValue = resource.defaultValue();
                    if (obj != null) {
                        fieldValue = resource.DATA_FORMAT().getMinDataFormatStrategy().format(field, obj);
                    }
                }
                recordElement.addChildElement(field.getName().toUpperCase(), lowerClassName).addTextNode(fieldValue);
            }
            String FSSJ = DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmssSSS");
            String JYLCH = "00" + current_native + FSSJ + MinisterialUtil.getRadom(11);
            SOAPElement packageheadElement = packageElement.addChildElement(envelope.createQName("PACKAGEHEAD", lowerClassName));
            packageheadElement.addChildElement("DQY", "web");
            packageheadElement.addChildElement("FSSJ", "web").addTextNode(FSSJ);
            packageheadElement.addChildElement("JLS", "web");
            packageheadElement.addChildElement("JYLCH", "web").addTextNode(JYLCH);
            packageheadElement.addChildElement("MYJLS", "web");
            packageheadElement.addChildElement("SBH", "web").addTextNode(current_native);
            packageheadElement.addChildElement("SID", "web");
            message.saveChanges();
            ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)requestStream);
            if (!dataType.getCode().equals("xxba_zpxxb")) {
                bjRestLog.setRequestContext(requestStream.toString("utf-8"));
            }
            URL url = new URL(this.SERVICEADDRESS);
            SOAPMessage reply = connection.call(message, (Object)url);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Source sourceContent = reply.getSOAPPart().getContent();
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(responseStream);
            transformer.transform(sourceContent, result);
            String responseStreamString = responseStream.toString("utf-8");
            bjRestLog.setResponseContext(responseStreamString);
            connection.close();
            Document document = XmlUtil.readXML((String)responseStreamString);
            Element rootElement = XmlUtil.getRootElement((Document)document);
            Element soapBody = XmlUtil.getElement((Element)rootElement, (String)"soap:Body");
            Element soapFault = XmlUtil.getElement((Element)soapBody, (String)"soap:Fault");
            if (soapFault == null) {
                AjaxResult ajaxResult = AjaxResult.error((String)"\u540c\u6b65\u5931\u8d25");
                return ajaxResult;
            }
            Element response = XmlUtil.getElement((Element)soapBody, (String)("ns1:xxba_" + className + "Response"));
            Element responsePackage = XmlUtil.getElement((Element)response, (String)"ns1:PACKAGE");
            Element packageData = XmlUtil.getElement((Element)responsePackage, (String)"DATA");
            if (packageData != null && "10".equals((ministerialResponseData = (MinisterialResponseData)XmlUtil.xmlToBean((Node)(element = (Element)(record = XmlUtil.getElements((Element)packageData, (String)"RESRECORD")).get(0)), MinisterialResponseData.class)).getCODE())) {
                bjRestLog.setCode("10");
                bjRestLog.setMsg(ministerialResponseData.getMSG());
                AjaxResult ajaxResult = AjaxResult.success(null, (Object)JYLCH);
                return ajaxResult;
            }
            AjaxResult ajaxResult = AjaxResult.success(null, null);
            return ajaxResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            bjRestLog.setCode("500");
            bjRestLog.setMsg(e.getMessage());
        }
        finally {
            bjRestLog.setCreateTime(new Date());
            bjRestLog.setActive(Boolean.valueOf(true));
            bjRestLog.setUpdateTime(new Date());
            bjRestLog.setUpdateBy("system");
            logger.error("\u4e0a\u62a5\u90e8\u7ea7\u6267\u884c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)bjRestLog));
        }
        return AjaxResult.error((String)"\u540c\u6b65\u5931\u8d25");
    }

    public static String getRadom(int length) {
        double rand = Math.random();
        String str = String.valueOf(rand).replace("0.", "");
        String newStr = str.substring(0, length);
        return newStr;
    }

    public static void main(String[] args) {
        List record;
        Element element;
        MinisterialResponseData ministerialResponseData;
        String responseStreamString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:xxba_BafwgsglryResponse xmlns:ns1=\"http://datarecord.webservice.ssis.com\"><ns1:PACKAGE><DATA xmlns=\"http://webservice.entity.ssis.com\"><RESRECORD><CODE>10</CODE><ERRORMSG xsi:nil=\"true\"/><KEY1>BAG6100000411</KEY1><KEY2>61210119771017761x</KEY2><MSG>\u5904\u7406\u6210\u529f!</MSG><NO>0</NO></RESRECORD><RESRECORD><CODE>10</CODE><ERRORMSG xsi:nil=\"true\"/><KEY1>BAG6100000233</KEY1><KEY2>610121197705170011</KEY2><MSG>\u5904\u7406\u6210\u529f!</MSG><NO>1</NO></RESRECORD><RESRECORD><CODE>10</CODE><ERRORMSG xsi:nil=\"true\"/><KEY1>BAG6100000699</KEY1><KEY2>445281197910111234</KEY2><MSG>\u5904\u7406\u6210\u529f!</MSG><NO>2</NO></RESRECORD></DATA><PACKAGEHEAD xmlns=\"http://webservice.entity.ssis.com\"><CGJLS>3</CGJLS><CODE>10</CODE><DQY xsi:nil=\"true\"/><FSSJ>20211026000141855</FSSJ><JLS/><JYLCH xsi:nil=\"true\"/><MSG>\u5904\u7406\u6210\u529f!</MSG><MYJLS xsi:nil=\"true\"/><SBH>61</SBH><SBJLS>0</SBJLS><SID xsi:nil=\"true\"/></PACKAGEHEAD></ns1:PACKAGE></ns1:xxba_BafwgsglryResponse></soap:Body></soap:Envelope>";
        Document document = XmlUtil.readXML((String)responseStreamString);
        Element rootElement = XmlUtil.getRootElement((Document)document);
        Element soapBody = XmlUtil.getElement((Element)rootElement, (String)"soap:Body");
        Element response = XmlUtil.getElement((Element)soapBody, (String)"ns1:xxba_BafwgsglryResponse");
        Element responsePackage = XmlUtil.getElement((Element)response, (String)"ns1:PACKAGE");
        Element packageData = XmlUtil.getElement((Element)responsePackage, (String)"DATA");
        if (packageData != null && "10".equals((ministerialResponseData = (MinisterialResponseData)XmlUtil.xmlToBean((Node)(element = (Element)(record = XmlUtil.getElements((Element)packageData, (String)"RESRECORD")).get(0)), MinisterialResponseData.class)).getCODE())) {
            System.out.println(ministerialResponseData.getMSG());
        }
    }
}

