/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.ConferenceInfo;
import com.bcxin.ars.dto.conference.HuaWeiResultDto;
import com.bcxin.ars.dto.conference.PageRecordFile;
import com.bcxin.ars.dto.conference.QueryUserResultDTO;
import com.bcxin.ars.dto.conference.ResDetailDTO;
import com.bcxin.ars.dto.conference.RestListConfResponse;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HttpBuildUtil;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HuaweiMeetUtil {
    private static Logger logger = LoggerFactory.getLogger(HuaweiMeetUtil.class);
    @Autowired
    private InterfaceLogDao interfaceLogDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Value(value="${heiweiPrefixKey}")
    private String heiweiPrefixKey;

    public AjaxResult callInterface(String method, String url, Map<String, String> headMap, Object paramObj, boolean superAdmin) {
        Map paramMap = BeanUtil.beanToMap((Object)paramObj);
        return this.callInterface(method, url, headMap, paramMap, superAdmin);
    }

    public QueryUserResultDTO getConferenceUserInfo() {
        QueryUserResultDTO resultDto = null;
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/member";
        HashedMap paramMap = new HashedMap();
        String account = "";
        String password = "";
        Long userId = Constants.HeiweiconferenceUserId;
        ConferenceAccount conferenceAccount = this.arsUtil.getConferenceAccount();
        if (conferenceAccount == null) {
            throw new ArsException("\u8d26\u53f7\u6709\u8bef\uff0c\u8be5\u8d26\u53f7\u672a\u5f00\u901a\u534e\u4e3a\u4e91\u4f1a\u8bae\u6743\u9650\uff01");
        }
        account = conferenceAccount.getAccount();
        password = conferenceAccount.getPassword();
        userId = Constants.HeiweiconferenceUserId;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString((Object)paramMap));
        try {
            String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
            String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
            paramMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)"GET", (Map)paramMap, (String)JSON.toJSONString((Object)paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            resultDto = (QueryUserResultDTO)JSON.parseObject((String)response.getEntity().toString(), QueryUserResultDTO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
            }
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        return resultDto;
    }

    public AjaxResult callInterfaceCloudV1(String method, String url, Map<String, String> headMap, Map<String, Object> paramMap) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        Object data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            if (headMap == null) {
                headMap = new HashMap<String, String>();
                String account = "";
                String password = "";
                Long userId = Constants.HeiweiconferenceUserId;
                ConferenceAccount conferenceAccount = this.arsUtil.getConferenceAccount();
                if (conferenceAccount == null) {
                    throw new ArsException("\u8d26\u53f7\u6709\u8bef\uff0c\u8be5\u8d26\u53f7\u672a\u5f00\u901a\u534e\u4e3a\u4e91\u4f1a\u8bae\u6743\u9650\uff01");
                }
                account = conferenceAccount.getAccount();
                password = conferenceAccount.getPassword();
                userId = conferenceAccount.getUserid();
                String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
                String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
                headMap.put("Authorization", "Basic " + authorization);
            }
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, (String)JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            List resultDto = JSONArray.parseArray((String)response.getEntity().toString(), ConferenceInfo.class);
            if (resultDto != null && resultDto.size() > 0) {
                data = resultDto.get(0);
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public AjaxResult callInterfaceV1(String method, String url, Map<String, String> headMap, Map<String, Object> paramMap, boolean superAdmin) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        Object data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            if (headMap == null) {
                headMap = new HashMap<String, String>();
                String account = "";
                String password = "";
                Long userId = Constants.HeiweiconferenceUserId;
                if (superAdmin) {
                    account = this.configUtils.getValueByKey("HeiweiconferenceAccount");
                    password = this.configUtils.getValueByKey("HeiweiconferencePassword");
                    userId = Constants.HeiweiconferenceUserId;
                } else {
                    ConferenceAccount conferenceAccount = this.arsUtil.getConferenceAccount();
                    if (conferenceAccount == null) {
                        throw new ArsException("\u8d26\u53f7\u6709\u8bef\uff0c\u8be5\u8d26\u53f7\u672a\u5f00\u901a\u534e\u4e3a\u4e91\u4f1a\u8bae\u6743\u9650\uff01");
                    }
                    account = conferenceAccount.getAccount();
                    password = conferenceAccount.getPassword();
                    userId = conferenceAccount.getUserid();
                }
                String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
                String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
                headMap.put("Authorization", "Basic " + authorization);
            }
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, (String)JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            List resultDto = JSONArray.parseArray((String)response.getEntity().toString(), ConferenceInfo.class);
            if (resultDto != null && resultDto.size() > 0) {
                data = resultDto.get(0);
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public AjaxResult callInterfaceV1History(String method, String url, Map<String, String> paramMap) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        List data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            HashMap<String, String> headMap = new HashMap<String, String>();
            String account = this.configUtils.getValueByKey("HeiweiconferenceAccount");
            String password = this.configUtils.getValueByKey("HeiweiconferencePassword");
            Long userId = Constants.HeiweiconferenceUserId;
            String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, null, paramMap);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            RestListConfResponse resultDto = (RestListConfResponse)JSON.parseObject((String)response.getEntity().toString(), RestListConfResponse.class);
            if (resultDto != null) {
                data = resultDto.getData();
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public AjaxResult callInterfaceV1Record(String method, String url, Map<String, String> paramMap) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        PageRecordFile data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            HashMap<String, String> headMap = new HashMap<String, String>();
            String account = this.configUtils.getValueByKey("HeiweiconferenceAccount");
            String password = this.configUtils.getValueByKey("HeiweiconferencePassword");
            Long userId = Constants.HeiweiconferenceUserId;
            String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, null, paramMap);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            PageRecordFile resultDto = (PageRecordFile)JSON.parseObject((String)response.getEntity().toString(), PageRecordFile.class);
            if (resultDto != null) {
                data = resultDto;
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public AjaxResult callInterfaceV2Record(String method, String url, Map<String, String> paramMap, ConferenceAccount conferenceAccount) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        PageRecordFile data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            HashMap<String, String> headMap = new HashMap<String, String>();
            String account = conferenceAccount.getAccount();
            String password = conferenceAccount.getPassword();
            Long userId = conferenceAccount.getUserid();
            String accessToken = this.arsUtil.getHuaweiMeetSelfAccessToken(account, password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, null, paramMap);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            PageRecordFile resultDto = (PageRecordFile)JSON.parseObject((String)response.getEntity().toString(), PageRecordFile.class);
            if (resultDto != null) {
                data = resultDto;
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public AjaxResult callInterfaceV1ReDe(String method, String url, Map<String, String> paramMap) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            HashMap<String, String> headMap = new HashMap<String, String>();
            String account = this.configUtils.getValueByKey("HeiweiconferenceAccount");
            String password = this.configUtils.getValueByKey("HeiweiconferencePassword");
            Long userId = Constants.HeiweiconferenceUserId;
            String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
            headMap.put("X-Auth-Token", accessToken);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, null, paramMap);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            if (response.getHttpCode() != 200) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg);
    }

    public AjaxResult callInterface(String method, String url, Map<String, String> headMap, Map<String, Object> paramMap, boolean superAdmin) {
        url = "https://api.meeting.huaweicloud.com" + url;
        String msg = "";
        Boolean result = true;
        Object data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            if (headMap == null) {
                headMap = new HashMap<String, String>();
                String account = "";
                String password = "";
                Long userId = Constants.HeiweiconferenceUserId;
                if (superAdmin) {
                    account = this.configUtils.getValueByKey("HeiweiconferenceAccount");
                    password = this.configUtils.getValueByKey("HeiweiconferencePassword");
                    userId = Constants.HeiweiconferenceUserId;
                } else {
                    ConferenceAccount conferenceAccount = this.arsUtil.getConferenceAccount();
                    if (conferenceAccount == null) {
                        throw new ArsException("\u8d26\u53f7\u6709\u8bef\uff0c\u8be5\u8d26\u53f7\u672a\u5f00\u901a\u534e\u4e3a\u4e91\u4f1a\u8bae\u6743\u9650\uff01");
                    }
                    account = conferenceAccount.getAccount();
                    password = conferenceAccount.getPassword();
                    userId = conferenceAccount.getUserid();
                }
                String accessToken = this.arsUtil.getHuaweiMeetAccessToken(account, password, userId);
                String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
                headMap.put("Authorization", "Basic " + authorization);
            }
            RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)method, headMap, (String)JSON.toJSONString(paramMap), null);
            RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
            interfaceLog.setResult(response.getEntity());
            HuaWeiResultDto resultDto = (HuaWeiResultDto)JSON.parseObject((String)response.getEntity().toString(), HuaWeiResultDto.class);
            if (ObjectUtil.equal((Object)resultDto.getReturnCode(), (Object)0)) {
                data = resultDto.getData();
            } else {
                result = false;
                msg = resultDto.getReturnDesc();
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            if (StringUtil.isNotEmpty((String)interfaceLog.getResult())) {
                logger.error(interfaceLog.getResult());
                msg = interfaceLog.getResult();
            }
            msg = e.getMessage();
            interfaceLog.setResult(msg);
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result.booleanValue());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u8c03\u7528\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public static void main(String[] args) {
        String json = "{\"te1080pHardCount\":{\"sumCount\":0,\"usedCount\":0},\"te720pHardCount\":{\"sumCount\":0,\"usedCount\":0},\"teSoftCount\":{\"sumCount\":10,\"usedCount\":9},\"roomCount\":{\"sumCount\":0,\"usedCount\":0},\"recordCapability\":{\"sumCount\":20,\"usedCount\":0},\"confCallCount\":{\"sumCount\":2,\"usedCount\":0},\"liveCount\":{\"sumCount\":0,\"usedCount\":0},\"thirdPartyHardCount\":{\"sumCount\":0,\"usedCount\":0},\"vmr\":[],\"enablePstn\":false,\"enableSMS\":true,\"enableHybridCloud\":false,\"enableCloudDisk\":null,\"enableUc\":true}";
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String recordCapability = jsonObj.getString("recordCapability");
        ResDetailDTO resultDto = (ResDetailDTO)JSON.parseObject((String)recordCapability, ResDetailDTO.class);
        System.out.println(resultDto);
    }
}

