/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.FilerecordOutDao;
import com.bcxin.ars.dao.datasync.FileRecordDetailDao;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.FilerecordOut;
import com.bcxin.ars.model.datasync.FileRecordDetail;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EmailUtil;
import com.bcxin.ars.util.Encodes;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.spring.util.SpringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.BadPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class DataSyncUtil {
    Logger logger = LoggerFactory.getLogger(DataSyncUtil.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private FilerecordDao fileRecordDao;
    @Autowired
    private FilerecordOutDao fileRecordOutDao;
    @Autowired
    private FileRecordDetailDao fileRecordDetailDao;
    @Autowired
    private EmailUtil emailUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDSFile(final String startDate, String createFilesPath) {
        File filePath;
        if (StringUtil.isEmpty((String)createFilesPath)) {
            createFilesPath = this.configUtils.tempfolder;
        }
        if (!(filePath = new File(createFilesPath)).exists()) {
            filePath.mkdirs();
        }
        String resultPath = "";
        final Vector filePaths = new Vector();
        Map serviceBeans = SpringUtils.getBeansByAnnotation(DataSyncOutAnnotation.class);
        this.logger.info("\u5f00\u59cb\u751f\u6210\u540c\u6b65\u6587\u4ef6\uff1a");
        long time1 = System.currentTimeMillis();
        final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)serviceBeans.size());
        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
        for (String key : serviceBeans.keySet()) {
            final Object entityService = serviceBeans.get(key);
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DataSyncUtil.this.createDSFile(entityService, filePaths, startDate);
                    }
                    catch (Exception e) {
                        DataSyncUtil.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
        if (filePaths.size() > 0) {
            String fileName = FileUtil.generatingFileNameByDate((String)this.configUtils.getDataSyncStartFileName(DataSyncOutAnnotation.class)) + ".zip";
            resultPath = FileUtil.zipFiles(filePaths, (String)(createFilesPath + fileName));
            filePaths.forEach(tempPath -> {
                if (tempPath.indexOf("temp") > 0) {
                    FileUtil.deleteFile((String)tempPath);
                }
            });
        }
        long time2 = System.currentTimeMillis();
        this.logger.info("\u751f\u6210\u540c\u6b65\u6587\u4ef6\u5b8c\u6210\u3002\u8017\u65f6\uff1a" + (time2 - time1) + "ms");
        return resultPath;
    }

    public void createDSFile(Object entityService, List<String> filePaths, String startDate) {
        try {
            DataSycDto dataSycDto = new DataSycDto();
            Class<?> clazz = entityService.getClass();
            DataSyncOutAnnotation dataSyncAnnotation = clazz.getAnnotation(DataSyncOutAnnotation.class);
            String fileName = dataSyncAnnotation.getClazz().getSimpleName();
            dataSycDto.setDataType(fileName);
            String methodName = dataSyncAnnotation.getSearchMethodName();
            ImportType importType = dataSyncAnnotation.getImportType();
            Method method = null;
            switch (importType) {
                case BATCH_FILE: 
                case FOREACH_FILE: {
                    method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{List.class, String.class});
                    break;
                }
                default: {
                    method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{String.class});
                }
            }
            if (method != null) {
                List entityList = null;
                switch (importType) {
                    case BATCH_FILE: 
                    case FOREACH_FILE: {
                        entityList = (List)ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{filePaths, startDate});
                        break;
                    }
                    default: {
                        entityList = (List)ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{startDate});
                    }
                }
                if (entityList != null && entityList.size() > 0) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(this.configUtils.tempfolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    int limit = this.configUtils.limitSize;
                    int count = new Double(Math.ceil((double)entityList.size() * 1.0 / (double)limit)).intValue();
                    List subList = null;
                    for (int i = 0; i < count; ++i) {
                        subList = entityList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        dataSycDto.setData(JSONArray.toJSONString(subList));
                        String listStr = JSONObject.toJSONString((Object)dataSycDto);
                        String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])listStr.getBytes("UTF-8"), (String)Constants.APPROVAL_KEY));
                        String filepath = FileUtil.writeTxtFile((String)content, (String)fileName, (String)this.configUtils.tempfolder, (int)i);
                        filePaths.add(filepath);
                    }
                }
            } else {
                this.logger.error(entityService.getClass().getSimpleName() + "\u7c7b\u6ca1\u6709\u751f\u6210\u540c\u6b65\u6570\u636e\u6587\u4ef6\u7684\u65b9\u6cd5" + methodName + "\u6216\u8005\u53c2\u6570\u6709\u8bef\uff01");
            }
        }
        catch (BadPaddingException badPaddingException) {
            this.logger.error(badPaddingException.getMessage(), (Throwable)badPaddingException);
            throw new ArsException("\u5bfc\u51fa\u5931\u8d25\uff0c\u975e\u8be5\u533a\u57df\u6570\u636e\n\uff01");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDSFile(final Class AnnotationClazz, final DataSynchronizationSearchDto searchDto, String dataFilePath) {
        File filePath;
        if (StringUtil.isEmpty((String)dataFilePath)) {
            dataFilePath = this.configUtils.tempfolder;
        }
        if (!(filePath = new File(dataFilePath)).exists()) {
            filePath.mkdirs();
        }
        String zipPath = "";
        final Vector filePaths = new Vector();
        Map serviceBeans = SpringUtils.getBeansByAnnotation((Class)AnnotationClazz);
        this.logger.info("\u5f00\u59cb\u751f\u6210\u540c\u6b65\u6587\u4ef6\uff1a");
        long time1 = System.currentTimeMillis();
        final CountDownLatch workCount = ThreadUtil.newCountDownLatch((int)serviceBeans.size());
        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
        for (String key : serviceBeans.keySet()) {
            final Object entityService = serviceBeans.get(key);
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DataSyncUtil.this.createDSFile(AnnotationClazz, entityService, filePaths, searchDto);
                    }
                    catch (Exception e) {
                        DataSyncUtil.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
        }
        try {
            workCount.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
        if (filePaths.size() > 0) {
            String fileName = FileUtil.generatingFileNameByDate((String)this.configUtils.getDataSyncStartFileName(DataSyncAnnotation.class)) + ".zip";
            zipPath = FileUtil.zipFiles(filePaths, (String)(dataFilePath + fileName));
            filePaths.forEach(tempPath -> {
                if (tempPath.indexOf("temp") > 0) {
                    FileUtil.deleteFile((String)tempPath);
                }
            });
        }
        long time2 = System.currentTimeMillis();
        this.logger.info("\u751f\u6210\u540c\u6b65\u6587\u4ef6\u5b8c\u6210\u3002\u8017\u65f6\uff1a" + (time2 - time1) + "ms");
        return zipPath;
    }

    private void createDSFile(Class AnnotationClazz, Object entityService, List<String> filePaths, DataSynchronizationSearchDto searchDto) {
        try {
            DataSyncAnnotation dataSyncAnnotation;
            DataSycDto dataSycDto = new DataSycDto();
            String fileName = "";
            String methodName = "";
            ImportType importType = null;
            Class<?> serviceClazz = entityService.getClass();
            Object annotation = serviceClazz.getAnnotation(AnnotationClazz);
            if (annotation instanceof DataSyncAnnotation) {
                dataSyncAnnotation = (DataSyncAnnotation)annotation;
                fileName = dataSyncAnnotation.getClazz().getSimpleName();
                methodName = dataSyncAnnotation.getSearchMethodName();
                importType = dataSyncAnnotation.getImportType();
            } else if (annotation instanceof DataSyncOutAnnotation) {
                dataSyncAnnotation = (DataSyncOutAnnotation)annotation;
                fileName = dataSyncAnnotation.getClazz().getSimpleName();
                methodName = dataSyncAnnotation.getSearchMethodName();
                importType = dataSyncAnnotation.getImportType();
            }
            dataSycDto.setDataType(fileName);
            Method method = null;
            switch (importType) {
                case BATCH_FILE: 
                case FOREACH_FILE: {
                    method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{List.class, DataSynchronizationSearchDto.class});
                    break;
                }
                default: {
                    method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{DataSynchronizationSearchDto.class});
                }
            }
            if (method != null) {
                List entityList = null;
                switch (importType) {
                    case BATCH_FILE: 
                    case FOREACH_FILE: {
                        entityList = (List)ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{filePaths, searchDto});
                        break;
                    }
                    default: {
                        entityList = (List)ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{searchDto});
                    }
                }
                if (entityList != null && entityList.size() > 0) {
                    String dirDate = DateUtil.getCurrentDate();
                    int limit = this.configUtils.limitSize;
                    int count = new Double(Math.ceil((double)entityList.size() * 1.0 / (double)limit)).intValue();
                    String _fileName = "";
                    List subList = null;
                    for (int i = 0; i < count; ++i) {
                        _fileName = fileName + "_" + i;
                        subList = entityList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        dataSycDto.setData(JSONArray.toJSONString(subList));
                        File dir = new File(this.configUtils.tempfolder + dirDate);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        String listStr = JSONObject.toJSONString((Object)dataSycDto);
                        String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])listStr.getBytes("UTF-8"), (String)Constants.APPROVAL_KEY));
                        String filepath = FileUtil.writeTxtFile((String)content, (String)_fileName, (String)this.configUtils.tempfolder);
                        filePaths.add(filepath);
                        this.saveFileRecordOut(FileUtil.getFileNameByPath((String)filepath), filepath, subList.size());
                    }
                }
            } else {
                this.logger.error(entityService.getClass().getSimpleName() + "\u7c7b\u6ca1\u6709\u751f\u6210\u540c\u6b65\u6570\u636e\u6587\u4ef6\u7684\u65b9\u6cd5" + methodName + "\u6216\u8005\u53c2\u6570\u6709\u8bef\uff01");
            }
        }
        catch (BadPaddingException badPaddingException) {
            this.logger.error(badPaddingException.getMessage(), (Throwable)badPaddingException);
            throw new ArsException("\u5bfc\u51fa\u5931\u8d25\uff0c\u975e\u8be5\u533a\u57df\u6570\u636e\n\uff01");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void readDSFile(Class AnnotationClazz, File zipFile) throws Exception {
        block12: {
            long startTime = System.currentTimeMillis();
            Date startDate = new Date();
            try {
                List fileRecordList = this.fileRecordDao.findByFileName(zipFile.getName(), this.configUtils.isIntranet());
                if (fileRecordList != null && fileRecordList.size() != 0) break block12;
                ArrayList<String> filePaths = new ArrayList<String>();
                HashMap<String, String> pathMap = new HashMap<String, String>();
                ZipInputStream Zin = new ZipInputStream(new FileInputStream(zipFile));
                BufferedInputStream Bin = new BufferedInputStream(Zin);
                String tempFilePath = this.configUtils.tempfolder + DateUtil.getCurrentDate() + File.separatorChar;
                HashMap<String, List<File>> dataFiles = new HashMap<String, List<File>>();
                File localFile = null;
                try {
                    ZipEntry entry;
                    while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
                        int b;
                        localFile = new File(tempFilePath, entry.getName());
                        if (!localFile.exists()) {
                            new File(localFile.getParent()).mkdirs();
                        }
                        FileOutputStream out = new FileOutputStream(localFile);
                        BufferedOutputStream Bout = new BufferedOutputStream(out);
                        while ((b = Bin.read()) != -1) {
                            Bout.write(b);
                        }
                        Bout.close();
                        out.close();
                        if (localFile.getName().endsWith(".data")) {
                            String[] splitFiles = localFile.getName().replace(".data", "").split("_");
                            if (splitFiles.length > 0) {
                                String filename = splitFiles[0];
                                ArrayList<File> localFiles = (ArrayList<File>)dataFiles.get(filename);
                                if (localFiles == null) {
                                    localFiles = new ArrayList<File>();
                                }
                                localFiles.add(localFile);
                                dataFiles.put(filename, localFiles);
                            }
                        } else {
                            pathMap.put(localFile.getName(), localFile.getPath());
                        }
                        filePaths.add(localFile.getPath());
                        this.logger.info(localFile + "\u89e3\u538b\u6210\u529f");
                    }
                    Bin.close();
                    Zin.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                    throw e;
                }
                long endTime = System.currentTimeMillis();
                this.logger.info("\u8017\u8d39\u65f6\u95f4\uff1a " + (endTime - startTime) + " ms");
                this.readDSFile(AnnotationClazz, dataFiles, pathMap);
                for (String filePath : filePaths) {
                    FileUtil.deleteFolder((String)filePath);
                }
                this.saveFileRecord(startDate, null, zipFile.getName(), zipFile.getAbsolutePath(), null);
            }
            catch (FileNotFoundException e) {
                this.logger.error(e.getMessage());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDSFile(final Class AnnotationClazz, final Map<String, List<File>> dataFiles, final Map<String, String> pathMap) {
        this.logger.info("\u5f00\u59cb\u8bfb\u53d6\u540c\u6b65\u6587\u4ef6\uff1a");
        List<Map.Entry<String, Object>> serviceBeans_async = this.getDataSyncBeanList_async(AnnotationClazz);
        long time1 = System.currentTimeMillis();
        final CountDownLatch workCount = ThreadUtil.newCountDownLatch((int)serviceBeans_async.size());
        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
        for (Map.Entry<String, Object> entry : serviceBeans_async) {
            final Object object = entry.getValue();
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DataSyncUtil.this.readDSFile(AnnotationClazz, object, dataFiles, pathMap);
                    }
                    catch (Exception e) {
                        DataSyncUtil.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
        }
        try {
            workCount.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
        List<Map.Entry<String, Object>> serviceBeans_sync = this.getDataSyncBeanList_sync(AnnotationClazz);
        for (Map.Entry<String, Object> entry : serviceBeans_sync) {
            Object entityService = entry.getValue();
            this.readDSFile(AnnotationClazz, entityService, dataFiles, pathMap);
        }
        long l = System.currentTimeMillis();
        this.logger.info("\u540c\u6b65\u6587\u4ef6\u8bfb\u53d6\u5b8c\u6210\u3002\u8017\u65f6\uff1a" + (l - time1) + "ms");
    }

    private void readDSFile(Class AnnotationClazz, Object entityService, Map<String, List<File>> dataFiles, Map<String, String> pathMap) {
        DataSyncAnnotation dataSyncAnnotation;
        Date startDate = new Date();
        String fileName = "";
        String methodName = "";
        ImportType importType = null;
        Class entityClazz = null;
        Class<?> serviceClazz = entityService.getClass();
        Object annotation = serviceClazz.getAnnotation(AnnotationClazz);
        if (annotation instanceof DataSyncAnnotation) {
            dataSyncAnnotation = (DataSyncAnnotation)annotation;
            entityClazz = dataSyncAnnotation.getClazz();
            fileName = entityClazz.getSimpleName();
            methodName = dataSyncAnnotation.getMethodName();
            importType = dataSyncAnnotation.getImportType();
        } else if (annotation instanceof DataSyncOutAnnotation) {
            dataSyncAnnotation = (DataSyncOutAnnotation)annotation;
            entityClazz = dataSyncAnnotation.getClazz();
            fileName = entityClazz.getSimpleName();
            methodName = dataSyncAnnotation.getMethodName();
            importType = dataSyncAnnotation.getImportType();
        }
        if (entityClazz == null) {
            return;
        }
        List<File> files = dataFiles.get(fileName);
        if (files != null && files.size() > 0) {
            for (File dataFile : files) {
                try {
                    List fileRecordList = this.fileRecordDao.findByFileName(dataFile.getName(), this.configUtils.isIntranet());
                    if (fileRecordList != null && fileRecordList.size() != 0) continue;
                    BufferedReader br = new BufferedReader(new FileReader(dataFile));
                    StringBuffer content = new StringBuffer();
                    String lineTxt = null;
                    while ((lineTxt = br.readLine()) != null) {
                        content.append(lineTxt);
                    }
                    br.close();
                    String jsonStr = new String(CipherDESUtil.decrypt((byte[])Encodes.decodeHex((String)content.toString()), (String)Constants.APPROVAL_KEY), "UTF-8");
                    DataSycDto dataSycDto = (DataSycDto)JSONObject.parseObject((String)jsonStr, DataSycDto.class);
                    if (dataSycDto == null) continue;
                    ArrayList<FileRecordDetail> errorDetailList = new ArrayList<FileRecordDetail>();
                    List list = JSONArray.parseArray((String)dataSycDto.getData(), (Class)entityClazz);
                    Method method = null;
                    switch (importType) {
                        case BATCH: {
                            method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{List.class});
                            if (method == null) break;
                            try {
                                ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{list});
                            }
                            catch (Exception e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                                this.saveError(errorDetailList, null, jsonStr, e.getMessage(), dataFile.getAbsolutePath());
                            }
                            break;
                        }
                        case BATCH_FILE: {
                            method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{List.class, Map.class});
                            if (method == null) break;
                            try {
                                ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{list, pathMap});
                            }
                            catch (Exception e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                                this.saveError(errorDetailList, null, jsonStr, e.getMessage(), dataFile.getAbsolutePath());
                            }
                            break;
                        }
                        case FOREACH: {
                            method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{entityClazz});
                            if (method == null) break;
                            for (Object detail : list) {
                                try {
                                    ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{detail});
                                }
                                catch (Exception e) {
                                    this.logger.error(e.getMessage(), (Throwable)e);
                                    BaseModel baseModel = (BaseModel)detail;
                                    this.saveError(errorDetailList, baseModel.getId(), JSONObject.toJSONString(detail), e.getMessage(), dataFile.getAbsolutePath());
                                }
                            }
                            break;
                        }
                        case FOREACH_FILE: {
                            method = ReflectionUtils.findMethod(entityService.getClass(), (String)methodName, (Class[])new Class[]{entityClazz, Map.class});
                            if (method == null) break;
                            for (Object detail : list) {
                                try {
                                    ReflectionUtils.invokeMethod((Method)method, (Object)entityService, (Object[])new Object[]{detail, pathMap});
                                }
                                catch (Exception e) {
                                    String errorMsg = e.toString();
                                    this.logger.error(errorMsg, (Throwable)e);
                                    if (StringUtil.isNotEmpty((String)e.getMessage())) {
                                        errorMsg = errorMsg + e.getMessage();
                                    }
                                    BaseModel baseModel = (BaseModel)detail;
                                    this.saveError(errorDetailList, baseModel.getId(), JSONObject.toJSONString(detail), errorMsg, dataFile.getAbsolutePath());
                                }
                            }
                            break;
                        }
                    }
                    if (method == null) {
                        this.logger.error(entityService.getClass().getSimpleName() + "\u7c7b\u6ca1\u6709\u4fdd\u5b58\u540c\u6b65\u6570\u636e\u7684\u65b9\u6cd5" + methodName + "\u6216\u8005\u53c2\u6570\u6709\u8bef\uff01");
                    }
                    this.saveFileRecord(startDate, errorDetailList, dataFile.getName(), dataFile.getAbsolutePath(), list.size());
                }
                catch (BadPaddingException badPaddingException) {
                    this.logger.error(badPaddingException.getMessage(), (Throwable)badPaddingException);
                    throw new ArsException("\u5bfc\u5165\u5931\u8d25\uff0c\u975e\u8be5\u533a\u57df\u6570\u636e\n\uff01");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private List<Map.Entry<String, Object>> getDataSyncBeanList_async(Class clazz) {
        Map beans = SpringUtils.getBeansByAnnotation((Class)clazz);
        ArrayList list = new ArrayList(beans.entrySet());
        return list.stream().filter(map -> SyncType.ASYNC.equals((Object)this.getSyncType(map.getValue(), clazz))).collect(Collectors.toList());
    }

    private SyncType getSyncType(Object entityService, Class clazz) {
        Class<?> entityServiceClazz = entityService.getClass();
        Object annotation = entityServiceClazz.getAnnotation(clazz);
        if (annotation instanceof DataSyncAnnotation) {
            DataSyncAnnotation dataSyncAnnotation = (DataSyncAnnotation)annotation;
            return dataSyncAnnotation.getDataSyncType();
        }
        if (annotation instanceof DataSyncOutAnnotation) {
            DataSyncOutAnnotation dataSyncAnnotation = (DataSyncOutAnnotation)annotation;
            return dataSyncAnnotation.getDataSyncType();
        }
        return null;
    }

    private List<Map.Entry<String, Object>> getDataSyncBeanList_sync(final Class clazz) {
        Map beans = SpringUtils.getBeansByAnnotation((Class)clazz);
        ArrayList list = new ArrayList(beans.entrySet());
        List<Map.Entry<String, Object>> maps = list.stream().filter(map -> SyncType.SYNC.equals((Object)this.getSyncType(map.getValue(), clazz))).collect(Collectors.toList());
        Collections.sort(maps, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> map1, Map.Entry<String, Object> map2) {
                Object o1 = map1.getValue();
                Object o2 = map2.getValue();
                return DataSyncUtil.this.getDataSyncSeq(map1.getValue(), clazz) - DataSyncUtil.this.getDataSyncSeq(map2.getValue(), clazz);
            }
        });
        return maps;
    }

    private int getDataSyncSeq(Object entityService, Class clazz) {
        Class<?> entityServiceClazz = entityService.getClass();
        Object annotation = entityServiceClazz.getAnnotation(clazz);
        if (annotation instanceof DataSyncAnnotation) {
            DataSyncAnnotation dataSyncAnnotation = (DataSyncAnnotation)annotation;
            return dataSyncAnnotation.getSeq();
        }
        if (annotation instanceof DataSyncOutAnnotation) {
            DataSyncOutAnnotation dataSyncAnnotation = (DataSyncOutAnnotation)annotation;
            return dataSyncAnnotation.getSeq();
        }
        return 0;
    }

    private void sendFailEmail(String data, String errorMsg, String fileName) {
        Config receiveUserConfig = this.configUtils.getConfigByKey("DATASYNC_RECEIVEUSER");
        Config currentNativeName = this.configUtils.getConfigByKey("current_native_name");
        if (receiveUserConfig != null && currentNativeName != null) {
            new Thread(() -> {
                String sendHtml = "{currentNativeName}\u73af\u5883\u5185\u5230\u5916\u540c\u6b65\u5f02\u5e38\uff0c\u6765\u6e90\uff1a{url}<br>\u540c\u6b65\u6587\u4ef6\u5168\u8def\u5f84\u540d\uff1a<br>{fileName}<br>\u540c\u6b65\u6570\u636e\u4e3a\uff1a<br><p style='color: green'>{data}</p><br>\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a<br><p style='color: red'>{errorMsg}</p>".replace("{fileName}", fileName).replace("{data}", data).replace("{errorMsg}", errorMsg).replace("{currentNativeName}", currentNativeName.getValue()).replace("url", this.configUtils.getWebHost());
                String receiveUser = receiveUserConfig.getValue();
                this.emailUtil.sendEmail("\u767e\u4fdd\u76fe\u6570\u636e\u540c\u6b65\u5f02\u5e38\u63d0\u9192", sendHtml, receiveUser);
            }).start();
        }
    }

    private void saveFileRecord(Date startDate, List<FileRecordDetail> errorDetailList, String fileName, String filePath, Integer recordSize) {
        Filerecord fileRecord = new Filerecord();
        fileRecord.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        fileRecord.setFilename(fileName);
        fileRecord.setFilepath(filePath);
        fileRecord.setRecordsize(recordSize);
        fileRecord.setCreateTime(startDate);
        fileRecord.setUpdateflag(Boolean.valueOf(true));
        fileRecord.setUpdateTime(new Date());
        fileRecord.setSynchtype("datasync");
        if (this.configUtils.isIntranet()) {
            fileRecord.setUpdateflag(Boolean.valueOf(true));
        }
        fileRecord.setIntranet(Boolean.valueOf(this.configUtils.isIntranet()));
        this.fileRecordDao.save(fileRecord);
        if (errorDetailList != null && errorDetailList.size() > 0) {
            errorDetailList.forEach(detail -> detail.setRecordId(fileRecord.getId()));
            this.fileRecordDetailDao.saveBatch(errorDetailList);
        }
    }

    private void saveFileRecordOut(String fileName, String filePath, Integer recordSize) {
        FilerecordOut fileRecordOut = new FilerecordOut();
        fileRecordOut.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        fileRecordOut.setFilename(fileName);
        fileRecordOut.setFilepath(filePath);
        fileRecordOut.setRecordsize(recordSize);
        fileRecordOut.setCreateTime(new Date());
        fileRecordOut.setUpdateTime(new Date());
        fileRecordOut.setSynchtype("datasync");
        this.fileRecordOutDao.save(fileRecordOut);
    }

    private void saveError(List<FileRecordDetail> errorDetailList, Long businessId, String data, String errorMsg, String fileName) {
        FileRecordDetail fileRecordDetail = new FileRecordDetail();
        fileRecordDetail.setData(data);
        fileRecordDetail.setError(errorMsg);
        fileRecordDetail.setBusinessId(businessId);
        fileRecordDetail.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        fileRecordDetail.setCreateTime(new Date());
        fileRecordDetail.setUpdateTime(new Date());
        fileRecordDetail.setIntranet(Boolean.valueOf(this.configUtils.isIntranet()));
        if (this.configUtils.isIntranet()) {
            fileRecordDetail.setUpdateflag(Boolean.valueOf(true));
        }
        this.fileRecordDetailDao.save(fileRecordDetail);
        errorDetailList.add(fileRecordDetail);
        if (!this.configUtils.isIntranet()) {
            this.sendFailEmail(data, errorMsg, fileName);
        }
    }

    public static void main(String[] args) {
        try {
            BufferedReader br = new BufferedReader(new FileReader("C:\\Users\\Administrator\\Desktop\\Personcertificate_0_20191010160005.data"));
            StringBuffer content = new StringBuffer();
            String lineTxt = null;
            while ((lineTxt = br.readLine()) != null) {
                content.append(lineTxt);
            }
            br.close();
            String jsonStr = new String(CipherDESUtil.decrypt((byte[])Encodes.decodeHex((String)content.toString()), (String)"11000000"), "UTF-8");
            DataSycDto dataSycDto = (DataSycDto)JSONObject.parseObject((String)jsonStr, DataSycDto.class);
            List list = JSONArray.parseArray((String)dataSycDto.getData(), Personcertificate.class);
            list.forEach(person -> {
                if (person.getId() == 631874724065968128L) {
                    System.out.println(JSONObject.toJSONString((Object)person));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

