/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ConfigSignUtils {
    private Logger log = LoggerFactory.getLogger(ConfigSignUtils.class);
    public static final String REDIS_PREFIX_KEY = "ARS:";
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private RedisUtil redisUtil;

    public void getAllConfigSign() {
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"configSign");
        List configSignList = this.configDao.findAllConfigSign();
        if (configSignList.size() > 0) {
            for (Map map : configSignList) {
                String type = map.get("type").toString();
                String provinceType = map.get("provinceType").toString();
                this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)("configSign_" + type + "_" + provinceType));
                String configJson = JSON.toJSONString((Object)map);
                this.redisUtil.set("ARS:configSign_" + type + "_" + provinceType, configJson);
            }
        } else {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"configSign:\u5904\u7406\u7b7e\u914d\u7f6e\u8868\u4e3a\u7a7a");
        }
    }

    public String getConfigSign(String type, String provinceType) {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:configSign_" + type + "_" + provinceType);
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"configSign");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return value;
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"configSign");
        this.getAllConfigSign();
        value = this.redisUtil.get("ARS:configSign_" + type + "_" + provinceType);
        if (StringUtil.isNotEmpty((String)value)) {
            return value;
        }
        this.log.error("\u53d6\u51faredis\u7f13\u5b58\u9519\u8bef:configSign");
        return null;
    }
}

