/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.AppraiseResultDto;
import com.bcxin.ars.dto.appraise.AppraisePageResultDto;
import com.bcxin.ars.dto.appraise.AppraisePageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppraiseInterfaceUtil {
    private static Logger logger = LoggerFactory.getLogger(AppraiseInterfaceUtil.class);
    @Autowired
    private InterfaceLogDao interfaceLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Value(value="${AppraiseURL}")
    private String AppraiseURL;

    public AjaxResult callInterface(String url, Object paramObj) {
        Map paramMap = BeanUtil.beanToMap((Object)paramObj);
        return this.callInterface(url, paramMap);
    }

    public AjaxResult callInterface(String url, Map<String, Object> paramMap) {
        String msg = "";
        Boolean result = true;
        AppraiseResultDto data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        url = this.AppraiseURL + url;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            AppraiseResultDto resultDto;
            String resultStr = ((HttpRequest)HttpRequest.post((String)url).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36")).form(paramMap).execute().body();
            interfaceLog.setResult(resultStr);
            data = resultDto = (AppraiseResultDto)JSONObject.parseObject((String)resultStr, AppraiseResultDto.class);
            if (resultDto != null && StringUtil.isNotEmpty((String)resultDto.getCode())) {
                if (resultDto.isSuccess()) {
                    logger.info("\u63a5\u53e3\u5bf9\u63a5\u6210\u529f");
                } else {
                    result = false;
                    msg = resultDto.getErrorMessage();
                    logger.error(resultStr);
                    logger.info("\u63a5\u53e3\u5bf9\u63a5\u5931\u8d25");
                }
            } else {
                result = false;
                msg = "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c";
                logger.info("\u63a5\u53e3\u5bf9\u63a5\u5931\u8d25,\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = false;
            logger.error(e.getMessage(), (Throwable)e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result.booleanValue());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u63a5\u53e3\u5bf9\u63a5\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AjaxPageResponse searchForPage(String url, AppraisePageSearchDto dto, AppraisePageResultDto page) {
        try {
            String resultStr = HttpUtil.post((String)(this.AppraiseURL + url), (Map)BeanUtil.beanToMap((Object)dto));
            logger.error("\u597d\u5dee\u8bc4\u63a5\u53e3\u5730\u5740:" + this.AppraiseURL + url);
            logger.error("\u597d\u5dee\u8bc4\u63a5\u53e3\u53c2\u6570:" + JSON.toJSONString((Object)dto));
            logger.error("\u597d\u5dee\u8bc4\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:" + resultStr);
            AppraiseResultDto resultDto = (AppraiseResultDto)JSONObject.parseObject((String)resultStr, AppraiseResultDto.class);
            if (resultDto.getData() != null) {
                JSONObject pageJson = JSONObject.parseObject((String)resultDto.getData().toString());
                page = (AppraisePageResultDto)JSONObject.parseObject((String)pageJson.get((Object)"page").toString(), page.getClass());
                System.out.println(JSON.toJSONString((Object)page));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            logger.error("\u597d\u5dee\u8bc4\u63a5\u53e3\u8c03\u7528\u5931\u8d25\u3002");
        }
        finally {
            return page.toAjaxPage();
        }
    }

    public static void main(String[] args) {
        String url = "http://outbjbbd.test.baibaodun.cn/ars-rest/comTask/contract/save.json";
        String contracts = "[{\"comContractId\":638318060121358336,\"comTaskId\":636983286630973440,\"createBy\":634333489453334528,\"createTime\":1572229567521,\"isDelete\":\"0\",\"updateTime\":1572229567524}]";
        HashedMap paramMap = new HashedMap();
        paramMap.put("sid", "0E44373E153D7C59341D77809D11C17E07FD91598F759F3E79BFA3D9BDB2CCCF7DD089A41E48CD4CADB1F18A76187437EC609C2215764BBA1AF3EF5CE85BAAC2");
        paramMap.put("comTaskId", 636983286630973440L);
        paramMap.put("contracts", contracts);
        String resultStr = HttpUtil.post((String)url, (Map)paramMap);
        System.out.println(resultStr);
    }
}

