/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dao.task.TaskFeedbackDao;
import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskFeedbackSearchDto;
import com.bcxin.ars.dto.task.FeedBackDetailDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.dto.task.TaskListDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TaskFeedback.class)
public class TaskFeedbackServiceImpl
implements TaskFeedbackService {
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private TaskFeedbackDao taskFeedbackDao;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private SecurityCompanyService companyService;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private TaskPersonDao taskPersonDao;
    @Autowired
    private ArsUtil arsUtil;

    public TaskFeedback findById(Long id) {
        return this.taskFeedbackDao.findById(id);
    }

    public TaskFeedback findByIdRand() {
        return this.taskFeedbackDao.findByIdRand();
    }

    public List<TaskFeedback> findByTaskId(Long taskId) {
        return this.taskFeedbackDao.findByTaskId(taskId);
    }

    public TaskFeedback saveOrUpdate(TaskFeedback feedback) {
        TaskFeedback dbFeedback;
        User currentUser = this.arsUtil.getCurrentUser();
        if (feedback.getId() != null) {
            dbFeedback = this.taskFeedbackDao.findById(feedback.getId());
            if (dbFeedback == null) {
                throw new ArsException("\u6570\u636e\u5f02\u5e38");
            }
            if (feedback.getTaskStatus().getId().equals(1L)) {
                throw new ArsException("\u6570\u636e\u5f02\u5e38");
            }
            if (feedback.getTaskStatus().getId().equals(2L)) {
                dbFeedback.setStartTime(new Date());
                if (dbFeedback.getTask().getTaskType().getId() != 4L) {
                    if (DateUtil.convertStringToDate((String)(dbFeedback.getTaskDate() + " " + dbFeedback.getTaskStart())).getTime() < new Date().getTime()) {
                        dbFeedback.setSignStatus("2");
                    } else {
                        dbFeedback.setSignStatus("1");
                    }
                }
            } else if (feedback.getTaskStatus().getId().equals(3L)) {
                dbFeedback.setEndTime(new Date());
                dbFeedback.setComment(feedback.getComment());
                dbFeedback.setPhotos(feedback.getPhotos());
                if (dbFeedback.getTask().getTaskType().getId() != 4L) {
                    if (DateUtil.convertStringToDate((String)(dbFeedback.getTaskDate() + " " + dbFeedback.getTaskEnd())).getTime() > new Date().getTime()) {
                        dbFeedback.setFeedbackStatus("2");
                    } else {
                        dbFeedback.setFeedbackStatus("1");
                    }
                }
            }
        } else {
            throw new ArsException("\u6570\u636e\u5f02\u5e38");
        }
        dbFeedback.setTaskStatus(feedback.getTaskStatus());
        dbFeedback.setUpdateTime(new Date());
        dbFeedback.setUpdateBy(currentUser.getUsername());
        this.taskFeedbackDao.update(dbFeedback);
        return feedback;
    }

    public void saveOrUpdateForDS(TaskFeedback feedback) {
        TaskFeedback dbfeedback = this.findById(feedback.getId());
        if (feedback.getActive() == null) {
            feedback.setActive(Boolean.valueOf(true));
        }
        if (dbfeedback == null) {
            this.taskFeedbackDao.save(feedback);
        } else if (feedback.getActive() != null && !feedback.getActive().booleanValue()) {
            this.taskFeedbackDao.delete(feedback);
        } else {
            TaskFeedback dbFeedback = this.taskFeedbackDao.findById(feedback.getId());
            if (feedback.getUpdateTime().getTime() > dbFeedback.getUpdateTime().getTime()) {
                this.taskFeedbackDao.update(feedback);
            }
        }
    }

    public List<ReportData> findAreaReport() {
        Long companyId = null;
        SecurityCompany sc = this.companyService.getCurrentUserCompany();
        if (sc == null) {
            return null;
        }
        companyId = sc.getId();
        return this.taskFeedbackDao.findAreaReport(companyId);
    }

    public Map<String, String[]> findCatalogReport() {
        Long companyId = null;
        SecurityCompany sc = this.companyService.getCurrentUserCompany();
        if (sc == null) {
            return null;
        }
        companyId = sc.getId();
        List list = this.taskFeedbackDao.findCatalogReport(companyId);
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public List<ReportData> findLevelReport() {
        Long companyId = null;
        SecurityCompany sc = this.companyService.getCurrentUserCompany();
        if (sc == null) {
            return null;
        }
        companyId = sc.getId();
        return this.taskFeedbackDao.findLevelReport(companyId);
    }

    public TaskFeedbackSearchDto search(TaskFeedbackSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        List data = this.taskFeedbackDao.search(dto);
        Long count = this.taskFeedbackDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public List<TaskFeedback> findNotFeedback(Long personId) {
        List list = this.taskFeedbackDao.findNotFeedback(personId);
        for (TaskFeedback tf : list) {
            for (TaskPerson tp : tf.getTask().getPersonList()) {
                ArrayList<TaskPersonSchedule> tpsList = new ArrayList<TaskPersonSchedule>();
                for (TaskPersonSchedule tps : tp.getScheduleList()) {
                    String taskDate = tps.getTaskDate().trim();
                    if (tf.getTaskDate().trim().equals(taskDate) || DateUtil.getWeekOfDate((String)tf.getTaskDate()).equals(taskDate)) continue;
                    tpsList.add(tps);
                }
                tp.getScheduleList().removeAll(tpsList);
            }
        }
        return list;
    }

    public List<TaskFeedback> findFeedbackList(Long personId, Long taskStatus, Integer minutes) {
        return this.taskFeedbackDao.findFeedbackList(personId, taskStatus, minutes);
    }

    public List<TaskFeedback> findFeedbackNext(Long taskid) {
        return this.taskFeedbackDao.findFeedbackNext(taskid);
    }

    public List<TaskFeedback> findFeedbackByTaskid(Long taskid, long personid) {
        return this.taskFeedbackDao.findFeedbackByTaskid(taskid, Long.valueOf(personid));
    }

    public List<TaskFeedback> findUrgentFeedbackByTaskid(Long taskid, long personid) {
        return this.taskFeedbackDao.findUrgentFeedbackByTaskid(taskid, Long.valueOf(personid));
    }

    public List<TaskFeedback> findAllFeedbackByTaskid(Long taskid, long personid) {
        return this.taskFeedbackDao.findAllFeedbackByTaskid(taskid, Long.valueOf(personid));
    }

    public TaskFeedback findByTaskIdAndPerson(Long taskId, Long personId) {
        TaskFeedback taskFeedback = new TaskFeedback();
        Task task = new Task();
        task.setId(taskId);
        SecurityPerson person = new SecurityPerson();
        person.setId(personId);
        taskFeedback.setTask(task);
        taskFeedback.setPerson(person);
        return this.taskFeedbackDao.findByTaskIdAndPerson(taskFeedback);
    }

    public List<TaskFeedback> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.taskFeedbackDao.searchForDataSynchronization(searchDto);
    }

    public List<TaskFeedBackDto> findTaskFeedbasksByTask(TaskDetailSearchDto taskDetailDto, TaskDto taskDto) {
        List companySchedules;
        List weekDays;
        Object weekMap;
        TaskPerson taskPerson;
        List feedbacks = this.taskFeedbackDao.findFeedBasks(taskDetailDto);
        if (taskDto == null) {
            taskDto = this.taskDao.findTaskDetail(taskDetailDto);
        }
        if (taskDto.getAcceptStatus().equals("0") || taskDto.getAcceptStatus().equals("2") || taskDto.getAcceptStatus().equals("4")) {
            taskPerson = this.taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
            if (taskDto.getTaskType().getId() == 1L && taskDto.isRepeat().booleanValue()) {
                weekMap = DateUtil.getWeekDatesByYearMouth((String)taskDetailDto.getTaskdate());
                if (weekMap != null && taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0) {
                    for (TaskPersonSchedule personSchedule : taskPerson.getScheduleList()) {
                        weekDays = (List)weekMap.get(personSchedule.getTaskDate());
                        if (weekDays == null || weekDays.size() <= 0) continue;
                        companySchedules = personSchedule.getScheduleDetail();
                        for (String weekDay : weekDays) {
                            if (DateUtil.convertStringToDate((String)weekDay).getTime() < DateUtil.convertStringToDate((String)taskDto.getCreateTime()).getTime()) continue;
                            ArrayList<Object> backdetails = new ArrayList<Object>();
                            TaskFeedBackDto newFeedBackDto = new TaskFeedBackDto();
                            newFeedBackDto.setTaskDate(weekDay);
                            for (SecurityCompanySchedule securityCompanySchedule : companySchedules) {
                                FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
                                newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
                                newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
                                newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
                                newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
                                newFeedBackDetailDto.setTaskStatus(Long.valueOf(1L));
                                backdetails.add(newFeedBackDetailDto);
                            }
                            newFeedBackDto.setDetails(backdetails);
                            feedbacks.add(newFeedBackDto);
                        }
                    }
                }
            } else if (taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0) {
                for (Object personSchedule : taskPerson.getScheduleList()) {
                    List companySchedules2 = personSchedule.getScheduleDetail();
                    ArrayList<Object> backdetails = new ArrayList<Object>();
                    TaskFeedBackDto newFeedBackDto = new TaskFeedBackDto();
                    newFeedBackDto.setTaskDate(personSchedule.getTaskDate());
                    if (companySchedules2 != null && companySchedules2.size() > 0) {
                        for (SecurityCompanySchedule securityCompanySchedule : companySchedules2) {
                            FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
                            newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
                            newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
                            newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
                            newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
                            newFeedBackDetailDto.setTaskStatus(Long.valueOf(1L));
                            backdetails.add(newFeedBackDetailDto);
                        }
                    }
                    newFeedBackDto.setDetails(backdetails);
                    feedbacks.add(newFeedBackDto);
                }
            }
        } else if (DateUtil.convertStringToDate((String)(taskDetailDto.getTaskdate() + "-01")).getTime() >= DateUtil.convertStringToDate((String)DateUtil.getCurrentDate((String)"yyyy-MM-01")).getTime()) {
            taskPerson = this.taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
            if (taskDto.getTaskType().getId() == 1L && taskDto.isRepeat().booleanValue()) {
                weekMap = DateUtil.getWeekDatesByYearMouth((String)taskDetailDto.getTaskdate());
                for (TaskPersonSchedule personSchedule : taskPerson.getScheduleList()) {
                    weekDays = (List)weekMap.get(personSchedule.getTaskDate());
                    if (weekDays == null || weekDays.size() <= 0) continue;
                    companySchedules = personSchedule.getScheduleDetail();
                    Boolean exist = false;
                    Boolean detailExist = false;
                    for (String weekDay : weekDays) {
                        if (DateUtil.convertStringToDate((String)weekDay).getTime() < DateUtil.convertStringToDate((String)taskDto.getCreateTime()).getTime()) continue;
                        for (SecurityCompanySchedule securityCompanySchedule : companySchedules) {
                            exist = false;
                            for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
                                detailExist = false;
                                if (!weekDay.equals(taskFeedBackDto.getTaskDate())) continue;
                                exist = true;
                                List backdetails = taskFeedBackDto.getDetails();
                                for (FeedBackDetailDto feedBackDetailDto : backdetails) {
                                    if (feedBackDetailDto.getScheduleId() != securityCompanySchedule.getId()) continue;
                                    detailExist = true;
                                }
                                if (detailExist.booleanValue()) continue;
                                FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
                                newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
                                newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
                                newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
                                newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
                                newFeedBackDetailDto.setTaskStatus(Long.valueOf(1L));
                                backdetails.add(newFeedBackDetailDto);
                            }
                            if (exist.booleanValue()) continue;
                            TaskFeedBackDto newFeedBackDto = new TaskFeedBackDto();
                            FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
                            newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
                            newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
                            newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
                            newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
                            newFeedBackDetailDto.setTaskStatus(Long.valueOf(1L));
                            newFeedBackDto.setTaskDate(weekDay);
                            ArrayList<FeedBackDetailDto> details = new ArrayList<FeedBackDetailDto>();
                            details.add(newFeedBackDetailDto);
                            newFeedBackDto.setDetails(details);
                            feedbacks.add(newFeedBackDto);
                        }
                    }
                }
            }
        }
        if (feedbacks != null && feedbacks.size() > 0) {
            Date nowDate = new Date();
            for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
                if (taskFeedBackDto.getDetails() == null || taskFeedBackDto.getDetails().size() <= 0) continue;
                Date minTaskClockDate = null;
                for (FeedBackDetailDto backDetailDto : taskFeedBackDto.getDetails()) {
                    int hours;
                    int days;
                    Date taskStartDate;
                    String scheduleStatus = backDetailDto.getScheduleStatus();
                    if (scheduleStatus != null && scheduleStatus.equals("2") && StringUtil.isNotEmpty((String)backDetailDto.getTaskStart())) {
                        taskStartDate = DateUtil.convertStringToDate((String)(taskFeedBackDto.getTaskDate() + " " + backDetailDto.getTaskStart()));
                        if (minTaskClockDate == null) {
                            minTaskClockDate = taskStartDate;
                        } else if (taskStartDate.getTime() > minTaskClockDate.getTime()) {
                            backDetailDto.setScheduleStatus("1");
                        } else {
                            minTaskClockDate = taskStartDate;
                        }
                    }
                    if (backDetailDto.getTaskStatus() == 1L) {
                        if (!StringUtil.isNotEmpty((String)backDetailDto.getTaskStart())) continue;
                        taskStartDate = DateUtil.convertStringToDate((String)(taskFeedBackDto.getTaskDate() + " " + backDetailDto.getTaskStart()));
                        if (taskStartDate.getTime() > nowDate.getTime()) {
                            int minutes = DateUtil.dateDiffForMinutes((Date)nowDate, (Date)taskStartDate);
                            days = minutes / 1440;
                            hours = minutes % 1440 / 60;
                            StringBuffer tipBuffer = new StringBuffer("\u8fd8\u6709");
                            if (days > 0) {
                                tipBuffer.append(days + "\u5929");
                            }
                            if (hours > 0) {
                                tipBuffer.append(hours + "\u5c0f\u65f6");
                            }
                            if (minutes % 60 > 0) {
                                tipBuffer.append(minutes % 60 + "\u5206\u949f");
                            }
                            tipBuffer.append("\u5f00\u59cb");
                            backDetailDto.setTip(tipBuffer.toString());
                            continue;
                        }
                        backDetailDto.setTip("\u5df2\u8fc7\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4");
                        continue;
                    }
                    if (backDetailDto.getTaskStatus() == 2L) {
                        if (!StringUtil.isNotEmpty((String)backDetailDto.getTaskEnd())) continue;
                        Date taskEndDate = DateUtil.convertStringToDate((String)(taskFeedBackDto.getTaskDate() + " " + backDetailDto.getTaskEnd()));
                        if (taskEndDate.getTime() > nowDate.getTime()) {
                            int minutes = DateUtil.dateDiffForMinutes((Date)nowDate, (Date)taskEndDate);
                            days = minutes / 1440;
                            hours = minutes % 1440 / 60;
                            StringBuffer tipBuffer = new StringBuffer("\u8fd8\u6709");
                            if (days > 0) {
                                tipBuffer.append(days + "\u5929");
                            }
                            if (hours > 0) {
                                tipBuffer.append(hours + "\u5c0f\u65f6");
                            }
                            if (minutes % 60 > 0) {
                                tipBuffer.append(minutes % 60 + "\u5206\u949f");
                            }
                            tipBuffer.append("\u4e0b\u73ed");
                            backDetailDto.setTip(tipBuffer.toString());
                            continue;
                        }
                        backDetailDto.setTip("\u5df2\u8fc7\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4");
                        continue;
                    }
                    if (backDetailDto.getTaskStatus() != 3L || !StringUtil.isNotEmpty((String)backDetailDto.getStartTime()) || !StringUtil.isNotEmpty((String)backDetailDto.getEndTime())) continue;
                    Date startDate = DateUtil.convertStringToDate((String)backDetailDto.getStartTime());
                    Date endDate = DateUtil.convertStringToDate((String)backDetailDto.getEndTime());
                    int minutes = DateUtil.dateDiffForMinutes((Date)startDate, (Date)endDate);
                    int days2 = minutes / 1440;
                    int hours2 = minutes % 1440 / 60;
                    StringBuffer tipBuffer = new StringBuffer("\u603b\u65f6\u957f:");
                    if (days2 > 0) {
                        tipBuffer.append(days2 + "\u5929");
                    }
                    if (hours2 > 0) {
                        tipBuffer.append(hours2 + "\u5c0f\u65f6");
                    }
                    if (minutes % 60 > 0) {
                        tipBuffer.append(minutes % 60 + "\u5206\u949f");
                    }
                    backDetailDto.setTip(tipBuffer.toString());
                }
            }
        } else if (taskDto.getTaskType().getId() == 1L && taskDto.isRepeat().booleanValue() && (taskDto.getAcceptStatus().equals("0") || taskDto.getAcceptStatus().equals("2") || taskDto.getAcceptStatus().equals("4"))) {
            taskDetailDto.getTaskdate();
            try {
                String nextDate = DateUtil.dateAdd((int)2, (String)(taskDetailDto.getTaskdate() + "-01"), (int)1);
                taskDetailDto.setTaskdate(DateUtil.convertDateToString((Date)DateUtil.convertStringToDate((String)nextDate), (String)"yyyy-MM"));
                return this.findTaskFeedbasksByTask(taskDetailDto, taskDto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return feedbacks;
    }

    public TaskFeedBackDto findNextFeedBack_back(TaskListDto taskListDto) {
        return this.taskFeedbackDao.findNextFeedBack_back(taskListDto);
    }

    public FeedBackDetailDto findFeedBackDetailById(Long id) {
        return this.taskFeedbackDao.findFeedBackDetailById(id);
    }

    public List<FeedBackDetailDto> findBackDetailByPersonid(Long personId) {
        return this.taskFeedbackDao.findBackDetailByPersonid(personId);
    }

    public TaskFeedback saveAppSign(TaskFeedback feedback) {
        TaskFeedback dbFeedback;
        User currentUser = this.arsUtil.getCurrentUser();
        if (feedback.getId() != null) {
            dbFeedback = this.taskFeedbackDao.findById(feedback.getId());
            Long taskId = dbFeedback.getTask().getId();
            Long personId = dbFeedback.getPerson().getId();
            Long execFeedBackCount = null;
            if (taskId != null && personId != null) {
                this.taskFeedbackDao.updateFeedbackStatus(taskId, personId);
                execFeedBackCount = this.taskFeedbackDao.searchExecFeedBackCount(taskId, personId);
            }
            if (execFeedBackCount != null && execFeedBackCount > 0L) {
                return null;
            }
            dbFeedback.setStartTime(new Date());
            if (dbFeedback.getTask().getTaskType().getId() != 4L) {
                if (DateUtil.convertStringToDate((String)(dbFeedback.getTaskDate() + " " + dbFeedback.getTaskStart())).getTime() < new Date().getTime()) {
                    dbFeedback.setSignStatus("2");
                } else {
                    dbFeedback.setSignStatus("1");
                }
            }
        } else {
            throw new ArsException("\u6570\u636e\u5f02\u5e38");
        }
        dbFeedback.setTaskStatus(feedback.getTaskStatus());
        dbFeedback.setUpdateTime(new Date());
        dbFeedback.setUpdateBy(currentUser.getUsername());
        this.taskFeedbackDao.update(dbFeedback);
        return feedback;
    }

    public Long findFeedBackFinishSumTime(Long taskId, Long personId) {
        return this.taskFeedbackDao.findFeedBackFinishSumTime(taskId, personId);
    }

    public List<TaskFeedBackDto> findFeedBasksByScheduleStatus(TaskDetailSearchDto taskDetailDto) {
        return this.taskFeedbackDao.findFeedBasksByScheduleStatus(taskDetailDto);
    }

    public List<TaskFeedBackDto> findTaskFeedbasksByTask_V109(TaskDetailSearchDto taskDetailDto) {
        List feedbacks = this.taskFeedbackDao.findFeedBasks(taskDetailDto);
        Long signFeedBaskID = this.taskFeedbackDao.findCanSignFeedBaskID(taskDetailDto);
        if (feedbacks != null && feedbacks.size() > 0) {
            Date nowDate = new Date();
            for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
                if (taskFeedBackDto.getDetails() == null || taskFeedBackDto.getDetails().size() <= 0) continue;
                for (FeedBackDetailDto backDetailDto : taskFeedBackDto.getDetails()) {
                    int hours;
                    int days;
                    String scheduleStatus = backDetailDto.getScheduleStatus();
                    if (!StringUtils.isNotEmpty((String)scheduleStatus)) continue;
                    if (signFeedBaskID != null && !signFeedBaskID.equals(backDetailDto.getFeedbackid()) && scheduleStatus.equals("2") && StringUtil.isNotEmpty((String)backDetailDto.getTaskStart())) {
                        backDetailDto.setScheduleStatus("1");
                        scheduleStatus = "1";
                    }
                    if (scheduleStatus.equals("1") || scheduleStatus.equals("2")) {
                        if (!StringUtil.isNotEmpty((String)backDetailDto.getTaskStart())) continue;
                        Date taskStartDate = DateUtil.convertStringToDate((String)(taskFeedBackDto.getTaskDate() + " " + backDetailDto.getTaskStart()));
                        if (taskStartDate.getTime() > nowDate.getTime()) {
                            int minutes = DateUtil.dateDiffForMinutes((Date)nowDate, (Date)taskStartDate);
                            days = minutes / 1440;
                            hours = minutes % 1440 / 60;
                            StringBuffer tipBuffer = new StringBuffer("\u8fd8\u6709");
                            if (days > 0) {
                                tipBuffer.append(days + "\u5929");
                            }
                            if (hours > 0) {
                                tipBuffer.append(hours + "\u5c0f\u65f6");
                            }
                            if (minutes % 60 > 0) {
                                tipBuffer.append(minutes % 60 + "\u5206\u949f");
                            }
                            tipBuffer.append("\u5f00\u59cb");
                            backDetailDto.setTip(tipBuffer.toString());
                            continue;
                        }
                        backDetailDto.setTip("\u5df2\u8fc7\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4");
                        continue;
                    }
                    if (scheduleStatus.equals("3")) {
                        if (!StringUtil.isNotEmpty((String)backDetailDto.getTaskEnd())) continue;
                        Date taskEndDate = DateUtil.convertStringToDate((String)(taskFeedBackDto.getTaskDate() + " " + backDetailDto.getTaskEnd()));
                        if (taskEndDate.getTime() > nowDate.getTime()) {
                            int minutes = DateUtil.dateDiffForMinutes((Date)nowDate, (Date)taskEndDate);
                            days = minutes / 1440;
                            hours = minutes % 1440 / 60;
                            StringBuffer tipBuffer = new StringBuffer("\u8fd8\u6709");
                            if (days > 0) {
                                tipBuffer.append(days + "\u5929");
                            }
                            if (hours > 0) {
                                tipBuffer.append(hours + "\u5c0f\u65f6");
                            }
                            if (minutes % 60 > 0) {
                                tipBuffer.append(minutes % 60 + "\u5206\u949f");
                            }
                            tipBuffer.append("\u4e0b\u73ed");
                            backDetailDto.setTip(tipBuffer.toString());
                            continue;
                        }
                        backDetailDto.setTip("\u5df2\u8fc7\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4");
                        continue;
                    }
                    if (!scheduleStatus.equals("4") || !StringUtil.isNotEmpty((String)backDetailDto.getStartTime()) || !StringUtil.isNotEmpty((String)backDetailDto.getEndTime())) continue;
                    Date startDate = DateUtil.convertStringToDate((String)backDetailDto.getStartTime());
                    Date endDate = DateUtil.convertStringToDate((String)backDetailDto.getEndTime());
                    int minutes = DateUtil.dateDiffForMinutes((Date)startDate, (Date)endDate);
                    int days2 = minutes / 1440;
                    int hours2 = minutes % 1440 / 60;
                    StringBuffer tipBuffer = new StringBuffer("\u603b\u65f6\u957f:");
                    if (days2 > 0) {
                        tipBuffer.append(days2 + "\u5929");
                    }
                    if (hours2 > 0) {
                        tipBuffer.append(hours2 + "\u5c0f\u65f6");
                    }
                    if (minutes % 60 > 0) {
                        tipBuffer.append(minutes % 60 + "\u5206\u949f");
                    }
                    backDetailDto.setTip(tipBuffer.toString());
                }
            }
        }
        return feedbacks;
    }

    public List<TaskFeedback> findFeedbackByTaskid_V109(Long taskId, long personid) {
        return this.taskFeedbackDao.findFeedbackByTaskid_V109(taskId, Long.valueOf(personid));
    }
}

