/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.task.ComTaskPer;
import com.bcxin.ars.service.task.ComTaskPerService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComTaskPer.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class ComTaskPerServiceImpl
implements ComTaskPerService {
    Logger logger = LoggerFactory.getLogger(ComTaskPerServiceImpl.class);
    @Autowired
    private ComTaskPerDao comTaskPerDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public void importBatch(List<ComTaskPer> list) {
        List dbList = this.comTaskPerDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComTaskPer comTaskPer : list) {
                comTaskPer.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comTaskPer.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comTaskPer.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comTaskPerDao.saveBatch(list);
        }
    }

    public List<ComTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comTaskPerDao.searchForDataSynchronization(dto);
    }

    public List<ComTaskPer> findByBatchId(List<ComTaskPer> list) {
        return this.comTaskPerDao.findByBatchId(list);
    }
}

