/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dao.task.ComContractStationDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.task.ComContractDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.task.ComContractStation;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.task.ComContractService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComContract.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class ComContractServiceImpl
extends BaseService
implements ComContractService {
    @Autowired
    private ComContractDao comContractDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ComTaskDao comTaskDao;
    @Autowired
    private ComContractStationDao comContractStationDao;

    public ComContract findById(Long id) {
        return this.comContractDao.findById(id);
    }

    public void search(ComContractSearchDto dto, AjaxPageResponse<ComContract> page) {
        page.setData(this.comContractDao.search(dto));
        page.setTotal(this.comContractDao.searchCount(dto).longValue());
    }

    public void save(ComContract comContract) {
        ComContract dbComContract;
        comContract.setUpdateTime(new Date());
        Config config = this.configUtils.getConfigByKey(Constants.COVERT_CONTRACT_LOCATION);
        if ((config == null || config.getValue().equals(Constants.COVERT_CONTRACT) || "01".equals(comContract.getContractType())) && StringUtil.isNotEmpty((String)comContract.getContractUrl())) {
            comContract.setContractUrl(this.getAttPath(comContract.getContractUrl()));
        }
        if ((dbComContract = this.comContractDao.findById(comContract.getComContractId())) != null) {
            BeanUtils.copyPropertiesIgnore((Object)comContract, (Object)dbComContract, (Boolean)true);
            if (comContract.getPerId() == null) {
                dbComContract.setPerId(null);
            }
            BeanUtils.copyPropertiesIgnore((Object)dbComContract, (Object)comContract, (Boolean)false);
            this.comContractStationDao.deleteBatchByComContractId(dbComContract.getComContractId());
        }
        this.comContractDao.save(comContract);
        if (StringUtil.isNotEmpty((String)comContract.getTaskStationArrs())) {
            List comContractStationList = JSON.parseArray((String)comContract.getTaskStationArrs(), ComContractStation.class);
            this.comContractStationDao.saveBatch(comContractStationList);
        }
        if ("1".equals(comContract.getIsDelete())) {
            this.comTaskDao.deleteByContractId(comContract.getComContractId());
        }
    }

    private void saveContractStation(ComContract comContract, Boolean ignoreNull) {
        List dbComContractStationList;
        ArrayList newComContractStationList = comContract.getComContractStationList();
        if (ignoreNull.booleanValue() && (newComContractStationList == null || newComContractStationList.size() == 0)) {
            return;
        }
        if (newComContractStationList == null) {
            newComContractStationList = new ArrayList();
        }
        if ((dbComContractStationList = this.comContractStationDao.findByComContractId(comContract.getComContractId())).size() > 0) {
            ArrayList removeList = new ArrayList();
            CollectionUtils.addAll(removeList, (Object[])new Object[dbComContractStationList.size()]);
            Collections.copy(removeList, dbComContractStationList);
            removeList.removeAll(newComContractStationList);
            if (removeList.size() > 0) {
                this.comContractStationDao.deleteBatchIds(removeList);
            }
        }
        newComContractStationList.removeAll(dbComContractStationList);
        if (newComContractStationList.size() > 0) {
            this.comContractStationDao.saveBatch(newComContractStationList);
        }
    }

    public void importBatch(List<ComContract> list) {
        List dbList = this.comContractDao.findByBatchIds(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            this.comContractDao.saveBatch(list);
            list.forEach(comContract -> this.saveContractStation((ComContract)comContract, false));
            this.comTaskDao.deleteBatchByContractIds(list);
        }
    }

    public List<ComContract> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comContractDao.searchForDataSynchronization(dto);
    }

    public List<ComContract> findByPerId(Long perId) {
        return this.comContractDao.findByPerId(perId);
    }

    public ComContractDto findDetailById(Long id) {
        return this.comContractDao.findDetailById(id);
    }

    public void converImg() {
        List list = this.comContractDao.findConverImg();
        for (ComContract comContract : list) {
            if (!StringUtil.isNotEmpty((String)comContract.getContractUrl())) continue;
            comContract.setContractUrl(this.getAttPath(comContract.getContractUrl()));
            comContract.setUpdateTime(new Date());
            this.comContractDao.updateUrl(comContract);
        }
    }
}

