/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.ThirdPartyDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ThirdPartyPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ThirdParty;
import com.bcxin.ars.service.sys.ThirdPartyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ThirdPartyServiceImpl
implements ThirdPartyService {
    Logger logger = LoggerFactory.getLogger(ThirdPartyServiceImpl.class);
    @Autowired
    private ThirdPartyDao thirdPartyDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(ThirdParty thirdParty) {
        User currentUser = this.arsUtil.getCurrentUser();
        thirdParty.setUpdateTime(new Date());
        thirdParty.setUpdateBy(currentUser.getUsername());
        return this.thirdPartyDao.delete(thirdParty);
    }

    public int save(ThirdParty thirdParty) throws Exception {
        User currentUser = this.arsUtil.getCurrentUser();
        if (thirdParty.getId() == null) {
            thirdParty.setCreateTime(new Date());
            thirdParty.setId(Long.valueOf(this.idWorker.nextId()));
            thirdParty.setClientSecret(StringUtil.createRandomCharData((int)10));
        } else {
            ThirdParty dbThirdParty = this.thirdPartyDao.findById(thirdParty.getId());
            BeanUtils.copyPropertiesIgnore((Object)thirdParty, (Object)dbThirdParty, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbThirdParty, (Object)thirdParty, (Boolean)false);
        }
        thirdParty.setActive(Boolean.valueOf(true));
        thirdParty.setUpdateBy(currentUser.getUsername());
        thirdParty.setUpdateTime(new Date());
        thirdParty.setUpdateflag(Boolean.valueOf(true));
        return this.thirdPartyDao.save(thirdParty);
    }

    public ThirdParty findById(Long id) {
        return this.thirdPartyDao.findById(id);
    }

    public void searchForPage(ThirdPartyPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.thirdPartyDao.searchForPage(dto, page);
    }
}

