/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.SysdictDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sys.SysDictDto;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.service.sys.SysDictService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDictServiceImpl
implements SysDictService {
    @Autowired
    private SysdictDAO dictDao;
    @Autowired
    private ConfigUtils configUtils;

    public List findAll() {
        return this.dictDao.findAll();
    }

    public void search(SysDictDto sysDictDto, AjaxPageResponse page) {
        this.dictDao.search(sysDictDto, page);
    }

    public Sysdict findById(Long id) {
        return this.dictDao.findById(id);
    }

    public void save(Sysdict sysdict) {
        sysdict.setUpdateflag(Boolean.valueOf(true));
        sysdict.setUpdateTime(new Date());
        this.dictDao.save(sysdict);
    }

    public List<Sysdict> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.dictDao.searchForDataSynchronization(searchDto);
    }

    public List<Sysdict> findDSOutList(String startDate) {
        return this.dictDao.findDSOutList(startDate);
    }

    public void importBatch(List<Sysdict> list) {
        List dbList = this.dictDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (Sysdict sysdict : list) {
                sysdict.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    sysdict.setUpdateTime(DateUtil.dateAdd((int)6, (Date)sysdict.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.dictDao.saveBatch(list);
        }
    }
}

