/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.sys.ApprovalLogService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncOutAnnotation(getClazz=ApprovalLog.class, getMethodName="importBatchLog")
public class ApprovalLogServiceImpl
implements ApprovalLogService {
    @Autowired
    private ApprovalLogDao approvalLogDao;
    @Autowired
    private ConfigDao configDao;

    public List<ApprovalLog> findByProcessInstanceId(String processInstanceId) {
        Config config = this.configDao.findByKey("APPROVAL_VERSION_SWITCH");
        if (config != null && "1".equals(config.getValue())) {
            return this.approvalLogDao.findByProcessInstanceId_new(processInstanceId);
        }
        return this.approvalLogDao.findByProcessInstanceId(processInstanceId);
    }

    public List<ApprovalLog> findByApprovalId(String approvalId) {
        Config config = this.configDao.findByKey("APPROVAL_VERSION_SWITCH");
        if (config != null && "1".equals(config.getValue())) {
            return this.approvalLogDao.findByApprovalId_new(approvalId);
        }
        return this.approvalLogDao.findByApprovalId_old(approvalId);
    }

    public Map findPrintfMessageByApprovalId(Map map) {
        return this.approvalLogDao.findPrintfMessageByApprovalId(map);
    }

    public List<ApprovalLog> findApprovalLogByTime(String startDate, String endDate) {
        return this.approvalLogDao.findApprovalLogByTime(startDate);
    }

    public List<ApprovalLog> findByBatchId(List<ApprovalLog> approvalLogList) {
        return this.approvalLogDao.findByBatchId(approvalLogList);
    }

    public void importBatchLog(List<ApprovalLog> logList) {
        List<ApprovalLog> dbExistIDList = this.findByBatchId(logList);
        logList.removeAll(dbExistIDList);
        if (logList.size() > 0) {
            this.approvalLogDao.saveBatch(logList);
        }
    }

    public List<ApprovalLog> findDSOutList(String startDate) {
        return this.approvalLogDao.findApprovalLogByTime(startDate);
    }
}

