/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sx.impl;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sx.AuthLoginUser;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.gxhlwWeb.impl.gxhlwWebServiceImpl;
import com.bcxin.ars.service.sx.AuthorizeService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthorizeServiceImpl
implements AuthorizeService {
    private static final Logger logger = LoggerFactory.getLogger(gxhlwWebServiceImpl.class);
    @Autowired
    private RegisterpersonService registerpersonService;
    @Autowired
    private UserService userService;
    @Autowired
    private ArsUtil arsUtil;
    @Value(value="${login-timeout}")
    private int loginTimeout = 10;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private UserDao userDao;

    public AjaxResult login(AuthLoginUser loginUser, HttpServletRequest request) {
        AjaxResult ajaxResult = new AjaxResult();
        User user = new User();
        user.setIdNumber(loginUser.getCredentials_number());
        user.setPhone(loginUser.getMobile_telephone());
        user.setPassword(loginUser.getMobile_telephone().substring(loginUser.getMobile_telephone().length() - 6, loginUser.getMobile_telephone().length()));
        user.setRealname(loginUser.getUserName());
        user.setUsername(loginUser.getMobile_telephone());
        List data = this.userDao.searchByDto(user);
        if (data.size() == 0) {
            AjaxResult userAjaxResult = this.registerpersonService.SXNWregister(user);
            if (!userAjaxResult.isSuccessful()) {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setMsg("\u6ce8\u518c\u5931\u8d25");
                throw new ArsException("\u6ce8\u518c\u5931\u8d25\uff01");
            }
            user.setPassword(loginUser.getMobile_telephone().substring(loginUser.getMobile_telephone().length() - 6, loginUser.getMobile_telephone().length()));
        } else {
            user = (User)data.get(0);
        }
        AjaxResult loginAjaxResult = new AjaxResult();
        try {
            loginAjaxResult = this.webLogin(user.getUsername(), user.getPassword(), 4, request);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
        }
        if (!loginAjaxResult.isSuccessful()) {
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
            ajaxResult.setSuccessful(false);
            throw new ArsException("\u767b\u5f55\u5931\u8d25\uff01");
        }
        ajaxResult.setState(Constants.STATUS_SUCCESS);
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    public AjaxResult webLogin(String username, String password, Integer platform, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password, "DA1AFC8A62D75AE0A88B054A7F6667FC");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login((AuthenticationToken)token);
            }
            catch (AuthenticationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                result.setSuccessful(false);
                result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
            }
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = this.userService.findByUsername(username, platform.toString());
                System.out.println("\u5f53\u524d\u767b\u5f55\u7528\u6237\u662f\uff1a" + user.getUsername());
                user.setLoginstate(Integer.valueOf(1));
                if (user.getLoginNum() != null) {
                    user.setLoginNum(Integer.valueOf(user.getLoginNum() + 1));
                } else {
                    user.setLoginNum(Integer.valueOf(1));
                }
                user.setLoginDate(new Date());
                this.userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                this.arsUtil.setCurrentUser(user, 120000 * this.loginTimeout);
                result.setData((Object)user);
                result.setSuccessful(true);
                this.loginLogService.logIn(request);
            }
        }
        catch (UnknownAccountException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u767b\u5f55\u5931\u8d25\u591a\u6b21\uff0c\u8d26\u6237\u9501\u5b9a10\u5206\u949f");
        }
        catch (AuthenticationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }
}

