/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.PersonPunishDao;
import com.bcxin.ars.dao.supervision.PersonPunishDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.PersonPunishPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.PersonPunish;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.supervision.PersonPunishService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PersonPunish.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=PersonPunish.class, getImportType=ImportType.BATCH)
public class PersonPunishServiceImpl
extends BaseService
implements PersonPunishService {
    @Autowired
    private PersonPunishDao personPunishDao;
    @Autowired
    private PersonPunishDaoAop personPunishDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;

    public int delete(PersonPunish record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.personPunishDaoAop.delete(record);
    }

    public void save(PersonPunish record) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setCreateTime(new Date());
            if (StringUtil.isNotEmpty((String)record.getSignImgPath())) {
                record.setSignImgPath(this.saveBase64Img(record.getSignImgPath()));
            }
        } else {
            PersonPunish dbRecord = this.personPunishDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setUserid(currentUser.getId());
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.personPunishDaoAop.save(record);
    }

    public PersonPunish findById(Long id) {
        return this.personPunishDao.findById(id);
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch(dto);
        PersonPunishPageSearchDto searchDto = (PersonPunishPageSearchDto)dto;
        if (StringUtil.isNotEmpty((String)searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        this.personPunishDao.searchForPage((PersonPunishPageSearchDto)dto, page);
    }

    public List<PersonPunish> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.personPunishDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(List<PersonPunish> list) {
        ArrayList<PersonPunish> dbList = new ArrayList<PersonPunish>();
        for (PersonPunish personPunish : list) {
            PersonPunish personPunishIn = this.personPunishDao.findById(personPunish.getId());
            if (personPunishIn == null) {
                personPunish.setUpdateflag(Boolean.valueOf(false));
                continue;
            }
            if (personPunish.getUpdateTime().getTime() < personPunishIn.getUpdateTime().getTime()) {
                dbList.add(personPunish);
            }
            personPunish.setUpdateflag(Boolean.valueOf(true));
        }
        list.removeAll(dbList);
        this.personPunishDaoAop.saveBatch(list);
    }

    public List<PersonPunish> findDSOutList(String startDate) {
        return this.personPunishDao.findDSOutList(startDate);
    }

    public void importBatch(List<PersonPunish> list) {
        List dbList = this.personPunishDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PersonPunish personPunish : list) {
                personPunish.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    personPunish.setUpdateTime(DateUtil.dateAdd((int)6, (Date)personPunish.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.personPunishDaoAop.saveBatch(list);
        }
    }
}

