/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.subsidy.impl;

import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDao;
import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDaoAop;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.TrainSubsidyConfigPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.service.subsidy.TrainSubsidyConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TrainSubsidyConfigServiceImpl
implements TrainSubsidyConfigService {
    Logger logger = LoggerFactory.getLogger(TrainSubsidyConfigServiceImpl.class);
    @Autowired
    private TrainSubsidyConfigDao trainSubsidyConfigDao;
    @Autowired
    private TrainSubsidyConfigDaoAop trainSubsidyConfigDaoAop;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(TrainSubsidyConfig trainSubsidyConfig) {
        User currentUser = this.arsUtil.getCurrentUser();
        trainSubsidyConfig.setUpdateTime(new Date());
        trainSubsidyConfig.setUpdateBy(currentUser.getUsername());
        return this.trainSubsidyConfigDaoAop.delete(trainSubsidyConfig);
    }

    public void save(TrainSubsidyConfig trainSubsidyConfig) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (trainSubsidyConfig.getId() == null) {
            trainSubsidyConfig.setCreateTime(new Date());
            trainSubsidyConfig.setId(Long.valueOf(this.idWorker.nextId()));
            trainSubsidyConfig.setBatchNo(Long.valueOf(0L));
            TrainSubsidyConfig dbTrainSubsidyConfig = this.trainSubsidyConfigDao.findByTrainIdAndSubsidyCerType(trainSubsidyConfig.getTrainId(), trainSubsidyConfig.getSubsidyCerType());
            if (dbTrainSubsidyConfig != null) {
                throw new ArsException("\u8be5\u57f9\u8bad\u673a\u6784\u5df2\u914d\u7f6e\uff0c\u8bf7\u4f7f\u7528\u4fee\u6539\u529f\u80fd");
            }
        } else {
            TrainSubsidyConfig dbTrainSubsidyConfig = this.trainSubsidyConfigDao.findById(trainSubsidyConfig.getId());
            BeanUtils.copyPropertiesIgnore((Object)trainSubsidyConfig, (Object)dbTrainSubsidyConfig, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbTrainSubsidyConfig, (Object)trainSubsidyConfig, (Boolean)false);
        }
        trainSubsidyConfig.setActive(Boolean.valueOf(true));
        trainSubsidyConfig.setUpdateBy(currentUser.getUsername());
        trainSubsidyConfig.setUpdateTime(new Date());
        trainSubsidyConfig.setUpdateflag(Boolean.valueOf(true));
        trainSubsidyConfig.setUserid(currentUser.getId());
        trainSubsidyConfig.setAreaCode(currentUser.getPolice().getAreacode());
        this.trainSubsidyConfigDaoAop.save(trainSubsidyConfig);
    }

    public TrainSubsidyConfig findById(Long id) {
        return this.trainSubsidyConfigDao.findById(id);
    }

    public void searchForPage(TrainSubsidyConfigPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.trainSubsidyConfigDao.searchForPage(dto, page);
    }

    public void importBatch(List<TrainSubsidyConfig> list) {
        List dbList = this.trainSubsidyConfigDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (TrainSubsidyConfig trainSubsidyConfig : list) {
                trainSubsidyConfig.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    trainSubsidyConfig.setUpdateTime(DateUtil.dateAdd((int)6, (Date)trainSubsidyConfig.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.trainSubsidyConfigDaoAop.saveBatch(list);
        }
    }

    public List<TrainSubsidyConfig> findByBatchId(List<TrainSubsidyConfig> list) {
        return this.trainSubsidyConfigDao.findByBatchId(list);
    }

    public void updateSelective(TrainSubsidyConfig trainSubsidyConfig) {
        User currentUser = this.arsUtil.getCurrentUser();
        trainSubsidyConfig.setUpdateTime(new Date());
        trainSubsidyConfig.setUpdateBy(currentUser.getUsername());
        this.trainSubsidyConfigDaoAop.updateSelective(trainSubsidyConfig);
    }
}

