/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.statistics;

import cn.hutool.core.collection.CollUtil;
import com.bcxin.ars.dao.statistics.ApprovalStatisticsDao;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.statistics.PageResultDTO;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.service.statistics.ApprovalStatisticsService;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApprovalStatisticsServiceImpl
implements ApprovalStatisticsService {
    @Autowired
    private ApprovalStatisticsDao approvalStatisticsDao;
    @Autowired
    private SysAreaUtil sysAreaUtil;

    public Map approvalSummary(ParamDTO paramDTO) {
        if (StringUtil.isEmpty((String)paramDTO.getArea())) {
            return Maps.newHashMap();
        }
        paramDTO.setAreaCode(this.subAreaCode(paramDTO.getArea()));
        return this.approvalStatisticsDao.getApprovalTrend(paramDTO);
    }

    public List<Map> approvalAgingAnalyse(ParamDTO paramDTO) {
        this.paramAreaCode(paramDTO);
        return this.approvalStatisticsDao.getApprovalAgingAnalyse(paramDTO);
    }

    public List<Map> approvalStatusAnalyse(ParamDTO paramDTO) {
        this.paramAreaCode(paramDTO);
        return this.approvalStatisticsDao.getApprovalStatusAnalyse(paramDTO);
    }

    public Map securityExamSummary(ParamDTO paramDTO) {
        if (StringUtil.isEmpty((String)paramDTO.getArea())) {
            return Maps.newHashMap();
        }
        TreeView treeView = this.sysAreaUtil.getRegionByCode(paramDTO.getArea());
        if ("2".equals(treeView.getLevel())) {
            paramDTO.setCity(paramDTO.getArea());
        } else if ("2".equals(treeView.getLevel())) {
            paramDTO.setDistrict(paramDTO.getArea());
        }
        return this.approvalStatisticsDao.getSecurityTrend(paramDTO);
    }

    public PageResultDTO getSecurityDetail(ParamDTO paramDTO) {
        PageResultDTO resultDTO = new PageResultDTO();
        this.paramAreaCode(paramDTO);
        List list = this.approvalStatisticsDao.getSecurityDetail(paramDTO);
        resultDTO.setAllData(list);
        List pageList = CollUtil.split((Collection)list, (int)paramDTO.getNumPerPage());
        resultDTO.setPageData((List)pageList.get(paramDTO.getPageNum()));
        resultDTO.setTotalCount(Integer.valueOf(list.size()));
        return resultDTO;
    }

    private void paramAreaCode(ParamDTO paramDTO) {
        if (StringUtil.isNotEmpty((String)paramDTO.getArea())) {
            paramDTO.setAreaCode(paramDTO.getArea());
            return;
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getCity())) {
            paramDTO.setAreaCode(paramDTO.getCity().substring(0, 4));
            return;
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getProvince())) {
            paramDTO.setAreaCode(paramDTO.getProvince().substring(0, 2));
            return;
        }
    }

    private String subAreaCode(String areaCode) {
        TreeView treeView = this.sysAreaUtil.getRegionByCode(areaCode);
        if ("1".equals(treeView.getLevel())) {
            return areaCode.substring(0, 2);
        }
        if ("2".equals(treeView.getLevel())) {
            return areaCode.substring(0, 4);
        }
        return areaCode;
    }

    public static void main(String[] args) {
        String areaCode = "450000";
        System.out.println(areaCode.substring(0, 2));
        System.out.println(areaCode.substring(0, 4));
        System.out.println(areaCode.substring(0, 6));
    }
}

