/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.CyServerhtDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SbSubsidiaryBaseDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityCompanyInsuranceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.FirearmsDao;
import com.bcxin.ars.dao.sb.InvestorDao;
import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dao.sb.SafetyDao;
import com.bcxin.ars.dao.sb.VehicleDao;
import com.bcxin.ars.dao.sb.YearReportInsuranceDao;
import com.bcxin.ars.dao.sb.YearReportInvestorDao;
import com.bcxin.ars.dao.sb.YearreportdataDAO;
import com.bcxin.ars.dao.sb.YearreportdataManagerDAO;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PersonLevelDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.report.PersonPolicyDto;
import com.bcxin.ars.dto.report.TaskExecutionDto;
import com.bcxin.ars.dto.report.YearReportDto;
import com.bcxin.ars.dto.report.YearReportsSearchDto;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.dto.sb.InvestorSearchDto;
import com.bcxin.ars.dto.sb.ManagementInfoSearchDto;
import com.bcxin.ars.dto.sb.SafetySearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryBaseSearchDto;
import com.bcxin.ars.dto.sb.VehicleSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanyInsurance;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Investor;
import com.bcxin.ars.model.sb.YearReportInsurance;
import com.bcxin.ars.model.sb.YearReportInvestor;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.model.sb.YearreportdataManager;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.YearreportdataService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SysBaseUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Yearreportdata.class)
public class YearreportdataServiceImpl
implements YearreportdataService {
    @Autowired
    private YearreportdataDAO yearreportdataDAO;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private YearreportdataManagerDAO yearreportdataManagerDAO;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyInsuranceDao securityCompanyInsuranceDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private InvestorDao investorDao;
    @Autowired
    private YearReportInvestorDao yearReportinvestorDao;
    @Autowired
    private YearReportInsuranceDao yearReportInsuranceDao;
    @Autowired
    private SbSubsidiaryBaseDao sbSubsidiaryBaseDao;
    @Autowired
    private VehicleDao vehicleDao;
    @Autowired
    private FirearmsDao firearmsDao;
    @Autowired
    private SafetyDao safetyDao;
    @Autowired
    private ApprovalDAO approvalDao;
    @Autowired
    private ManagementInfoDao managementInfoDao;
    @Autowired
    private CyServerhtDao cyServerhtDao;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ComContractDao comContractDao;

    public Yearreportdata findByUserId(long userId) {
        Yearreportdata result = this.yearreportdataDAO.findByUserId(userId, this.getFilingYear());
        if (result != null) {
            YearreportdataManager querydto = new YearreportdataManager();
            querydto.setUserid(this.arsUtil.getCurrentUser().getId());
            querydto.setManagertype("001");
            result.setManges(this.yearreportdataManagerDAO.findByUserId(querydto));
            querydto.setManagertype("002");
            result.setFontmanges(this.yearreportdataManagerDAO.findByUserId(querydto));
            result.setInsuranceList(this.yearReportInsuranceDao.findByYearReportId(result.getId()));
            result.setInvestorList(this.yearReportinvestorDao.findByYearReportId(result.getId()));
            Approval approval = this.approvalDAO.findBybusinessidAndType(result.getId(), "008");
            result.setApproval(approval);
        }
        return result;
    }

    public List<Yearreportdata> findByBatchId(List<Approval> approvalList) {
        return this.yearreportdataDAO.findByBatchId(approvalList);
    }

    public void updateBatch(List<Yearreportdata> list) {
        this.yearreportdataDAO.updateBatch(list);
    }

    private String getFilingYear() {
        Integer startMonth = 10;
        String filingYear = "";
        Date now = new Date();
        Config config = this.configUtils.getConfigByKey("YEAR_REPORT_STARTMONTH");
        if (config != null) {
            startMonth = Integer.parseInt(config.getValue());
        }
        filingYear = now.getMonth() < startMonth ? DateUtil.getLastYear() : DateUtil.getCurrentDate((String)"yyyy");
        return filingYear;
    }

    public void saveOrUpdateDateForUserId(Yearreportdata yearreportdata) {
        if (yearreportdata.getOrgid() == null) {
            if (yearreportdata.getDistrictOrgId() != null) {
                yearreportdata.setOrgid(Long.valueOf(Long.parseLong(yearreportdata.getDistrictOrgId())));
            } else if (yearreportdata.getCityOrgId() != null) {
                yearreportdata.setOrgid(Long.valueOf(Long.parseLong(yearreportdata.getCityOrgId())));
            }
        }
        if (yearreportdata.getId() == null) {
            yearreportdata.setActive(Boolean.valueOf(true));
            yearreportdata.setCreateTime(new Date());
            yearreportdata.setUpdateTime(new Date());
            if (StringUtil.isEmpty((String)yearreportdata.getApprovalstate()) && "002".equals(yearreportdata.getZc())) {
                yearreportdata.setApprovalstate("001");
            }
            String filingYear = this.getFilingYear();
            yearreportdata.setFilingYear(filingYear);
            yearreportdata.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            yearreportdata.setUserid(this.arsUtil.getCurrentUser().getId());
            SecurityCompany company = this.companyDao.findByUserid(this.arsUtil.getCurrentUser().getId());
            if (company != null) {
                yearreportdata.setCompanyname(company.getName());
                yearreportdata.setAreaCode(company.getAreaCode());
            }
            this.yearreportdataDAO.save(yearreportdata);
            if (yearreportdata.isLineInsure()) {
                this.saveInsuranceCompany(yearreportdata);
            }
            this.saveManager(yearreportdata);
            if (yearreportdata.getZc() != null && yearreportdata.getZc().equals("002")) {
                this.saveStatistics(yearreportdata);
            }
        } else {
            Yearreportdata dbYearreport = this.yearreportdataDAO.findById(yearreportdata.getId());
            dbYearreport.setApprovalstate(yearreportdata.getApprovalstate());
            dbYearreport.setApprovaldate(yearreportdata.getApprovaldate());
            dbYearreport.setApprovalfile(yearreportdata.getApprovalfile());
            dbYearreport.setApprovalperson(yearreportdata.getApprovalperson());
            dbYearreport.setApprovalreason(yearreportdata.getApprovalreason());
            dbYearreport.setBjly(yearreportdata.getBjly());
            dbYearreport.setBzcgpic(yearreportdata.getBzcgpic());
            dbYearreport.setDxbayrs(yearreportdata.getDxbayrs());
            dbYearreport.setDyhdnr(yearreportdata.getDyhdnr());
            dbYearreport.setDyrs(yearreportdata.getDyrs());
            dbYearreport.setFbq(yearreportdata.getFbq());
            dbYearreport.setFeducation(yearreportdata.getFeducation());
            dbYearreport.setFpfpic(yearreportdata.getFpfpic());
            dbYearreport.setFpzpic(yearreportdata.getFpzpic());
            dbYearreport.setFtbx(yearreportdata.getFtbx());
            dbYearreport.setGdzc(yearreportdata.getGdzc());
            dbYearreport.setGmsbrs(yearreportdata.getGmsbrs());
            dbYearreport.setGsbx(yearreportdata.getGsbx());
            dbYearreport.setJyywrs(yearreportdata.getJyywrs());
            dbYearreport.setKhsl(yearreportdata.getKhsl());
            dbYearreport.setNdbg(yearreportdata.getNdbg());
            dbYearreport.setNlx(yearreportdata.getNlx());
            dbYearreport.setNyye(yearreportdata.getNyye());
            dbYearreport.setSfdjzz(yearreportdata.getSfdjzz());
            dbYearreport.setSffzbj(yearreportdata.getSffzbj());
            dbYearreport.setSffzsg(yearreportdata.getSffzsg());
            dbYearreport.setSfzqqc(yearreportdata.getSfzqqc());
            dbYearreport.setSjczgz(yearreportdata.getSjczgz());
            dbYearreport.setSqgbzrs(yearreportdata.getSqgbzrs());
            dbYearreport.setSshijbzrs(yearreportdata.getSshijbzrs());
            dbYearreport.setSsjbzrs(yearreportdata.getSsjbzrs());
            dbYearreport.setSybx(yearreportdata.getSybx());
            dbYearreport.setSyebx(yearreportdata.getSyebx());
            dbYearreport.setSzacrs(yearreportdata.getSzacrs());
            dbYearreport.setSzgpxrs(yearreportdata.getSzgpxrs());
            dbYearreport.setTgpaxs(yearreportdata.getTgpaxs());
            dbYearreport.setWhjjss(yearreportdata.getWhjjss());
            dbYearreport.setWtzlhdrc(yearreportdata.getWtzlhdrc());
            dbYearreport.setSjczgzrc(yearreportdata.getSjczgzrc());
            dbYearreport.setWtzlhd(yearreportdata.getWtzlhd());
            dbYearreport.setWz(yearreportdata.getWz());
            dbYearreport.setWzmc(yearreportdata.getWzmc());
            dbYearreport.setXgqpxrs(yearreportdata.getXgqpxrs());
            dbYearreport.setXjg(yearreportdata.getXjg());
            dbYearreport.setXpxrs(yearreportdata.getXpxrs());
            dbYearreport.setXzgpxrs(yearreportdata.getXzgpxrs());
            dbYearreport.setYcc(yearreportdata.getYcc());
            dbYearreport.setYfszsg(yearreportdata.getYfszsg());
            dbYearreport.setYgfsrs(yearreportdata.getYgfsrs());
            dbYearreport.setYgxxrs(yearreportdata.getYgxxrs());
            dbYearreport.setYlaobx(yearreportdata.getYlaobx());
            dbYearreport.setYlbx(yearreportdata.getYlbx());
            dbYearreport.setZbqkqt(yearreportdata.getZbqkqt());
            dbYearreport.setZhxyr(yearreportdata.getZhxyr());
            dbYearreport.setZjjk(yearreportdata.getZjjk());
            dbYearreport.setZjxszrrs(yearreportdata.getZjxszrrs());
            dbYearreport.setMalenum(yearreportdata.getMalenum());
            dbYearreport.setEscortnum(yearreportdata.getEscortnum());
            dbYearreport.setArmnum(yearreportdata.getArmnum());
            dbYearreport.setFemalenum(yearreportdata.getFemalenum());
            dbYearreport.setPersonnum(yearreportdata.getPersonnum());
            dbYearreport.setCjnum(yearreportdata.getCjnum());
            dbYearreport.setZjnum(yearreportdata.getZjnum());
            dbYearreport.setGjnum(yearreportdata.getGjnum());
            dbYearreport.setManagernum(yearreportdata.getManagernum());
            dbYearreport.setGjmanagernum(yearreportdata.getGjmanagernum());
            dbYearreport.setCertificateCount(yearreportdata.getCertificateCount());
            dbYearreport.setLineInsure(yearreportdata.isLineInsure());
            dbYearreport.setSzss(yearreportdata.getSzss());
            dbYearreport.setProvince(yearreportdata.getProvince());
            dbYearreport.setCity(yearreportdata.getCity());
            dbYearreport.setDistrict(yearreportdata.getDistrict());
            dbYearreport.setOrgid(yearreportdata.getOrgid());
            if (StringUtil.isNotEmpty((String)yearreportdata.getZc())) {
                dbYearreport.setZc(yearreportdata.getZc());
            }
            dbYearreport.setUpdateTime(new Date());
            String filingYear = this.getFilingYear();
            dbYearreport.setFilingYear(filingYear);
            dbYearreport.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            this.yearreportdataDAO.update(dbYearreport);
            if (yearreportdata.getZc() != null && yearreportdata.getZc().equals("002")) {
                yearreportdata.setApprovalstate("001");
                yearreportdata.setUpdateTime(new Date());
                this.saveStatistics(yearreportdata);
            }
        }
    }

    public PersonPolicyDto getPersonPolicyReportByCompanyId() {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany dbcompany = null;
        if (currentUser.getPlatform() == 2) {
            dbcompany = this.companyDao.findByUserid(currentUser.getId());
        }
        return this.personDao.getPersonPolicyReportByCompanyId(dbcompany.getId());
    }

    public void saveOrUpdate(Yearreportdata yearreportdata) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (yearreportdata.getOrgid() == null) {
            if (yearreportdata.getDistrictOrgId() != null) {
                yearreportdata.setOrgid(Long.valueOf(Long.parseLong(yearreportdata.getDistrictOrgId())));
            } else if (yearreportdata.getCityOrgId() != null) {
                yearreportdata.setOrgid(Long.valueOf(Long.parseLong(yearreportdata.getCityOrgId())));
            }
        }
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
            yearreportdata.setUserid(currentUser.getId());
        }
        if (yearreportdata.getId() == null) {
            yearreportdata.setActive(Boolean.valueOf(true));
            yearreportdata.setCreateTime(new Date());
            yearreportdata.setUpdateTime(new Date());
            if (StringUtil.isEmpty((String)yearreportdata.getApprovalstate()) && "002".equals(yearreportdata.getZc())) {
                yearreportdata.setApprovalstate("001");
            }
            String filingYear = this.getFilingYear();
            yearreportdata.setFilingYear(filingYear);
            yearreportdata.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            SecurityCompany company = this.companyDao.findByUserid(this.arsUtil.getCurrentUser().getId());
            if (company != null) {
                yearreportdata.setCompanyname(company.getName());
                yearreportdata.setAreaCode(company.getAreaCode());
            }
            this.yearreportdataDAO.save(yearreportdata);
            if (yearreportdata.isLineInsure()) {
                this.saveInsuranceCompany(yearreportdata);
            }
            this.saveManager(yearreportdata);
            if (yearreportdata.getZc() != null && yearreportdata.getZc().equals("002")) {
                this.saveStatistics(yearreportdata);
            }
        } else {
            Yearreportdata dbYearreport = this.yearreportdataDAO.findById(yearreportdata.getId());
            dbYearreport.setApprovalstate(yearreportdata.getApprovalstate());
            dbYearreport.setApprovaldate(yearreportdata.getApprovaldate());
            dbYearreport.setApprovalfile(yearreportdata.getApprovalfile());
            dbYearreport.setApprovalperson(yearreportdata.getApprovalperson());
            dbYearreport.setApprovalreason(yearreportdata.getApprovalreason());
            dbYearreport.setBjly(yearreportdata.getBjly());
            dbYearreport.setBzcgpic(yearreportdata.getBzcgpic());
            dbYearreport.setDxbayrs(yearreportdata.getDxbayrs());
            dbYearreport.setDyhdnr(yearreportdata.getDyhdnr());
            dbYearreport.setDyrs(yearreportdata.getDyrs());
            dbYearreport.setFbq(yearreportdata.getFbq());
            dbYearreport.setFeducation(yearreportdata.getFeducation());
            dbYearreport.setFpfpic(yearreportdata.getFpfpic());
            dbYearreport.setFpzpic(yearreportdata.getFpzpic());
            dbYearreport.setFtbx(yearreportdata.getFtbx());
            dbYearreport.setGdzc(yearreportdata.getGdzc());
            dbYearreport.setGmsbrs(yearreportdata.getGmsbrs());
            dbYearreport.setGsbx(yearreportdata.getGsbx());
            dbYearreport.setJyywrs(yearreportdata.getJyywrs());
            dbYearreport.setKhsl(yearreportdata.getKhsl());
            dbYearreport.setNdbg(yearreportdata.getNdbg());
            dbYearreport.setNlx(yearreportdata.getNlx());
            dbYearreport.setNyye(yearreportdata.getNyye());
            dbYearreport.setSfdjzz(yearreportdata.getSfdjzz());
            dbYearreport.setSffzbj(yearreportdata.getSffzbj());
            dbYearreport.setSffzsg(yearreportdata.getSffzsg());
            dbYearreport.setSfzqqc(yearreportdata.getSfzqqc());
            dbYearreport.setSjczgz(yearreportdata.getSjczgz());
            dbYearreport.setSqgbzrs(yearreportdata.getSqgbzrs());
            dbYearreport.setSshijbzrs(yearreportdata.getSshijbzrs());
            dbYearreport.setSsjbzrs(yearreportdata.getSsjbzrs());
            dbYearreport.setSybx(yearreportdata.getSybx());
            dbYearreport.setSyebx(yearreportdata.getSyebx());
            dbYearreport.setSzacrs(yearreportdata.getSzacrs());
            dbYearreport.setSzgpxrs(yearreportdata.getSzgpxrs());
            dbYearreport.setTgpaxs(yearreportdata.getTgpaxs());
            dbYearreport.setWhjjss(yearreportdata.getWhjjss());
            dbYearreport.setWtzlhd(yearreportdata.getWtzlhd());
            dbYearreport.setWtzlhdrc(yearreportdata.getWtzlhdrc());
            dbYearreport.setSjczgzrc(yearreportdata.getSjczgzrc());
            dbYearreport.setWz(yearreportdata.getWz());
            dbYearreport.setWzmc(yearreportdata.getWzmc());
            dbYearreport.setXgqpxrs(yearreportdata.getXgqpxrs());
            dbYearreport.setXjg(yearreportdata.getXjg());
            dbYearreport.setXpxrs(yearreportdata.getXpxrs());
            dbYearreport.setXzgpxrs(yearreportdata.getXzgpxrs());
            dbYearreport.setYcc(yearreportdata.getYcc());
            dbYearreport.setYfszsg(yearreportdata.getYfszsg());
            dbYearreport.setYgfsrs(yearreportdata.getYgfsrs());
            dbYearreport.setYgxxrs(yearreportdata.getYgxxrs());
            dbYearreport.setYlaobx(yearreportdata.getYlaobx());
            dbYearreport.setYlbx(yearreportdata.getYlbx());
            dbYearreport.setZbqkqt(yearreportdata.getZbqkqt());
            dbYearreport.setZhxyr(yearreportdata.getZhxyr());
            dbYearreport.setZjjk(yearreportdata.getZjjk());
            dbYearreport.setZjxszrrs(yearreportdata.getZjxszrrs());
            dbYearreport.setMalenum(yearreportdata.getMalenum());
            dbYearreport.setEscortnum(yearreportdata.getEscortnum());
            dbYearreport.setArmnum(yearreportdata.getArmnum());
            dbYearreport.setFemalenum(yearreportdata.getFemalenum());
            dbYearreport.setPersonnum(yearreportdata.getPersonnum());
            dbYearreport.setCjnum(yearreportdata.getCjnum());
            dbYearreport.setZjnum(yearreportdata.getZjnum());
            dbYearreport.setGjnum(yearreportdata.getGjnum());
            dbYearreport.setManagernum(yearreportdata.getManagernum());
            dbYearreport.setGjmanagernum(yearreportdata.getGjmanagernum());
            dbYearreport.setCertificateCount(yearreportdata.getCertificateCount());
            dbYearreport.setLineInsure(yearreportdata.isLineInsure());
            dbYearreport.setSzss(yearreportdata.getSzss());
            dbYearreport.setProvince(yearreportdata.getProvince());
            dbYearreport.setCity(yearreportdata.getCity());
            dbYearreport.setDistrict(yearreportdata.getDistrict());
            dbYearreport.setOrgid(yearreportdata.getOrgid());
            dbYearreport.setCityOrgId(yearreportdata.getCityOrgId());
            dbYearreport.setDistrictOrgId(yearreportdata.getDistrictOrgId());
            if (StringUtil.isNotEmpty((String)yearreportdata.getZc())) {
                dbYearreport.setZc(yearreportdata.getZc());
            }
            dbYearreport.setUpdateTime(new Date());
            String filingYear = this.getFilingYear();
            dbYearreport.setFilingYear(filingYear);
            dbYearreport.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            this.yearreportdataDAO.update(dbYearreport);
            if (yearreportdata.isLineInsure()) {
                this.saveInsuranceCompany(yearreportdata);
            }
            this.saveManager(yearreportdata);
            if (yearreportdata.getZc() != null && yearreportdata.getZc().equals("002")) {
                yearreportdata.setApprovalstate("001");
                yearreportdata.setUpdateTime(new Date());
                this.saveStatistics(yearreportdata);
            }
        }
    }

    public void saveStatistics(Yearreportdata yearreportdata) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany dbcompany = null;
        if (currentUser.getPlatform() == 2) {
            dbcompany = this.companyDao.findByUserid(currentUser.getId());
        }
        if (dbcompany != null) {
            String securityScopeStr = "";
            String securityScopes = dbcompany.getSecurityScopeType();
            if (StringUtil.isNotEmpty((String)securityScopes)) {
                for (String securityScope : securityScopes.split(",")) {
                    securityScopeStr = StringUtil.isEmpty((String)securityScopeStr) ? SysBaseUtil.getDictLabel("securityScopeType", securityScope) : securityScopeStr + "," + SysBaseUtil.getDictLabel("securityScopeType", securityScope);
                }
            }
            yearreportdata.setCompanyname(dbcompany.getName());
            yearreportdata.setAreaCode(dbcompany.getAreaCode());
            yearreportdata.setLegalPhone(dbcompany.getUser().getPhone());
            yearreportdata.setLegalPerson(dbcompany.getLegalPerson());
            yearreportdata.setLegalPersonNo(dbcompany.getLegalPersonNo());
            yearreportdata.setPublicSecurityLicenseNumber(dbcompany.getPublicSecurityLicenseNumber());
            yearreportdata.setSecurityScope(securityScopeStr);
            yearreportdata.setSocialCode(dbcompany.getSocialCode());
            yearreportdata.setTel(dbcompany.getTel());
            yearreportdata.setLocation(dbcompany.getLocation());
            if (dbcompany.getRegisteredMoney() != null) {
                yearreportdata.setRegisteredMoney(dbcompany.getRegisteredMoney().toString());
            }
            yearreportdata.setPostalcode(dbcompany.getPostalcode());
            PersonLevelDto personLevel = this.personDao.dataStatisticsLevelCountReport(dbcompany.getId());
            Long malenum = this.personDao.countManByCompanyId(dbcompany.getId());
            Long femalenum = Long.parseLong(personLevel.getPersonnum()) - malenum;
            Long escortnum = this.personDao.countArmPersonByCompanyId(dbcompany.getId());
            yearreportdata.setMalenum(malenum.toString());
            yearreportdata.setFemalenum(femalenum.toString());
            yearreportdata.setPersonnum(personLevel.getPersonnum());
            yearreportdata.setEscortnum(escortnum.toString());
            Long personCount = this.personDao.countPersonByCompanyId(dbcompany.getId());
            Long initCount = this.personDao.countInitPersonByCompanyId(dbcompany.getId());
            Long authCount = this.personDao.countAuthPersonByCompanyId(dbcompany.getId());
            Long unAuthCount = this.personDao.countUnAuthPersonByCompanyId(dbcompany.getId());
            InvestorSearchDto investorSearchDto = new InvestorSearchDto();
            investorSearchDto.setUserid(dbcompany.getUser().getId());
            if (this.investorDao.searchCount(investorSearchDto) > 0L) {
                yearreportdata.setInvestor("1");
            } else {
                yearreportdata.setInvestor("0");
            }
            SbSubsidiaryBaseSearchDto sbSubsidiaryBaseSearchDto = new SbSubsidiaryBaseSearchDto();
            sbSubsidiaryBaseSearchDto.setUserid(dbcompany.getUser().getId());
            if (this.sbSubsidiaryBaseDao.count(sbSubsidiaryBaseSearchDto) > 0L) {
                yearreportdata.setBranch("1");
            } else {
                yearreportdata.setBranch("0");
            }
            ManagementInfoSearchDto managementInfoSearchDto = new ManagementInfoSearchDto();
            managementInfoSearchDto.setUserid(dbcompany.getUser().getId());
            if (this.managementInfoDao.searchCount(managementInfoSearchDto) > 0L) {
                yearreportdata.setManagement("1");
            } else {
                yearreportdata.setManagement("0");
            }
            ComContractSearchDto dto = new ComContractSearchDto();
            dto.setComId(Long.valueOf(Long.parseLong(dbcompany.getComId())));
            dto.setContractStatus("1");
            dto.setContractType("01");
            if (this.comContractDao.searchCount(dto) > 0L) {
                yearreportdata.setServiceHt("1");
            } else {
                yearreportdata.setServiceHt("0");
            }
            dto.setContractType("02");
            if (this.comContractDao.searchCount(dto) > 0L) {
                yearreportdata.setLaborHt("1");
            } else {
                yearreportdata.setLaborHt("0");
            }
            VehicleSearchDto vehicleSearchDto = new VehicleSearchDto();
            vehicleSearchDto.setUserid(dbcompany.getUser().getId());
            long vehicle = this.vehicleDao.searchCount(vehicleSearchDto);
            FirearmsSearchDto firearmsSearchDto = new FirearmsSearchDto();
            firearmsSearchDto.setUserid(dbcompany.getUser().getId());
            long firearms = this.firearmsDao.searchCount(firearmsSearchDto);
            SafetySearchDto safetySearchDto = new SafetySearchDto();
            safetySearchDto.setUserid(dbcompany.getUser().getId());
            long safety = this.safetyDao.searchCount(safetySearchDto);
            if (vehicle > 0L || firearms > 0L || safety > 0L) {
                yearreportdata.setDevice("1");
            } else {
                yearreportdata.setDevice("0");
            }
            yearreportdata.setPersonCount(personCount.toString());
            yearreportdata.setInitCount(initCount.toString());
            yearreportdata.setAuthCount(authCount.toString());
            yearreportdata.setUnAuthCount(unAuthCount.toString());
            TaskExecutionDto taskInfo = this.taskDao.findTaskExecutionReport(dbcompany.getId());
            yearreportdata.setTaskTotal(taskInfo.getTaskTotal());
            yearreportdata.setCycleCount(taskInfo.getCycleCount());
            yearreportdata.setTemporaryCount(taskInfo.getTemporaryCount());
            yearreportdata.setUrgentCount(taskInfo.getUrgentCount());
            PersonPolicyDto personPolicy = this.personDao.getPersonPolicyReportByCompanyId(dbcompany.getId());
            Long personnum = personPolicy.getPersonnum();
            Long policyCount = personPolicy.getPolicyCount();
            Long quotaCount = personPolicy.getQuotaCount();
            this.yearReportInsuranceDao.deleteByYearReportId(yearreportdata.getId());
            if (!yearreportdata.isLineInsure()) {
                policyCount = personPolicy.getPolicyCount();
                quotaCount = personPolicy.getQuotaCount();
            } else {
                List insurances = this.securityCompanyInsuranceDao.findByCompanyId(dbcompany.getUser().getId());
                if (insurances != null && insurances.size() > 0) {
                    YearReportInsurance yearReportInsurance = null;
                    for (SecurityCompanyInsurance securityCompanyInsurance : insurances) {
                        yearReportInsurance = new YearReportInsurance();
                        yearReportInsurance.setYearReportId(yearreportdata.getId());
                        yearReportInsurance.setActive(Boolean.valueOf(true));
                        yearReportInsurance.setCompany_id(securityCompanyInsurance.getCompany_id());
                        yearReportInsurance.setCreateTime(new Date());
                        yearReportInsurance.setUpdateTime(new Date());
                        yearReportInsurance.setUpdateBy(securityCompanyInsurance.getUpdateBy());
                        yearReportInsurance.setEnd_date(securityCompanyInsurance.getEnd_date());
                        yearReportInsurance.setFlfy(securityCompanyInsurance.getFlfy());
                        yearReportInsurance.setInsurance_company(securityCompanyInsurance.getInsurance_company());
                        yearReportInsurance.setInsurance_number(securityCompanyInsurance.getInsurance_number());
                        yearReportInsurance.setInsurance_pic(securityCompanyInsurance.getInsurance_pic());
                        yearReportInsurance.setInsurance_product(securityCompanyInsurance.getInsurance_product());
                        yearReportInsurance.setInsured_num(securityCompanyInsurance.getInsured_num());
                        yearReportInsurance.setJtyw(securityCompanyInsurance.getJtyw());
                        yearReportInsurance.setJyjt(securityCompanyInsurance.getJyjt());
                        yearReportInsurance.setPremium_person(securityCompanyInsurance.getPremium_person());
                        yearReportInsurance.setProtection_date(securityCompanyInsurance.getProtection_date());
                        yearReportInsurance.setYwsg(securityCompanyInsurance.getYwsg());
                        yearReportInsurance.setYwyl(securityCompanyInsurance.getYwyl());
                        yearReportInsurance.setZdcj(securityCompanyInsurance.getZdcj());
                        this.yearReportInsuranceDao.save(yearReportInsurance);
                        Long ywsg = Long.parseLong(securityCompanyInsurance.getYwsg());
                        Long insured_num = Long.parseLong(securityCompanyInsurance.getInsured_num());
                        policyCount = policyCount + insured_num;
                        if (ywsg < 370000L) continue;
                        quotaCount = quotaCount + insured_num;
                    }
                }
                if (StringUtil.isNotEmpty((String)yearreportdata.getQuotaCount())) {
                    quotaCount = Long.parseLong(yearreportdata.getQuotaCount());
                }
            }
            if (policyCount > personnum) {
                policyCount = personnum;
            }
            if (quotaCount > policyCount) {
                quotaCount = policyCount;
            }
            Long unPolicyCount = personnum - policyCount;
            Long unQuotaCount = policyCount - quotaCount;
            yearreportdata.setUnPolicyCount(unPolicyCount.toString());
            yearreportdata.setPolicyCount(policyCount.toString());
            yearreportdata.setQuotaCount(quotaCount.toString());
            yearreportdata.setUnQuotaCount(unQuotaCount.toString());
            List approvalReports = this.approvalDao.getTypeGroupByUserId(dbcompany.getUser().getId());
            Long personcertificateCount = 0L;
            Long crosscompanyCount = 0L;
            Long subsidiaryCount = 0L;
            Long traincompanyCount = 0L;
            Long legalchangeCount = 0L;
            Long approvalCount = 0L;
            for (ReportData reportData : approvalReports) {
                approvalCount = approvalCount + reportData.getValue();
                if (reportData.getName().equals("004")) {
                    personcertificateCount = reportData.getValue();
                    continue;
                }
                if (reportData.getName().equals("005")) {
                    crosscompanyCount = reportData.getValue();
                    continue;
                }
                if (reportData.getName().equals("003")) {
                    subsidiaryCount = reportData.getValue();
                    continue;
                }
                if (reportData.getName().equals("002")) {
                    traincompanyCount = reportData.getValue();
                    continue;
                }
                if (!reportData.getName().equals("007")) continue;
                legalchangeCount = reportData.getValue();
            }
            yearreportdata.setApprovalCount(approvalCount.toString());
            yearreportdata.setPersoncertificateCount(personcertificateCount.toString());
            yearreportdata.setCrosscompanyCount(crosscompanyCount.toString());
            yearreportdata.setSubsidiaryCount(subsidiaryCount.toString());
            yearreportdata.setTraincompanyCount(traincompanyCount.toString());
            yearreportdata.setLegalchangeCount(legalchangeCount.toString());
            Long securityNum = this.cyServerhtDao.countGroupByServerObjByUserId(dbcompany.getUser().getId());
            yearreportdata.setSecurityNum(securityNum.toString());
            Long gmsbrs = Long.parseLong(yearreportdata.getGmsbrs());
            if (gmsbrs > personnum) {
                gmsbrs = personnum;
            }
            Long wgmsbrs = personnum - gmsbrs;
            yearreportdata.setGmsbrs(gmsbrs.toString());
            yearreportdata.setWgmsbrs(wgmsbrs.toString());
            this.yearreportdataDAO.updateStatistics(yearreportdata);
            List investors = this.investorDao.findByUserId(dbcompany.getUser().getId());
            this.yearReportinvestorDao.deleteByYearReportId(yearreportdata.getId());
            YearReportInvestor yearReportInvestor = null;
            for (Investor investor : investors) {
                yearReportInvestor = new YearReportInvestor();
                yearReportInvestor.setActive(Boolean.valueOf(true));
                yearReportInvestor.setAddress(investor.getAddress());
                yearReportInvestor.setChangeRecord(investor.getChangeRecord());
                yearReportInvestor.setCreateTime(new Date());
                yearReportInvestor.setFundedNumber(investor.getFundedNumber());
                yearReportInvestor.setIdNumber(investor.getIdNumber());
                yearReportInvestor.setInvestorsType(investor.getInvestorsType());
                yearReportInvestor.setName(investor.getName());
                yearReportInvestor.setNation(investor.getNation());
                yearReportInvestor.setNational(investor.getNational());
                yearReportInvestor.setNowaddress(investor.getNowaddress());
                yearReportInvestor.setPhone(investor.getPhone());
                yearReportInvestor.setRatioBefor(investor.getRatioBefor());
                yearReportInvestor.setRatioTransfer(investor.getRatioTransfer());
                yearReportInvestor.setSex(investor.getSex());
                yearReportInvestor.setShareholderBefore(investor.getShareholderBefore());
                yearReportInvestor.setStockProportion(investor.getStockProportion());
                yearReportInvestor.setTransferTime(investor.getTransferTime());
                yearReportInvestor.setUpdateBy(investor.getUpdateBy());
                yearReportInvestor.setUpdateTime(new Date());
                yearReportInvestor.setUserid(investor.getUserid());
                yearReportInvestor.setYearReportId(yearreportdata.getId());
                this.yearReportinvestorDao.save(yearReportInvestor);
            }
        }
    }

    public void saveManager(Yearreportdata yearreportdata) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (yearreportdata.getGeneralList() != null && yearreportdata.getGeneralList().size() > 0) {
            this.yearreportdataManagerDAO.del(this.arsUtil.getCurrentUser().getId().longValue());
            for (YearreportdataManager yearreportdataManager : yearreportdata.getGeneralList()) {
                if (yearreportdataManager == null || StringUtil.isEmpty((String)yearreportdataManager.getGeneralmanager())) continue;
                yearreportdataManager.setActive(Boolean.valueOf(true));
                yearreportdataManager.setCreateTime(new Date());
                yearreportdataManager.setUpdateTime(new Date());
                yearreportdataManager.setUserid(currentUser.getId());
                yearreportdataManager.setUpdateBy(currentUser.getUsername());
                this.yearreportdataManagerDAO.save(yearreportdataManager);
            }
        }
        if (yearreportdata.getViceGeneralList() != null && yearreportdata.getViceGeneralList().size() > 0) {
            for (YearreportdataManager yearreportdataManager : yearreportdata.getViceGeneralList()) {
                if (yearreportdataManager == null || StringUtil.isEmpty((String)yearreportdataManager.getGeneralmanager())) continue;
                yearreportdataManager.setActive(Boolean.valueOf(true));
                yearreportdataManager.setCreateTime(new Date());
                yearreportdataManager.setUpdateTime(new Date());
                yearreportdataManager.setUserid(currentUser.getId());
                yearreportdataManager.setUpdateBy(currentUser.getUsername());
                this.yearreportdataManagerDAO.save(yearreportdataManager);
            }
        }
    }

    public void saveInsuranceCompany(Yearreportdata yearreportdata) {
        int[] a;
        int count;
        String[] insurance_company = new String[]{};
        String[] insurance_product = new String[]{};
        String[] protection_date = new String[]{};
        String[] insured_num = new String[]{};
        String[] premium_person = new String[]{};
        String[] ywsg = new String[]{};
        String[] jtyw = new String[]{};
        String[] ywyl = new String[]{};
        String[] zdcj = new String[]{};
        String[] jyjt = new String[]{};
        String[] flfy = new String[]{};
        String[] end_date = new String[]{};
        String[] insurance_pic = new String[]{};
        String[] insurance_number = new String[]{};
        if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_company())) {
            insurance_company = yearreportdata.getInsurance_company().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_product())) {
            insurance_product = yearreportdata.getInsurance_product().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getProtection_date())) {
            protection_date = yearreportdata.getProtection_date().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getInsured_num())) {
            insured_num = yearreportdata.getInsured_num().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getPremium_person())) {
            premium_person = yearreportdata.getPremium_person().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getYwsg())) {
            ywsg = yearreportdata.getYwsg().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getJtyw())) {
            jtyw = yearreportdata.getJtyw().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getYwyl())) {
            ywyl = yearreportdata.getYwyl().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getZdcj())) {
            zdcj = yearreportdata.getZdcj().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getJyjt())) {
            jyjt = yearreportdata.getJyjt().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getFlfy())) {
            flfy = yearreportdata.getFlfy().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getEnd_date())) {
            end_date = yearreportdata.getEnd_date().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_pic())) {
            insurance_pic = yearreportdata.getInsurance_pic().split(",");
        }
        if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_number())) {
            insurance_number = yearreportdata.getInsurance_number().split(",");
        }
        if ((count = StringUtil.getMax((int[])(a = new int[]{insurance_company.length, insurance_product.length, protection_date.length, insured_num.length, premium_person.length, ywsg.length, jtyw.length, ywyl.length, zdcj.length, jyjt.length, flfy.length, end_date.length, insurance_number.length}))) > 0) {
            this.securityCompanyInsuranceDao.deleteBySid(this.arsUtil.getCurrentUser().getId().longValue());
            for (int i = 0; i < count; ++i) {
                SecurityCompanyInsurance securityCompanyInsurance = new SecurityCompanyInsurance();
                securityCompanyInsurance.setActive(Boolean.valueOf(true));
                securityCompanyInsurance.setCreateTime(new Date());
                securityCompanyInsurance.setUpdateTime(new Date());
                securityCompanyInsurance.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
                securityCompanyInsurance.setCompany_id(this.arsUtil.getCurrentUser().getId());
                if (!StringUtils.isEmpty((Object)yearreportdata.getProtection_date()) && protection_date.length > i && !protection_date[i].equals("")) {
                    securityCompanyInsurance.setProtection_date(protection_date[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getPremium_person()) && premium_person.length > i && !premium_person[i].equals("")) {
                    securityCompanyInsurance.setPremium_person(premium_person[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getInsured_num()) && insured_num.length > i && !insured_num[i].equals("")) {
                    securityCompanyInsurance.setInsured_num(insured_num[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_product()) && insurance_product.length > i) {
                    securityCompanyInsurance.setInsurance_product(insurance_product[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_company()) && insurance_company.length > i) {
                    securityCompanyInsurance.setInsurance_company(insurance_company[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getYwsg()) && ywsg.length > i) {
                    securityCompanyInsurance.setYwsg(ywsg[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getJtyw()) && jtyw.length > i) {
                    securityCompanyInsurance.setJtyw(jtyw[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getYwyl()) && ywyl.length > i) {
                    securityCompanyInsurance.setYwyl(ywyl[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getZdcj()) && zdcj.length > i) {
                    securityCompanyInsurance.setZdcj(zdcj[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getJyjt()) && jyjt.length > i) {
                    securityCompanyInsurance.setJyjt(jyjt[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getFlfy()) && flfy.length > i) {
                    securityCompanyInsurance.setFlfy(flfy[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getEnd_date()) && end_date.length > i) {
                    securityCompanyInsurance.setEnd_date(end_date[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_number()) && insurance_number.length > i) {
                    securityCompanyInsurance.setInsurance_number(insurance_number[i]);
                }
                if (!StringUtils.isEmpty((Object)yearreportdata.getInsurance_pic()) && insurance_pic.length > i) {
                    securityCompanyInsurance.setInsurance_pic(insurance_pic[i]);
                }
                this.securityCompanyInsuranceDao.save(securityCompanyInsurance);
            }
        }
    }

    public Yearreportdata findById(Long businessid) {
        Yearreportdata result = this.yearreportdataDAO.findById(businessid);
        if (result != null) {
            YearreportdataManager querydto = new YearreportdataManager();
            querydto.setUserid(result.getUserid());
            querydto.setManagertype("001");
            result.setManges(this.yearreportdataManagerDAO.findByUserId(querydto));
            querydto.setManagertype("002");
            result.setFontmanges(this.yearreportdataManagerDAO.findByUserId(querydto));
            result.setInsuranceList(this.yearReportInsuranceDao.findByYearReportId(result.getId()));
            result.setInvestorList(this.yearReportinvestorDao.findByYearReportId(result.getId()));
            Approval approval = this.approvalDao.findBybusinessidAndType(businessid, "008");
            result.setApproval(approval);
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public List<Yearreportdata> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.yearreportdataDAO.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Yearreportdata yearreport) {
        Yearreportdata dbYearreport;
        if (yearreport.getActive() == null) {
            yearreport.setActive(Boolean.valueOf(true));
        }
        if ((dbYearreport = this.yearreportdataDAO.findById(yearreport.getId())) != null) {
            if (yearreport.getUpdateTime().getTime() > dbYearreport.getUpdateTime().getTime()) {
                this.yearreportdataDAO.update(yearreport);
            }
        } else {
            this.yearreportdataDAO.save(yearreport);
        }
    }

    public PageResult queryYearReportList(YearReportsSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        List yearReports = this.yearreportdataDAO.yearReportSearch(searchDto);
        return new PageResult(Integer.valueOf(this.yearreportdataDAO.yearReportSearchCount(searchDto).intValue()), (Object)yearReports);
    }

    public void updateOperator(Yearreportdata yearreportdata) {
        User currentUser = this.arsUtil.getCurrentUser();
        Yearreportdata dbYearreportdata = this.yearreportdataDAO.findById(yearreportdata.getId());
        dbYearreportdata.setUpdateBy(currentUser.getUsername());
        dbYearreportdata.setUpdateTime(new Date());
        dbYearreportdata.setOperatorname(yearreportdata.getOperatorname());
        dbYearreportdata.setOperatorphone(yearreportdata.getOperatorphone());
        dbYearreportdata.setApprovalstate("002");
        dbYearreportdata.setApplydate(new Date());
        this.yearreportdataDAO.updateOperator(dbYearreportdata);
        String processKey = "activitiyearreportapprovalProcess";
        SecurityCompany company = this.companyDao.findByUserid(dbYearreportdata.getUserid());
        if (company != null && StringUtil.isNotEmpty((String)company.getSponsorlicenseType())) {
            processKey = BusinessType.getBusinessTypeName((String)"008", (String)company.getSponsorlicenseType());
        }
        this.approvalUtil.saveApproval("008", dbYearreportdata.getId(), processKey);
    }

    public void updateSealState(Long yearReportId, String sealState) {
        Yearreportdata dbYearreportdata = this.yearreportdataDAO.findById(yearReportId);
        dbYearreportdata.setFilingIsStamped(sealState);
        dbYearreportdata.setUpdateTime(new Date());
        this.yearreportdataDAO.updateSealState(dbYearreportdata);
    }

    public YearReportsSearchDto search(YearReportsSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        List yearReports = this.yearreportdataDAO.yearReportSearch(searchDto);
        searchDto.setTotalCount(this.yearreportdataDAO.yearReportSearchCount(searchDto));
        searchDto.setData(yearReports);
        return searchDto;
    }

    @Deprecated
    public Yearreportdata findByIdForSendMessage(Long businessid) {
        Yearreportdata result = this.yearreportdataDAO.findById(businessid);
        return result;
    }

    public void sendMessage(Yearreportdata yearreportdata) {
    }

    public void saveOrUpdateForApproval(Yearreportdata yearreport) {
        yearreport.setUpdateTime(new Date());
        this.yearreportdataDAO.update(yearreport);
    }

    public void sendMessageForLegalPerson(String userId) {
    }

    public Boolean checkOnLinePolicy() {
        Long policyCount;
        Boolean result = false;
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany dbcompany = null;
        if (currentUser.getPlatform() == 2) {
            dbcompany = this.companyDao.findByUserid(currentUser.getId());
        }
        if (dbcompany != null && (policyCount = this.personDao.findPolicyByCompanyId(dbcompany.getId())) != null && policyCount > 0L) {
            result = true;
        }
        return result;
    }

    public Boolean checkInvestorInput() {
        Boolean result = false;
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany dbcompany = null;
        if (currentUser.getPlatform() == 2) {
            dbcompany = this.companyDao.findByUserid(currentUser.getId());
        }
        if (dbcompany != null) {
            InvestorSearchDto dto = new InvestorSearchDto();
            dto.setUserid(dbcompany.getUser().getId());
            Long investorCount = this.investorDao.searchCount(dto);
            if (investorCount != null && investorCount > 0L) {
                result = true;
            }
        }
        return result;
    }

    public void updatePoliceId(Yearreportdata yearreportdata) {
        Approval approval = this.approvalDAO.getById(yearreportdata.getApprovalId());
        approval.setPoliceid(yearreportdata.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        this.approvalDAO.update(approval);
        this.yearreportdataDAO.updatePoliceId(yearreportdata);
    }

    public PageResult queryTable(YearReportsSearchDto searchDto) {
        User user;
        String areacode;
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        if (police != null) {
            areacode = police.getAreacode();
            if (areacode.endsWith("0000")) {
                searchDto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setDistrict(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setDistrict(areacode);
            }
        }
        if (StringUtil.isNotEmpty((String)(areacode = searchDto.getAreaCode()))) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        searchDto.setUserid(currentUser.getId());
        if (searchDto.getCheckType() != null && (user = this.arsUtil.getCurrentUser()) != null) {
            searchDto.setUserid(user.getId());
            if (user.getPlatform() == 2) {
                searchDto.setUserid(user.getId());
            } else {
                List roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    searchDto.setRoles(roles);
                }
            }
        }
        searchDto.setPath(currentUser.getPolice().getPath());
        List yearReports = this.yearreportdataDAO.queryTable(searchDto);
        return new PageResult(Integer.valueOf(this.yearreportdataDAO.queryTableCount(searchDto).intValue()), (Object)yearReports);
    }

    public void saveOrUpdateForApprovalImport(Yearreportdata yearreport) {
        this.yearreportdataDAO.update(yearreport);
    }

    public void edit(Yearreportdata yearreportdata) {
        if (yearreportdata.getId() != null) {
            Yearreportdata dbYearreportdata = this.findById(yearreportdata.getId());
            boolean activity = false;
            if (StringUtil.isNotEmpty((String)dbYearreportdata.getApprovalstate()) && dbYearreportdata.getApprovalstate().equals("002") && !dbYearreportdata.getOrgid().toString().equals(yearreportdata.getOrgid().toString())) {
                activity = true;
            }
            yearreportdata.setApprovalstate("002");
            this.saveOrUpdate(yearreportdata);
            if (activity) {
                String processKey = "activitiyearreportapprovalProcess";
                SecurityCompany company = this.companyDao.findById(dbYearreportdata.getCompanyid());
                if (company != null && StringUtil.isNotEmpty((String)company.getSponsorlicenseType())) {
                    processKey = BusinessType.getBusinessTypeName((String)"008", (String)company.getSponsorlicenseType());
                }
                this.approvalUtil.saveApproval("008", dbYearreportdata.getId(), processKey);
            }
        }
    }

    public void searchForPage(YearReportsSearchDto searchDto, AjaxPageResponse<YearReportDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.yearreportdataDAO.searchForPage(searchDto, page);
    }
}

