/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.YearReportInvestorDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInvestorSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.YearReportInvestor;
import com.bcxin.ars.service.sb.YearReportInvestorService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.webservice.ClientUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=YearReportInvestor.class)
public class YearReportInvestorServiceImpl
implements YearReportInvestorService {
    @Autowired
    private YearReportInvestorDao investorDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;

    public YearReportInvestor findById(long id) {
        return this.investorDao.findById(id);
    }

    public void saveOrUpdate(YearReportInvestor investor) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (investor.getId() == null) {
            investor.setActive(Boolean.valueOf(true));
            investor.setCreateTime(new Date());
            investor.setUpdateTime(new Date());
            investor.setUpdateBy(currentUser.getUsername());
            investor.setUserid(currentUser.getId());
            this.investorDao.save(investor);
        } else {
            YearReportInvestor dbYearReportInvestor = this.investorDao.findById(investor.getId().longValue());
            dbYearReportInvestor.setUpdateBy(currentUser.getUsername());
            dbYearReportInvestor.setUpdateTime(new Date());
            dbYearReportInvestor.setAddress(investor.getAddress());
            dbYearReportInvestor.setFundedNumber(investor.getFundedNumber());
            dbYearReportInvestor.setIdNumber(investor.getIdNumber());
            dbYearReportInvestor.setInvestorsType(investor.getInvestorsType());
            dbYearReportInvestor.setName(investor.getName());
            dbYearReportInvestor.setNation(investor.getNation());
            dbYearReportInvestor.setNational(investor.getNational());
            dbYearReportInvestor.setNowaddress(investor.getNowaddress());
            dbYearReportInvestor.setPhone(investor.getPhone());
            dbYearReportInvestor.setSex(investor.getSex());
            dbYearReportInvestor.setStockProportion(investor.getStockProportion());
            dbYearReportInvestor.setRatioTransfer(investor.getRatioTransfer());
            dbYearReportInvestor.setShareholderBefore(investor.getShareholderBefore());
            dbYearReportInvestor.setRatioBefor(investor.getRatioBefor());
            dbYearReportInvestor.setTransferTime(investor.getTransferTime());
            dbYearReportInvestor.setChangeRecord(investor.getChangeRecord());
            this.investorDao.update(dbYearReportInvestor);
        }
    }

    public YearReportInvestorSearchDto search(YearReportInvestorSearchDto dto) {
        YearReportInvestorSearchDto resultDto = new YearReportInvestorSearchDto();
        List list = this.investorDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.investorDao.searchCount(dto));
        return resultDto;
    }

    public void delete(YearReportInvestor investor) {
        User currentUser = this.arsUtil.getCurrentUser();
        investor.setUpdateBy(currentUser.getUsername());
        investor.setUpdateTime(new Date());
        this.investorDao.delete(investor);
    }

    public List<YearReportInvestor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.investorDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(YearReportInvestor investor) {
        if (investor.getActive() == null) {
            investor.setActive(Boolean.valueOf(true));
        }
        if (!investor.getActive().booleanValue()) {
            this.investorDao.delete(investor);
        } else {
            YearReportInvestor dbYearReportInvestor = this.investorDao.findById(investor.getId().longValue());
            if (dbYearReportInvestor == null) {
                this.investorDao.saveForDS(investor);
            } else if (investor.getUpdateTime().getTime() > dbYearReportInvestor.getUpdateTime().getTime()) {
                this.investorDao.update(investor);
            }
        }
    }

    public List<YearReportInvestor> findByUserId(Long userId) {
        return this.investorDao.findByUserId(userId);
    }
}

