/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.WorkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.WorkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Workexperience;
import com.bcxin.ars.service.sb.WorkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Workexperience.class)
public class WorkexperienceServiceImpl
implements WorkexperienceService {
    @Autowired
    private WorkexperienceDao workexperienceDao;
    @Autowired
    private ArsUtil arsUtil;

    public Workexperience findById(long id) {
        return this.workexperienceDao.findById(id);
    }

    public void saveOrUpdate(Workexperience workexperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (workexperience.getId() == null) {
            workexperience.setActive(Boolean.valueOf(true));
            workexperience.setCreateTime(new Date());
            workexperience.setUpdateTime(new Date());
            workexperience.setUpdateBy(currentUser.getUsername());
            this.workexperienceDao.save(workexperience);
        } else {
            Workexperience dbWorkexperience = this.workexperienceDao.findById(workexperience.getId().longValue());
            dbWorkexperience.setUpdateTime(new Date());
            dbWorkexperience.setCompanyname(workexperience.getCompanyname());
            dbWorkexperience.setEnddate(workexperience.getEnddate());
            dbWorkexperience.setPost(workexperience.getPost());
            dbWorkexperience.setStartdate(workexperience.getStartdate());
            dbWorkexperience.setUpdateBy(currentUser.getUsername());
            dbWorkexperience.setUpdateTime(new Date());
            this.workexperienceDao.update(dbWorkexperience);
        }
    }

    public void saveOrUpdateForDS(Workexperience workexperience) {
        Workexperience dbWorkexperience;
        if (workexperience.getActive() == null) {
            workexperience.setActive(Boolean.valueOf(true));
        }
        if ((dbWorkexperience = this.workexperienceDao.findById(workexperience.getId().longValue())) != null) {
            if (workexperience.getUpdateTime().getTime() > dbWorkexperience.getUpdateTime().getTime()) {
                this.workexperienceDao.update(workexperience);
            }
        } else {
            this.workexperienceDao.saveForDS(workexperience);
        }
    }

    public WorkexperienceSearchDto search(WorkexperienceSearchDto dto) {
        WorkexperienceSearchDto resultDto = new WorkexperienceSearchDto();
        List list = this.workexperienceDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.workexperienceDao.searchCount(dto));
        return resultDto;
    }

    public List<Workexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.workexperienceDao.searchForDataSynchronization(searchDto);
    }
}

