/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.SubsidiaryDao;
import com.bcxin.ars.dao.sb.SubsidiaryDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SbSubsidiaryBase;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.SbSubsidiaryBaseService;
import com.bcxin.ars.service.sb.SubsidiaryService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.Bafwgsfgsglry;
import com.bcxin.ars.webservice.Bafwgsfgsxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Subsidiary.class)
public class SubsidiaryServiceImpl
implements SubsidiaryService {
    private Logger logger = LoggerFactory.getLogger(SubsidiaryServiceImpl.class);
    @Autowired
    private SubsidiaryDao subsidiaryDao;
    @Autowired
    private SubsidiaryDaoAop subsidiaryDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SbSubsidiaryBaseService sbSubsidiaryBaseService;
    @Autowired
    private ClientUtil clientUtil;

    public Subsidiary findById(long id) {
        Subsidiary result = this.subsidiaryDao.findById(Long.valueOf(id));
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(result.getId(), "003"));
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public List<Subsidiary> findByBatchId(List<Approval> approvalList) {
        return this.subsidiaryDao.findByBatchId(approvalList);
    }

    public void saveOrUpdate(Subsidiary subsidiary) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
            subsidiary.setUserid(currentUser.getId());
        }
        if (subsidiary.getOrgid() == null) {
            if (subsidiary.getDistrictOrgId() != null) {
                subsidiary.setOrgid(Long.valueOf(Long.parseLong(subsidiary.getDistrictOrgId())));
            } else if (subsidiary.getCityOrgId() != null) {
                subsidiary.setOrgid(Long.valueOf(Long.parseLong(subsidiary.getCityOrgId())));
            }
        }
        if (subsidiary.getId() == null) {
            Subsidiary checkSubsidiary;
            if (!subsidiary.getApprovalstate().equals("001") && (checkSubsidiary = this.subsidiaryDao.findApproveBySoncompanyname(subsidiary)) != null) {
                throw new ArsException(subsidiary.getSoncompanyname() + "\u5df2\u5907\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            subsidiary.setActive(Boolean.valueOf(true));
            subsidiary.setCreateTime(new Date());
            subsidiary.setUpdateTime(new Date());
            subsidiary.setUpdateBy(currentUser.getUsername());
            this.subsidiaryDao.save(subsidiary);
            if (subsidiary.getApprovalstate().equals("002")) {
                this.approvalUtil.saveApproval("003", subsidiary.getId(), "activitisubsidiaryapprovalProcess");
            }
        } else {
            Subsidiary checkSubsidiary;
            if (!subsidiary.getApprovalstate().equals("001") && (checkSubsidiary = this.subsidiaryDao.findApproveBySoncompanyname(subsidiary)) != null && checkSubsidiary.getId().longValue() != subsidiary.getId().longValue()) {
                throw new ArsException(subsidiary.getSoncompanyname() + "\u5df2\u5907\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            Subsidiary dbSubsidiary = this.subsidiaryDao.findById(subsidiary.getId());
            boolean activity = true;
            if (StringUtil.isNotEmpty((String)dbSubsidiary.getApprovalstate()) && dbSubsidiary.getApprovalstate().equals("002") && dbSubsidiary.getOrgid().toString().equals(subsidiary.getOrgid().toString())) {
                Approval approval;
                activity = false;
                if (!dbSubsidiary.getCompanyname().equals(subsidiary.getCompanyname()) && (approval = this.approvalDAO.findBybusinessidAndType(subsidiary.getId(), "003")) != null) {
                    this.approvalUtil.updateContent(approval, subsidiary.getCompanyname());
                }
            }
            if ("001".equals(subsidiary.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore((Object)subsidiary, (Object)dbSubsidiary, (String)"active,createTime,userid", (Boolean)true);
            } else {
                BeanUtils.copyPropertiesIgnore((Object)subsidiary, (Object)dbSubsidiary, (Boolean)true);
            }
            dbSubsidiary.setUpdateTime(new Date());
            dbSubsidiary.setUpdateBy(currentUser.getUsername());
            if (subsidiary.getApprovalstate() == null || "".equals(subsidiary.getApprovalstate()) || subsidiary.getApprovalstate().equals("002")) {
                dbSubsidiary.setApprovalstate("002");
                dbSubsidiary.setChargecensorstatus("");
                dbSubsidiary.setLegalcensorstatus("");
            }
            this.subsidiaryDaoAop.update(dbSubsidiary);
            if (activity && "002".equals(dbSubsidiary.getApprovalstate())) {
                this.approvalUtil.saveApproval("003", dbSubsidiary.getId(), "activitisubsidiaryapprovalProcess");
            }
            if (dbSubsidiary.getApprovalstate().equals("003")) {
                SbSubsidiaryBase sbSubsidiaryBase = new SbSubsidiaryBase();
                sbSubsidiaryBase.setActive(Boolean.valueOf(true));
                sbSubsidiaryBase.setBusinessPlace(dbSubsidiary.getProvince() + dbSubsidiary.getCity() + dbSubsidiary.getDistrict());
                sbSubsidiaryBase.setCode(dbSubsidiary.getLicencenum());
                sbSubsidiaryBase.setCompanyName(dbSubsidiary.getCompanyname());
                sbSubsidiaryBase.setCreateTime(new Date());
                sbSubsidiaryBase.setMoneyPrincipal(dbSubsidiary.getChargename());
                sbSubsidiaryBase.setMoneyPrincipalId(dbSubsidiary.getChargecardnumber());
                sbSubsidiaryBase.setMoneyPrincipalPhone(dbSubsidiary.getChargephone());
                sbSubsidiaryBase.setRegisterAddress(dbSubsidiary.getAddress());
                sbSubsidiaryBase.setUpdateBy(currentUser.getUsername());
                sbSubsidiaryBase.setUpdateTime(new Date());
                sbSubsidiaryBase.setUserid(dbSubsidiary.getUserid());
                this.sbSubsidiaryBaseService.saveOrUpdate(sbSubsidiaryBase);
                new Thread(() -> {
                    try {
                        this.buildWebServiceEntity(sbSubsidiaryBase);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
                new Thread(() -> {
                    try {
                        Bafwgsfgsglry bafwgsfgsglry = new Bafwgsfgsglry();
                        bafwgsfgsglry.setBagsbm(dbSubsidiary.getLicencenum());
                        bafwgsfgsglry.setFgsmc(dbSubsidiary.getCompanyname());
                        bafwgsfgsglry.setSfzh(dbSubsidiary.getChargecardnumber());
                        bafwgsfgsglry.setXm(dbSubsidiary.getChargename());
                        bafwgsfgsglry.setZjlx("01");
                        bafwgsfgsglry.setZw(dbSubsidiary.getChargepost());
                        bafwgsfgsglry.setBafwxkz(dbSubsidiary.getLicencenum());
                        this.clientUtil.send("xxba_bafwgsfgsglry", (Object)bafwgsfgsglry);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
            }
        }
    }

    private void buildWebServiceEntity(SbSubsidiaryBase dbSbSubsidiaryBase) throws Exception {
        Bafwgsfgsxx bafwgsfgsxx = new Bafwgsfgsxx();
        HashMap<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("fgsmc", new KeyAndDefauleVal("companyName", (Object)dbSbSubsidiaryBase.getCompanyName()));
        map.put("xxdz", new KeyAndDefauleVal("registerAddress", null));
        map.put("jydxz", new KeyAndDefauleVal("businessPlace", null));
        map.put("bajgbm", new KeyAndDefauleVal("filingAuthorityCode", null));
        map.put("bajgmc", new KeyAndDefauleVal("filingAuthorityName", null));
        map.put("zcdz", new KeyAndDefauleVal("registerAddress", (Object)""));
        map.put("jydz", new KeyAndDefauleVal("registerAddress", (Object)""));
        map.put("bz1", new KeyAndDefauleVal("filingAuthorityName", (Object)""));
        map.put("bz2", new KeyAndDefauleVal("filingAuthorityName", (Object)""));
        map.put("bz3", new KeyAndDefauleVal("filingAuthorityName", (Object)""));
        map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", (Object)dbSbSubsidiaryBase.getCode()));
        try {
            EntityForWebServiceUtil.copy(map, (Object)dbSbSubsidiaryBase, (Object)bafwgsfgsxx);
            this.clientUtil.send("xxba_bafwgsfgsxx", (Object)bafwgsfgsxx);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveOrUpdateForDS(Subsidiary subsidiary) {
        Subsidiary dbSubsidiary;
        if (subsidiary.getActive() == null) {
            subsidiary.setActive(Boolean.valueOf(true));
        }
        if ((dbSubsidiary = this.subsidiaryDao.findById(subsidiary.getId())) != null) {
            if (subsidiary.getUpdateTime().getTime() > dbSubsidiary.getUpdateTime().getTime()) {
                subsidiary.setChargecensorstatus(dbSubsidiary.getChargecensorstatus());
                subsidiary.setLegalcensorstatus(dbSubsidiary.getLegalcensorstatus());
                this.subsidiaryDaoAop.update(subsidiary);
            }
        } else {
            this.subsidiaryDao.save(subsidiary);
        }
    }

    public SubsidiarySearchDto search(SubsidiarySearchDto dto) {
        SubsidiarySearchDto resultDto = new SubsidiarySearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        String areacode = police.getAreacode();
        if (areacode.endsWith("0000")) {
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {
            dto.setDistrict(areacode);
        }
        List list = this.subsidiaryDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.subsidiaryDao.searchCount(dto));
        return resultDto;
    }

    public Subsidiary findByUser(Long userid) {
        return this.subsidiaryDao.findByUser(userid);
    }

    public List<Subsidiary> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.subsidiaryDao.searchForDataSynchronization(searchDto);
    }

    public List<Subsidiary> findAll() {
        return this.subsidiaryDao.findAll();
    }

    public PageResult searchSubsidiaryList_table(Map<Object, Object> p) {
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }
        if (police != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
        }
        return new PageResult(Integer.valueOf(this.subsidiaryDao.countSubsidiaryList(p)), (Object)this.subsidiaryDao.searchSubsidiaryList(p));
    }

    public void searchForPage(SubsidiarySearchDto dto, AjaxPageResponse<Subsidiary> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.subsidiaryDao.searchForPage(dto, page);
    }

    public void saveOrUpdateForApproval(Subsidiary subsidiary) {
        subsidiary.setUpdateTime(new Date());
        this.subsidiaryDaoAop.update(subsidiary);
    }

    public void updateCensorStatus(Subsidiary subsidiary) {
        this.subsidiaryDaoAop.update(subsidiary);
    }

    public void saveOrUpdateForApprovalImport(Subsidiary subsidiary) {
        this.subsidiaryDaoAop.update(subsidiary);
    }

    public void saveOrUpdateForApprovalBatchImport(List<Subsidiary> subsidiary) {
        this.subsidiaryDaoAop.updateBatch(subsidiary);
    }
}

