/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.PersonworkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.PersonworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Personworkexperience;
import com.bcxin.ars.service.sb.PersonworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Personworkexperience.class)
public class PersonworkexperienceServiceImpl
implements PersonworkexperienceService {
    @Autowired
    private PersonworkexperienceDao personworkexperienceDao;
    @Autowired
    private ArsUtil arsUtil;

    public Personworkexperience findById(long id) {
        return this.personworkexperienceDao.findById(id);
    }

    public void saveOrUpdate(Personworkexperience personworkexperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (personworkexperience.getId() == null) {
            personworkexperience.setActive(Boolean.valueOf(true));
            personworkexperience.setCreateTime(new Date());
            personworkexperience.setUpdateTime(new Date());
            personworkexperience.setUpdateBy(currentUser.getUsername());
            this.personworkexperienceDao.save(personworkexperience);
        } else {
            Personworkexperience dbPersonworkexperience = this.personworkexperienceDao.findById(personworkexperience.getId().longValue());
            dbPersonworkexperience.setUpdateBy(currentUser.getUsername());
            dbPersonworkexperience.setUpdateTime(new Date());
            dbPersonworkexperience.setCompanyname(personworkexperience.getCompanyname());
            dbPersonworkexperience.setEnddate(personworkexperience.getEnddate());
            dbPersonworkexperience.setLiveReason(personworkexperience.getLiveReason());
            dbPersonworkexperience.setPost(personworkexperience.getPost());
            dbPersonworkexperience.setRemarks(personworkexperience.getRemarks());
            dbPersonworkexperience.setStartdate(personworkexperience.getStartdate());
            dbPersonworkexperience.setWorkContent(personworkexperience.getWorkContent());
            this.personworkexperienceDao.update(dbPersonworkexperience);
        }
    }

    public void saveOrUpdateForDS(Personworkexperience personworkexperience) {
        if (personworkexperience.getActive() == null) {
            personworkexperience.setActive(Boolean.valueOf(true));
        }
        if (!personworkexperience.getActive().booleanValue()) {
            this.personworkexperienceDao.delete(personworkexperience);
        } else {
            Personworkexperience dbPersonworkexperience = this.personworkexperienceDao.findById(personworkexperience.getId().longValue());
            if (dbPersonworkexperience != null) {
                if (personworkexperience.getUpdateTime().getTime() > dbPersonworkexperience.getUpdateTime().getTime()) {
                    this.personworkexperienceDao.update(personworkexperience);
                }
            } else {
                this.personworkexperienceDao.saveForDS(personworkexperience);
            }
        }
    }

    public PersonworkexperienceSearchDto search(PersonworkexperienceSearchDto dto) {
        PersonworkexperienceSearchDto resultDto = new PersonworkexperienceSearchDto();
        List list = this.personworkexperienceDao.search(dto);
        resultDto.setData(list);
        if (dto.isPaging()) {
            resultDto.setTotalCount(this.personworkexperienceDao.searchCount(dto));
        }
        return resultDto;
    }

    public List<Personworkexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.personworkexperienceDao.searchForDataSynchronization(searchDto);
    }

    public void delete(Personworkexperience personworkexperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        personworkexperience.setUpdateBy(currentUser.getUsername());
        personworkexperience.setUpdateTime(new Date());
        this.personworkexperienceDao.delete(personworkexperience);
    }

    public List<Personworkexperience> searchByPid(Long pid) {
        return this.personworkexperienceDao.searchByPid(pid);
    }
}

