/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersonAdaptDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.PersonAdaptPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.PersonAdaptService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PersonAdapt.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=PersonAdapt.class)
public class PersonAdaptServiceImpl
extends BaseService
implements PersonAdaptService {
    Logger logger = LoggerFactory.getLogger(PersonAdaptServiceImpl.class);
    @Autowired
    private PersonAdaptDao personAdaptDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    public int delete(PersonAdapt personAdapt) {
        User currentUser = this.arsUtil.getCurrentUser();
        personAdapt.setUpdateTime(new Date());
        personAdapt.setUpdateBy(currentUser.getUsername());
        return this.personAdaptDao.delete(personAdapt);
    }

    public int save(PersonAdapt personAdapt) {
        PersonAdapt dbPersonAdapt;
        if (StringUtil.isNotEmpty((String)personAdapt.getConfirmCerUrl())) {
            personAdapt.setConfirmCerUrl(this.getPhotoPath(personAdapt.getConfirmCerUrl()));
        }
        if ((dbPersonAdapt = this.personAdaptDao.findById(personAdapt.getId())) == null) {
            personAdapt.setCreateTime(new Date());
        } else {
            BeanUtils.copyPropertiesIgnore((Object)personAdapt, (Object)dbPersonAdapt, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPersonAdapt, (Object)personAdapt, (Boolean)false);
        }
        personAdapt.setActive(Boolean.valueOf(true));
        personAdapt.setUpdateTime(new Date());
        personAdapt.setUpdateflag(Boolean.valueOf(true));
        return this.personAdaptDao.save(personAdapt);
    }

    public PersonAdapt findById(Long id) {
        return this.personAdaptDao.findById(id);
    }

    public void searchForPage(PersonAdaptPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.personAdaptDao.searchForPage(dto, page);
    }

    public void importBatch(List<PersonAdapt> list) {
        List dbList = this.personAdaptDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            Map dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            for (PersonAdapt personAdapt : list) {
                personAdapt.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    if (dbCensorStatusMap.get(personAdapt.getId()) != null && StringUtil.isEmpty((String)((PersonAdapt)dbCensorStatusMap.get(personAdapt.getId())).getCensorStatus()) && StringUtil.isNotEmpty((String)personAdapt.getCensorStatus())) {
                        param = new JSONObject();
                        param.put("adaptApplyId", (Object)(personAdapt.getId() + ""));
                        param.put("backgroundStatus", (Object)personAdapt.getCensorStatus());
                        param.put("approvalState", (Object)personAdapt.getApprovalState());
                        param.put("backgroundFailReason", (Object)personAdapt.getApprovalReason());
                        param.put("backgroundType", (Object)"1");
                        paramArr.add((Object)param);
                    }
                    personAdapt.setUpdateTime(DateUtil.dateAdd((int)6, (Date)personAdapt.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.configUtils.isIntranet() && paramArr.size() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("personList", JSON.toJSONString((Object)paramArr));
                AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/adapt/person/backgroundStatus", paramMap);
                if (!result.isSuccessful()) {
                    throw new ArsException("\u3010\u7b49\u7ea7\u8bc1\u62a5\u540d\u80cc\u666f\u7b5b\u67e5\u7ed3\u679c\u3011" + result.getMsg());
                }
            }
            this.personAdaptDao.saveBatch(list);
        }
    }

    public List<PersonAdapt> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.personAdaptDao.searchForDataSynchronization(dto);
    }

    public List<PersonAdapt> findDSOutList(String startDate) {
        return this.personAdaptDao.findDSOutList(startDate);
    }

    public List<PersonAdapt> findByBatchId(List<PersonAdapt> list) {
        return this.personAdaptDao.findByBatchId(list);
    }

    public void batchUpdate(List<PersonAdapt> list) {
        List dbList = this.personAdaptDao.findByBatchId(list);
        if (dbList.size() > 0) {
            Map personAdaptMap = list.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            PersonAdapt personAdapt = null;
            for (PersonAdapt dbPersonAdapt : dbList) {
                personAdapt = (PersonAdapt)personAdaptMap.get(dbPersonAdapt.getId());
                BeanUtils.copyPropertiesIgnore((Object)personAdapt, (Object)dbPersonAdapt, (Boolean)true);
                dbPersonAdapt.setUpdateTime(new Date());
                dbPersonAdapt.setUpdateflag(Boolean.valueOf(true));
            }
            this.personAdaptDao.saveBatch(dbList);
        }
    }

    public void updateSelective(PersonAdapt personAdapt) {
        User currentUser = this.arsUtil.getCurrentUser();
        personAdapt.setUpdateTime(new Date());
        personAdapt.setUpdateBy(currentUser.getUsername());
        this.personAdaptDao.updateSelective(personAdapt);
    }
}

