/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.GradePracticeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.GradePractice;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.GradePracticeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradePractice.class)
public class GradePracticeServiceImpl
extends BaseService
implements GradePracticeService {
    public static Logger logger = LoggerFactory.getLogger(GradePracticeServiceImpl.class);
    @Autowired
    private GradePracticeDao gradePracticeDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public List<GradePractice> query(GradePracticeSearchDto dto, AjaxPageResponse<GradePractice> ajaxPageResponse) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        return this.gradePracticeDao.query(dto, ajaxPageResponse);
    }

    public void saveOrUpdateForDS(GradePractice gradePractice) {
        GradePractice dbGradePractice = this.gradePracticeDao.findById(gradePractice.getId());
        if (dbGradePractice != null) {
            if (gradePractice.getUpdateTime().getTime() > dbGradePractice.getUpdateTime().getTime()) {
                this.gradePracticeDao.update(gradePractice);
            }
        } else {
            this.gradePracticeDao.insert(gradePractice);
        }
    }

    public List<GradePractice> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradePracticeDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdate(GradePractice dto) {
        dto.setActive(Boolean.valueOf(true));
        dto.setUpdateBy("System");
        dto.setUpdateTime(new Date());
        Config config = this.configUtils.getConfigByKey(Constants.COVERT_PRACTOCE_LOCATION);
        if (config == null || config.getValue().equals(Constants.COVERT_PRACTOCE)) {
            if (StringUtil.isNotEmpty((String)dto.getUniformImg())) {
                dto.setUniformImg(this.getPhotoPath(dto.getUniformImg()));
            }
            if (StringUtil.isNotEmpty((String)dto.getAddressImg())) {
                dto.setAddressImg(this.getPhotoPath(dto.getAddressImg()));
            }
            if (StringUtil.isNotEmpty((String)dto.getProcessImg())) {
                dto.setProcessImg(this.getPhotoPath(dto.getProcessImg()));
            }
            if (StringUtil.isNotEmpty((String)dto.getVideo())) {
                dto.setVideo(this.getPhotoPath(dto.getVideo()));
            }
        }
        if (StringUtil.isEmpty((String)dto.getGradeLevel())) {
            dto.setGradeLevel("1");
        }
        if (dto.getId() == null) {
            dto.setCreateTime(new Date());
            this.gradePracticeDao.insert(dto);
        } else {
            GradePractice dbGradePractice = this.gradePracticeDao.findById(dto.getId());
            if (dbGradePractice != null) {
                BeanUtils.copyPropertiesIgnore((Object)dto, (Object)dbGradePractice, (Boolean)true);
                this.gradePracticeDao.update(dbGradePractice);
            } else {
                dto.setCreateTime(new Date());
                this.gradePracticeDao.insert(dto);
            }
        }
    }

    public void del(GradePractice record) {
        record.setUpdateTime(new Date());
        record.setActive(Boolean.valueOf(false));
        this.gradePracticeDao.del(record);
    }

    public List<GradePractice> findByPersonIdAndGradeLevel(Long personId, String gradeLevel) {
        return this.gradePracticeDao.findByPersonIdAndGradeLevel(personId, gradeLevel);
    }
}

