/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.GradeClassDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.GradeClassPageSearchDto;
import com.bcxin.ars.dto.sb.GradeClassDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeClass;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.GradeClassService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradeClass.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
@DataSyncOutAnnotation(getClazz=GradeClass.class)
public class GradeClassServiceImpl
extends BaseService
implements GradeClassService {
    public static Logger logger = LoggerFactory.getLogger(GradeClassServiceImpl.class);
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private GradeClassDao gradeClassDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;
    @Resource
    private IdWorker idWorker;
    @Resource
    private PersonGradeDao personGradeDao;
    @Resource
    private SecurityCompanyDao securityCompanyDao;

    public List<GradeClass> query(GradeClassPageSearchDto dto, AjaxPageResponse<GradeClass> ajaxPageResponse) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        return this.gradeClassDao.query(dto, ajaxPageResponse);
    }

    public List<GradeClass> findDSOutList(String startDate) {
        return this.gradeClassDao.searchForExport(startDate);
    }

    public GradeClass findById(Long id) {
        return this.gradeClassDao.findById(id);
    }

    public List<GradeClass> findByBatchId(List<GradeClass> list) {
        return null;
    }

    public void saveOrUpdateForDS(GradeClass gradeClass) {
        GradeClass dbGradeClass = this.findById(gradeClass.getId());
        if (dbGradeClass != null) {
            if (gradeClass.getUpdateTime().getTime() > dbGradeClass.getUpdateTime().getTime()) {
                this.gradeClassDao.update(gradeClass);
            }
        } else {
            this.gradeClassDao.insert(gradeClass);
        }
    }

    public void saveAppealApproval(GradeClass gradeClass) {
        GradeClass dbGradeClass = this.findById(gradeClass.getId());
        BeanUtils.copyPropertiesIgnore((Object)gradeClass, (Object)dbGradeClass, (Boolean)true);
        User user = this.arsUtil.getCurrentUser();
        dbGradeClass.setUpdateBy(user.getUsername());
        dbGradeClass.setUpdateTime(new Date());
        dbGradeClass.setUpdateflag(Boolean.valueOf(true));
        this.gradeClassDao.update(dbGradeClass);
    }

    public void importBatch(List<GradeClass> list) {
        List dbList = this.gradeClassDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list != null && list.size() > 0) {
            Map dbMap = dbList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            ArrayList<GradeClass> approvals = new ArrayList<GradeClass>();
            for (GradeClass gradeClass : list) {
                if (!this.configUtils.isIntranet() && dbMap.get(gradeClass.getId()) != null && StringUtil.isNotEmpty((String)gradeClass.getApprovalState()) && !gradeClass.getApprovalState().equals(((GradeClass)dbMap.get(gradeClass.getId())).getApprovalState())) {
                    approvals.add(gradeClass);
                }
                try {
                    gradeClass.setUpdateflag(Boolean.valueOf(false));
                    gradeClass.setUpdateTime(DateUtil.dateAdd((int)6, (Date)gradeClass.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            try {
                this.gradeClassDao.updateBatch(list);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            if (approvals != null && approvals.size() > 0) {
                for (GradeClass gradeClass : approvals) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("gradeClassId", gradeClass.getId());
                    paramMap.put("approvalStatus", gradeClass.getApprovalState());
                    this.bktInterfaceUtil.callInterface("train/bbd/grade/class/approvalStatus", paramMap);
                }
            }
        }
    }

    public List<GradeClass> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradeClassDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdate(GradeClassDto gradeClass) {
        GradeClass dbGradeClass;
        gradeClass.setUpdateTime(new Date());
        gradeClass.setUpdateflag(Boolean.valueOf(false));
        if (StringUtil.isEmpty((String)gradeClass.getGradeLevel())) {
            gradeClass.setGradeLevel("1");
        }
        if (StringUtil.isNotEmpty((String)gradeClass.getPracticeScheduleUrl())) {
            gradeClass.setPracticeScheduleUrl(this.getPhotoPath(gradeClass.getPracticeScheduleUrl()));
        }
        if (StringUtil.isNotEmpty((String)gradeClass.getPracticeSignUrl())) {
            gradeClass.setPracticeSignUrl(this.getPhotoPath(gradeClass.getPracticeSignUrl()));
        }
        if (StringUtil.isNotEmpty((String)gradeClass.getPoliceCheckUrl())) {
            gradeClass.setPoliceCheckUrl(this.getPhotoPath(gradeClass.getPoliceCheckUrl()));
        }
        if (gradeClass.getClassPersonIds() != null && gradeClass.getClassPersonIds().length > 0) {
            this.gradeClassDao.addPersonClass(gradeClass);
        }
        if ((dbGradeClass = this.findById(gradeClass.getId())) != null) {
            BeanUtils.copyPropertiesIgnore((Object)gradeClass, (Object)dbGradeClass, (Boolean)true);
            this.gradeClassDao.update(dbGradeClass);
        } else {
            gradeClass.setCreateTime(new Date());
            gradeClass.setActive(Boolean.valueOf(true));
            gradeClass.setUpdateBy("System");
            gradeClass.setApprovalState("002");
            this.gradeClassDao.insert((GradeClass)gradeClass);
        }
    }

    public void updateCancelClass(GradeClassDto gradeClass) {
        GradeClass dbGradeClass = this.findById(gradeClass.getId());
        dbGradeClass.setUpdateBy("system");
        dbGradeClass.setUpdateTime(new Date());
        dbGradeClass.setApprovalState("006");
        dbGradeClass.setPerNum(Integer.valueOf(0));
        this.gradeClassDao.update(dbGradeClass);
        this.gradeClassDao.delPersonClassByCancel(gradeClass);
    }

    public void updateClassPersonInfo(GradeClassDto dto) {
        GradeClass dbGradeClass = this.findById(dto.getId());
        BeanUtils.copyPropertiesIgnore((Object)dbGradeClass, (Object)dto, (Boolean)true);
        if ("1".equals(dto.getType())) {
            this.gradeClassDao.addPersonClass(dto);
        } else {
            this.gradeClassDao.delPersonClass(dto);
        }
        this.gradeClassDao.updatePerNum(dto);
    }

    public void autoUpdateApprovalState(String hour) {
        this.gradeClassDao.autoUpdateApprovalState(hour);
    }

    public AjaxResult addGradeClassRequest(String gradeClassInfo) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeClassInfo).getSubject();
        GradeClassDto gradeClass = (GradeClassDto)JSON.parseObject((String)subject, GradeClassDto.class);
        if (StringUtil.isBlank((CharSequence)gradeClass.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u63d0\u4ea4\u5931\u8d25, \u7f3a\u5c11\u73ed\u7ea7\u540d\u79f0");
            return ajaxResult;
        }
        int gradeClassCount = this.gradeClassDao.getByGradeName(gradeClass.getName());
        if (gradeClassCount > 0) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u63d0\u4ea4\u5931\u8d25, \u8be5\u540d\u79f0\u5df2\u5b58\u5728");
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        long id = this.idWorker.nextId();
        Date now = new Date();
        gradeClass.setId(Long.valueOf(id));
        gradeClass.setUserid(userId);
        gradeClass.setApprovalState("002");
        gradeClass.setUpdateTime(now);
        gradeClass.setCreateTime(now);
        gradeClass.setActive(Boolean.valueOf(true));
        gradeClass.setPerNum(Integer.valueOf(gradeClass.getIdNumberList().size()));
        gradeClass.setGradeLevel("1");
        this.gradeClassDao.insert((GradeClass)gradeClass);
        if (gradeClass.getIdNumberList().size() > 0) {
            this.gradeClassDao.addPersonClassByIdNumberList(gradeClass);
        }
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u64cd\u4f5c\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult getGradeClassRequestResult(String gradeClassName) {
        String name = JwtUtil.parseJWT((String)gradeClassName).getSubject();
        AjaxResult ajaxResult = new AjaxResult();
        if (StringUtil.isBlank((CharSequence)name)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u67e5\u8be2\u5931\u8d25, \u7f3a\u5c11\u73ed\u7ea7\u540d\u79f0");
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        String trainId = currentUser.getComId();
        String approvalState = this.gradeClassDao.getApprovalStateByGradeName(name, trainId);
        ajaxResult.setData((Object)JwtUtil.createJWT((String)approvalState));
        ajaxResult.setMsg("\u67e5\u8be2\u6210\u529f");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    public AjaxResult addGradeClassPerson(String gradeClass) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeClass).getSubject();
        GradeClassDto gradeClassDto = (GradeClassDto)JSON.parseObject((String)subject, GradeClassDto.class);
        List idNumberList = gradeClassDto.getIdNumberList();
        if (StringUtil.isBlank((CharSequence)gradeClassDto.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u6dfb\u52a0\u5931\u8d25, \u7f3a\u5c11\u73ed\u7ea7\u540d\u79f0");
            return ajaxResult;
        }
        if (CollectionUtil.isEmpty((Collection)idNumberList)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u6dfb\u52a0\u5931\u8d25, \u8eab\u4efd\u8bc1\u5217\u8868\u4e3a\u7a7a");
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        gradeClassDto.setUserid(userId);
        Long classId = this.gradeClassDao.getClassIdByGradeName(gradeClassDto);
        if (classId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u6dfb\u52a0\u5931\u8d25, \u73ed\u7ea7\u4e0d\u5b58\u5728");
            return ajaxResult;
        }
        gradeClassDto.setId(classId);
        this.gradeClassDao.addPersonClassByIdNumberList(gradeClassDto);
        this.gradeClassDao.updatePerNum(gradeClassDto);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u6dfb\u52a0\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult removeGradeClassPerson(String gradeClass) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeClass).getSubject();
        GradeClassDto gradeClassDto = (GradeClassDto)JSON.parseObject((String)subject, GradeClassDto.class);
        List idNumberList = gradeClassDto.getIdNumberList();
        if (StringUtil.isBlank((CharSequence)gradeClassDto.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u5220\u9664\u5931\u8d25, \u7f3a\u5c11\u73ed\u7ea7\u540d\u79f0");
            return ajaxResult;
        }
        if (CollectionUtil.isEmpty((Collection)idNumberList)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u5220\u9664\u5931\u8d25, \u8eab\u4efd\u8bc1\u5217\u8868\u4e3a\u7a7a");
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        gradeClassDto.setUserid(userId);
        Long classId = this.gradeClassDao.getClassIdByGradeName(gradeClassDto);
        if (classId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u5220\u9664\u5931\u8d25, \u73ed\u7ea7\u4e0d\u5b58\u5728");
            return ajaxResult;
        }
        gradeClassDto.setId(classId);
        this.gradeClassDao.removePersonClassByIdNumberList(gradeClassDto);
        this.gradeClassDao.updatePerNum(gradeClassDto);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult commitGradeClassAdditionalInfo(String gradeClass) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeClass).getSubject();
        GradeClassDto gradeClassDto = (GradeClassDto)JSON.parseObject((String)subject, GradeClassDto.class);
        if (StringUtil.isBlank((CharSequence)gradeClassDto.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u6dfb\u52a0\u5931\u8d25, \u7f3a\u5c11\u73ed\u7ea7\u540d\u79f0");
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        String practiceScheduleUrl = gradeClassDto.getPracticeScheduleUrl();
        String policeCheckUrl = gradeClassDto.getPoliceCheckUrl();
        gradeClassDto.setPracticeScheduleUrl(this.getPhotoPath(practiceScheduleUrl));
        gradeClassDto.setPoliceCheckUrl(this.getPhotoPath(policeCheckUrl));
        gradeClassDto.setUserid(userId);
        this.gradeClassDao.updateByGradeClassName(gradeClassDto);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u6dfb\u52a0\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult confirmGradeResult(String gradeResult) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeResult).getSubject();
        GradeClassDto gradeClassDto = (GradeClassDto)JSON.parseObject((String)subject, GradeClassDto.class);
        String gradeClassName = gradeClassDto.getName();
        List personGradeList = gradeClassDto.getPersonGradeList();
        if (StringUtil.isBlank((CharSequence)gradeClassName)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u64cd\u4f5c\u5931\u8d25, \u7f3a\u5c11\u73ed\u7ea7\u540d\u79f0");
            return ajaxResult;
        }
        if (CollectionUtil.isEmpty((Collection)personGradeList)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u64cd\u4f5c\u5931\u8d25, \u7f3a\u5c11\u6210\u7ee9\u5217\u8868");
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        gradeClassDto.setUserid(userId);
        Long classId = this.gradeClassDao.getClassIdByGradeName(gradeClassDto);
        if (classId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u64cd\u4f5c\u5931\u8d25, \u73ed\u7ea7\u4e0d\u5b58\u5728");
            return ajaxResult;
        }
        HashMap resultData = Maps.newHashMap();
        for (PersonGrade personGrade : personGradeList) {
            String cerNo = personGrade.getCerNo();
            if (StringUtil.isBlank((CharSequence)cerNo)) {
                resultData.put(personGrade.getIdNum(), "\u7f3a\u5c11\u7b49\u7ea7\u8bc1\u4e66\u7f16\u53f7");
                continue;
            }
            personGrade.setClassId(classId);
            this.personGradeDao.updateByClassId(personGrade);
            resultData.put(personGrade.getIdNum(), "\u6210\u529f");
        }
        ajaxResult.setMsg("\u6210\u529f");
        ajaxResult.setSuccessful(true);
        ajaxResult.setData((Object)JwtUtil.createJWT((Map)resultData));
        return ajaxResult;
    }
}

