/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.CrosscompanyDao;
import com.bcxin.ars.dao.sb.CrosscompanyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.CrosscompanySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Crosscompany;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.CrosscompanyService;
import com.bcxin.ars.service.sys.impl.ApprovalServiceImpl;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.Bafwgskqjyxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Crosscompany.class)
public class CrosscompanyServiceImpl
implements CrosscompanyService {
    private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);
    @Autowired
    private CrosscompanyDao crosscompanyDao;
    @Autowired
    private CrosscompanyDaoAop crosscompanyDaoAop;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private ClientUtil clientUtil;

    public Crosscompany findById(long id) {
        Crosscompany result = this.crosscompanyDao.findById(Long.valueOf(id));
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(result.getId(), "005"));
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public List<Crosscompany> findByBatchId(List<Approval> approvalList) {
        return this.crosscompanyDao.findByBatchId(approvalList);
    }

    public void updateBatch(List<Crosscompany> list) {
        this.crosscompanyDao.updateBatch(list);
    }

    public void saveOrUpdate(Crosscompany crosscompany) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (crosscompany.getOrgid() == null) {
            if (crosscompany.getDistrictOrgId() != null) {
                crosscompany.setOrgid(Long.valueOf(Long.parseLong(crosscompany.getDistrictOrgId())));
            } else if (crosscompany.getCityOrgId() != null) {
                crosscompany.setOrgid(Long.valueOf(Long.parseLong(crosscompany.getCityOrgId())));
            }
        }
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
            crosscompany.setUserid(currentUser.getId());
        }
        if (crosscompany.getId() == null) {
            Crosscompany checkCrosscompany;
            if (!crosscompany.getApprovalstate().equals("001") && StringUtil.isNotEmpty((String)crosscompany.getManagerproject()) && crosscompany.getStartdate() != null && crosscompany.getEnddate() != null && (checkCrosscompany = this.crosscompanyDao.findApproveByManagerproject(crosscompany)) != null) {
                throw new ArsException("\u62df\u8de8\u533a\u57df\u7ecf\u8425\u7684\u4fdd\u5b89\u670d\u52a1\u9879\u76ee\u3010" + crosscompany.getManagerproject() + "\u3011\u5728" + DateUtil.convertDateToString((Date)crosscompany.getStartdate(), (String)"YYYY-MM-dd") + "\u81f3" + DateUtil.convertDateToString((Date)crosscompany.getEnddate(), (String)"YYYY-MM-dd") + "\u5df2\u5907\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            crosscompany.setActive(Boolean.valueOf(true));
            crosscompany.setCreateTime(new Date());
            crosscompany.setUpdateTime(new Date());
            crosscompany.setUpdateBy(currentUser.getUsername());
            crosscompany.setApprovalstate("002");
            this.crosscompanyDao.save(crosscompany);
            if (crosscompany.getApprovalstate().equals("002")) {
                this.approvalUtil.saveApproval("005", crosscompany.getId(), "activiticrosscompanyapprovalProcess");
            }
        } else {
            Crosscompany checkCrosscompany;
            if (!crosscompany.getApprovalstate().equals("001") && StringUtil.isNotEmpty((String)crosscompany.getManagerproject()) && crosscompany.getStartdate() != null && crosscompany.getEnddate() != null && (checkCrosscompany = this.crosscompanyDao.findApproveByManagerproject(crosscompany)) != null && checkCrosscompany.getId().longValue() != crosscompany.getId().longValue()) {
                throw new ArsException(crosscompany.getManagerproject() + "\u5728" + DateUtil.convertDateToString((Date)crosscompany.getStartdate(), (String)"YYYY-MM-dd") + "\u81f3" + DateUtil.convertDateToString((Date)crosscompany.getEnddate(), (String)"YYYY-MM-dd") + "\u5df2\u5907\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            Crosscompany dbCrosscompany = this.crosscompanyDao.findById(crosscompany.getId());
            boolean activity = true;
            if (StringUtil.isNotEmpty((String)dbCrosscompany.getApprovalstate()) && dbCrosscompany.getApprovalstate().equals("002") && dbCrosscompany.getOrgid().toString().equals(crosscompany.getOrgid().toString())) {
                Approval approval;
                activity = false;
                if (!dbCrosscompany.getCompanyname().equals(crosscompany.getCompanyname()) && (approval = this.approvalDAO.findBybusinessidAndType(crosscompany.getId(), "005")) != null) {
                    this.approvalUtil.updateContent(approval, crosscompany.getCompanyname());
                }
            }
            if ("001".equals(crosscompany.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore((Object)crosscompany, (Object)dbCrosscompany, (String)"active,createTime,userid", (Boolean)true);
            } else {
                BeanUtils.copyPropertiesIgnore((Object)crosscompany, (Object)dbCrosscompany, (Boolean)true);
            }
            dbCrosscompany.setUpdateTime(new Date());
            dbCrosscompany.setUpdateBy(currentUser.getUsername());
            if (crosscompany.getApprovalstate() != null && !"".equals(crosscompany.getApprovalstate()) && !"002".equals(crosscompany.getApprovalstate())) {
                dbCrosscompany.setApprovalstate(crosscompany.getApprovalstate());
            } else {
                dbCrosscompany.setApprovalstate("002");
                dbCrosscompany.setChargecensorstatus("");
                dbCrosscompany.setLegalcensorstatus("");
            }
            this.crosscompanyDaoAop.update(dbCrosscompany);
            if (activity && "002".equals(crosscompany.getApprovalstate())) {
                this.approvalUtil.saveApproval("005", dbCrosscompany.getId(), "activiticrosscompanyapprovalProcess");
            }
            if (dbCrosscompany.getApprovalstate() != null && dbCrosscompany.getApprovalstate().equals("003")) {
                new Thread(() -> {
                    try {
                        SecurityCompany company = this.securityCompanyDao.findByUserid(dbCrosscompany.getUserid());
                        Bafwgskqjyxx bafwgskqjyxx = new Bafwgskqjyxx();
                        bafwgskqjyxx.setBafwxkz(company.getPublicSecurityLicenseNumber());
                        bafwgskqjyxx.setJydz(company.getAreaCode());
                        bafwgskqjyxx.setBagsbm(company.getCompanyCode());
                        this.clientUtil.send("xxba_bafwgskqjyxx", (Object)bafwgskqjyxx);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
            }
        }
    }

    public void saveOrUpdateForDS(Crosscompany crosscompany) {
        Crosscompany dbCrosscompany;
        if (crosscompany.getActive() == null) {
            crosscompany.setActive(Boolean.valueOf(true));
        }
        if ((dbCrosscompany = this.crosscompanyDao.findById(crosscompany.getId())) != null) {
            if (crosscompany.getUpdateTime().getTime() > dbCrosscompany.getUpdateTime().getTime()) {
                crosscompany.setLegalcensorstatus(dbCrosscompany.getLegalcensorstatus());
                crosscompany.setChargecensorstatus(dbCrosscompany.getChargecensorstatus());
                this.crosscompanyDao.updateForDS(crosscompany);
            }
        } else {
            this.crosscompanyDao.saveForDS(crosscompany);
        }
    }

    public Crosscompany findByUser(Long userid) {
        return this.crosscompanyDao.findByUser(userid);
    }

    public CrosscompanySearchDto search(CrosscompanySearchDto dto) {
        CrosscompanySearchDto resultDto = new CrosscompanySearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        String areacode = police.getAreacode();
        if (areacode.endsWith("0000")) {
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {
            dto.setDistrict(areacode);
        }
        List list = this.crosscompanyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.crosscompanyDao.searchCount(dto));
        return resultDto;
    }

    public List<Crosscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.crosscompanyDao.searchForDataSynchronization(dto);
    }

    public List<Crosscompany> findAll() {
        return this.crosscompanyDao.findAll();
    }

    public void temporarySave(Crosscompany crosscompany) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (crosscompany.getId() == null) {
            crosscompany.setApprovalstate("001");
            crosscompany.setCreateTime(new Date());
            crosscompany.setUpdateTime(new Date());
            crosscompany.setActive(Boolean.valueOf(true));
            crosscompany.setUserid(currentUser.getId());
            crosscompany.setUpdateBy(currentUser.getUsername());
            this.crosscompanyDao.save(crosscompany);
        } else {
            Crosscompany dbCrosscompany = this.crosscompanyDao.findById(crosscompany.getId());
            if ("001".equals(crosscompany.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore((Object)crosscompany, (Object)dbCrosscompany, (String)"active,createTime,userid", (Boolean)true);
            } else {
                BeanUtils.copyPropertiesIgnore((Object)crosscompany, (Object)dbCrosscompany, (Boolean)true);
            }
            dbCrosscompany.setUpdateTime(new Date());
            dbCrosscompany.setUpdateBy(currentUser.getUsername());
            this.crosscompanyDaoAop.update(dbCrosscompany);
        }
    }

    public PageResult searchCrosscompanyList_table(Map<Object, Object> p) {
        User user;
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
        }
        if (police != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
        }
        if (p.get("checkType") != null && (user = this.arsUtil.getCurrentUser()) != null) {
            if (user.getPlatform() == 2) {
                p.put("userid", user.getId());
            } else {
                List roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    p.put("roles", roles);
                }
            }
        }
        if (p.get("checkType") != null && currentUser != null) {
            p.put("userid", currentUser.getId());
        }
        return new PageResult(Integer.valueOf(this.crosscompanyDao.countCrosscompanyList(p)), (Object)this.crosscompanyDao.searchCrosscompanyList(p));
    }

    public void saveOrUpdateForApproval(Crosscompany crosscompany) {
        crosscompany.setUpdateTime(new Date());
        this.crosscompanyDaoAop.update(crosscompany);
    }

    public Map<String, Object> selectApplyUserInfoWithId(Long id) {
        return this.crosscompanyDao.selectApplyUserInfoWithId(id);
    }

    public void updateCensorStatus(Crosscompany crosscompany) {
        this.crosscompanyDaoAop.update(crosscompany);
    }

    public void saveOrUpdateForApprovalImport(Crosscompany crosscompany) {
        this.crosscompanyDaoAop.update(crosscompany);
    }

    public void searchForPage(CrosscompanySearchDto dto, AjaxPageResponse<Crosscompany> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.crosscompanyDao.searchForPage(dto, page);
    }
}

