/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.CerLearnRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.CerLearnRecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.CerLearnRecord;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.CerLearnRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CerLearnRecord.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class CerLearnRecordServiceImpl
extends BaseService
implements CerLearnRecordService {
    Logger logger = LoggerFactory.getLogger(CerLearnRecordServiceImpl.class);
    @Autowired
    private CerLearnRecordDao cerLearnRecordDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(CerLearnRecord cerLearnRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        cerLearnRecord.setUpdateTime(new Date());
        cerLearnRecord.setUpdateBy(currentUser.getUsername());
        return this.cerLearnRecordDao.delete(cerLearnRecord);
    }

    public int save(CerLearnRecord cerLearnRecord) {
        if (StringUtil.isNotEmpty((String)cerLearnRecord.getPhoto())) {
            cerLearnRecord.setPhoto(this.getPhotoPath(cerLearnRecord.getPhoto()));
        }
        if (cerLearnRecord.getId() == null) {
            cerLearnRecord.setCreateTime(new Date());
        } else {
            CerLearnRecord dbCerLearnRecord = this.cerLearnRecordDao.findById(cerLearnRecord.getId());
            BeanUtils.copyPropertiesIgnore((Object)cerLearnRecord, (Object)dbCerLearnRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbCerLearnRecord, (Object)cerLearnRecord, (Boolean)false);
        }
        cerLearnRecord.setActive(Boolean.valueOf(true));
        cerLearnRecord.setUpdateTime(new Date());
        cerLearnRecord.setUpdateflag(Boolean.valueOf(true));
        cerLearnRecord.setUpdateBy("apiSystem");
        return this.cerLearnRecordDao.save(cerLearnRecord);
    }

    public CerLearnRecord findById(Long id) {
        return this.cerLearnRecordDao.findById(id);
    }

    public void searchForPage(CerLearnRecordPageSearchDto dto, AjaxPageResponse page) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser.getPlatform() == 2) {
            SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
            if ("0103".equals(company.getInstitutionType())) {
                dto.setTrainId(company.getComId());
            } else {
                dto.setComId(company.getComId());
            }
        } else {
            this.arsUtil.setPoliceSearch((SearchDto)dto);
        }
        this.cerLearnRecordDao.searchForPage(dto, page);
    }

    public void importBatch(List<CerLearnRecord> list) {
        List dbList = this.cerLearnRecordDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CerLearnRecord cerLearnRecord : list) {
                cerLearnRecord.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    cerLearnRecord.setUpdateTime(DateUtil.dateAdd((int)6, (Date)cerLearnRecord.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.cerLearnRecordDao.saveBatch(list);
        }
    }

    public List<CerLearnRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.cerLearnRecordDao.searchForDataSynchronization(dto);
    }

    public List<CerLearnRecord> findDSOutList(String startDate) {
        return this.cerLearnRecordDao.findDSOutList(startDate);
    }

    public List<CerLearnRecord> findByBatchId(List<CerLearnRecord> list) {
        return this.cerLearnRecordDao.findByBatchId(list);
    }

    public void updateSelective(CerLearnRecord cerLearnRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        cerLearnRecord.setUpdateTime(new Date());
        cerLearnRecord.setUpdateBy(currentUser.getUsername());
        this.cerLearnRecordDao.updateSelective(cerLearnRecord);
    }
}

