/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.service.msg.SysAttachmentService;
import com.bcxin.ars.service.sys.impl.ApprovalServiceImpl;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.StringUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SysAttachment.class)
@DataSyncOutAnnotation(getClazz=SysAttachment.class, getImportType=ImportType.BATCH_FILE)
public class SysAttachmentServiceImpl
implements SysAttachmentService {
    private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Value(value="${sysAttachmentFolder}")
    private String sysAttachmentFolder;
    @Value(value="${base-folder}")
    private String baseFolder;
    @Autowired
    private SysAttachmentDao sysAttachmentDao;

    public void saveOrUpdate(SysAttachment sysAttachment) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (sysAttachment.getId() == null) {
            sysAttachment.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            sysAttachment.setActive(Boolean.valueOf(true));
            sysAttachment.setCreateTime(new Date());
            sysAttachment.setUpdateBy(currentUser.getUsername());
            sysAttachment.setUpdateTime(new Date());
            sysAttachment.setUpdateflag(Boolean.valueOf(true));
            this.sysAttachmentDao.save(sysAttachment);
        } else {
            SysAttachment dbSysAttachment = this.sysAttachmentDao.findById(sysAttachment.getId());
            dbSysAttachment.setBusinessid(sysAttachment.getBusinessid());
            dbSysAttachment.setBusinesstype(sysAttachment.getBusinesstype());
            dbSysAttachment.setPath(sysAttachment.getPath());
            dbSysAttachment.setFileName(sysAttachment.getFileName());
            dbSysAttachment.setFileSize(sysAttachment.getFileSize());
            dbSysAttachment.setUpdateBy(currentUser.getUsername());
            dbSysAttachment.setUpdateTime(new Date());
            dbSysAttachment.setUpdateflag(Boolean.valueOf(true));
            this.sysAttachmentDao.update(dbSysAttachment);
        }
    }

    public void delete(SysAttachment sysAttachment) {
        User currentUser = this.arsUtil.getCurrentUser();
        sysAttachment.setActive(Boolean.valueOf(false));
        sysAttachment.setUpdateBy(currentUser.getUsername());
        sysAttachment.setUpdateTime(new Date());
        this.sysAttachmentDao.delete(sysAttachment);
    }

    public SysAttachment findById(Long id) {
        return this.sysAttachmentDao.findById(id);
    }

    public void delete(Long id) {
        SysAttachment sysAttachment = this.sysAttachmentDao.findById(id);
        this.delete(sysAttachment);
    }

    public List<SysAttachment> findAllByBusiness(String businessid, String businesstype) {
        return this.sysAttachmentDao.findAllByBusiness(businessid, businesstype);
    }

    public SysAttachment findByBusiness(SysAttachment sysAttachment) {
        return this.sysAttachmentDao.findByBusiness(sysAttachment.getBusinessid().toString(), sysAttachment.getBusinesstype());
    }

    public void importBatch(List<SysAttachment> list, Map<String, String> pathMap) {
        List dbList = this.sysAttachmentDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (SysAttachment detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                    String path = detail.getPath();
                    if (!StringUtil.isNotEmpty((String)path)) continue;
                    int lastIndex = path.replaceAll("\\\\", "/").lastIndexOf("/");
                    String key = path.substring(lastIndex + 1);
                    this.logger.info(key);
                    String filePath = path.replace("getResource.do?path=sysAttachment/", "");
                    filePath = this.sysAttachmentFolder + filePath;
                    File file = new File(filePath);
                    if (file.exists()) continue;
                    File resFile = new File(pathMap.get(key));
                    FileUtil.copyFolder((File)resFile, (File)new File(filePath.replace(key, "")));
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.sysAttachmentDao.saveBatch(list);
        }
    }

    public List<SysAttachment> findDSOutList(List<String> filePaths, String startDate) {
        List list = this.sysAttachmentDao.searchFromInToOutForExport(startDate);
        list.forEach(sysAttachment -> {
            if (StringUtil.isNotEmpty((String)sysAttachment.getPath())) {
                filePaths.add(this.sysAttachmentFolder + sysAttachment.getPath().replace("getResource.do?path=sysAttachment/", ""));
            }
        });
        return list;
    }

    public void saveOrUpdateForImport(SysAttachment sysAttachment) {
        try {
            sysAttachment.setUpdateflag(Boolean.valueOf(false));
            SysAttachment dbSysAttachment = this.sysAttachmentDao.findById(sysAttachment.getId());
            if (dbSysAttachment == null) {
                sysAttachment.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)sysAttachment.getUpdateTime(), (int)1));
                this.sysAttachmentDao.saveForDS(sysAttachment);
            } else if (sysAttachment.getUpdateTime().getTime() > dbSysAttachment.getUpdateTime().getTime()) {
                sysAttachment.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)sysAttachment.getUpdateTime(), (int)1));
                this.sysAttachmentDao.updateForDS(sysAttachment);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveOrUpdateForImport2(SysAttachment sysAttachment, Map<String, String> pathMap) {
        try {
            String path;
            sysAttachment.setUpdateflag(Boolean.valueOf(false));
            boolean isSave = false;
            SysAttachment dbSysAttachment = this.sysAttachmentDao.findById(sysAttachment.getId());
            if (dbSysAttachment == null) {
                sysAttachment.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)sysAttachment.getUpdateTime(), (int)1));
                this.sysAttachmentDao.saveForDS(sysAttachment);
                isSave = true;
            } else if (sysAttachment.getUpdateTime().getTime() > dbSysAttachment.getUpdateTime().getTime()) {
                sysAttachment.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)sysAttachment.getUpdateTime(), (int)1));
                this.sysAttachmentDao.updateForDS(sysAttachment);
                isSave = true;
            }
            if (isSave && StringUtil.isNotEmpty((String)(path = sysAttachment.getPath()))) {
                int lastIndex = path.replaceAll("\\\\", "/").lastIndexOf("/");
                String key = path.substring(lastIndex + 1);
                this.logger.info(key);
                String filePath = path.replace("getResource.do?path=sysAttachment/", "");
                filePath = this.sysAttachmentFolder + filePath;
                File file = new File(filePath);
                if (!file.exists()) {
                    File resFile = new File(pathMap.get(key));
                    FileUtil.copyFolder((File)resFile, (File)new File(filePath.replace(key, "")));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<SysAttachment> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.sysAttachmentDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(SysAttachment sysAttachment) {
        SysAttachment dbsysAttachment;
        sysAttachment.setUpdateflag(Boolean.valueOf(false));
        if (sysAttachment.getActive() == null) {
            sysAttachment.setActive(Boolean.valueOf(true));
        }
        if ((dbsysAttachment = this.sysAttachmentDao.findById(sysAttachment.getId())) != null) {
            if (sysAttachment.getUpdateTime().getTime() > dbsysAttachment.getUpdateTime().getTime()) {
                this.sysAttachmentDao.updateForDS(sysAttachment);
            }
        } else {
            this.sysAttachmentDao.saveForDS(sysAttachment);
        }
    }
}

