/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.msg.NewsnoticeCompanyDao;
import com.bcxin.ars.dao.msg.NewsnoticePoliceDao;
import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.service.msg.NewsnoticeCompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=NewsnoticeCompany.class)
@DataSyncOutAnnotation(getClazz=NewsnoticeCompany.class, getMethodName="saveOrUpdateForImport", getImportType=ImportType.FOREACH)
public class NewsnoticeCompanyServiceImpl
implements NewsnoticeCompanyService {
    public static final Logger logger = LoggerFactory.getLogger(NewsnoticeCompanyServiceImpl.class);
    @Autowired
    private NewsnoticePoliceDao newsnoticePoliceDao;
    @Autowired
    private SysAttachmentDao sysAttachmentDao;
    @Autowired
    private NewsnoticeCompanyDao newsnoticeCompanyDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    public NewsnoticeCompanySearchDto search(NewsnoticeCompanySearchDto dto) {
        NewsnoticeCompanySearchDto resultDto = new NewsnoticeCompanySearchDto();
        List list = this.newsnoticeCompanyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.newsnoticeCompanyDao.searchCount(dto));
        return resultDto;
    }

    public PageResult searchNewsnoticeCompanyList_table(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.newsnoticeCompanyDao.countNewsnoticeCompanyList(p)), (Object)this.newsnoticeCompanyDao.searchNewsnoticeCompanyList(p));
    }

    public PageResult searchNewsnoticeCompanyReplyListForPolice(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.newsnoticeCompanyDao.countNewsnoticeCompanyReplyList(p)), (Object)this.newsnoticeCompanyDao.searchNewsnoticeCompanyReplyList(p));
    }

    public PageResult searchNewsnoticeCompanyReplyListForCompany(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.newsnoticeCompanyDao.countNewsnoticeCompanyReplyCompanyList(p)), (Object)this.newsnoticeCompanyDao.searchNewsnoticeCompanyReplyCompanyList(p));
    }

    public void updateReadstateByidArr(Long[] idArray) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        SecurityCompany company = this.securityCompanyDao.findByUserid(user.getId());
        List listIds = this.newsnoticePoliceDao.findBatchForMessageIdSaaS(idArray);
        if (listIds == null || listIds.size() == 0) {
            return;
        }
        Long[] newIds = new Long[listIds.size()];
        int i = 0;
        for (NewsnoticePolice np : listIds) {
            newIds[i++] = np.getId();
        }
        this.newsnoticeCompanyDao.updateReadstateByidArr(newIds, company.getId());
        this.newsnoticePoliceDao.batchUpdateByCompanyId(newIds, company.getId());
    }

    public void updateReadstateByIdForPolice(Long[] idArray) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (1 == user.getPlatform()) {
            this.newsnoticeCompanyDao.updateReadstateByidArr(idArray, user.getId());
            this.newsnoticePoliceDao.batchUpdateByCompanyId(idArray, user.getId());
        } else {
            SecurityCompany company = this.securityCompanyDao.findByUserid(user.getId());
            this.newsnoticeCompanyDao.updateReadstateByidArr(idArray, company.getId());
            this.newsnoticePoliceDao.batchUpdateByCompanyId(idArray, company.getId());
        }
    }

    public List<NewsnoticeCompany> findUnread() {
        return this.newsnoticeCompanyDao.findUnread();
    }

    public int countUnread() {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return this.newsnoticeCompanyDao.countUnread(user.getId());
    }

    public void updateReaded(NewsnoticeCompanySearchDto newsnoticeCompany) {
        User user = this.arsUtil.getCurrentUser();
        User currentUser = this.arsUtil.getCurrentUser();
        newsnoticeCompany.setUpdateTime(new Date());
        newsnoticeCompany.setUpdateBy(currentUser.getUsername());
        newsnoticeCompany.setUpdateflag(true);
        this.newsnoticeCompanyDao.updateReaded(newsnoticeCompany);
        this.newsnoticePoliceDao.batchUpdate(newsnoticeCompany);
    }

    public NewsnoticeCompany findById(Long id) {
        User user = this.arsUtil.getCurrentUser();
        NewsnoticeCompany newsnoticeCompany = this.newsnoticeCompanyDao.findById(id.longValue());
        if (newsnoticeCompany != null && StringUtil.equals((String)newsnoticeCompany.getReadstate(), (String)"0")) {
            newsnoticeCompany.setUpdateBy(user.getUsername());
            newsnoticeCompany.setUpdateTime(new Date());
            newsnoticeCompany.setReadstate("1");
            newsnoticeCompany.setUpdateflag(Boolean.valueOf(true));
            this.newsnoticeCompanyDao.update(newsnoticeCompany);
            if (newsnoticeCompany.getNewsnoticeid() != null) {
                NewsnoticePolice newsnoticePolice = this.newsnoticePoliceDao.findById(Long.valueOf(newsnoticeCompany.getNewsnoticeid()));
                newsnoticePolice.setReadnum(Integer.valueOf(newsnoticePolice.getReadnum() + 1));
                newsnoticePolice.setUpdateTime(new Date());
                newsnoticePolice.setUpdateflag(Boolean.valueOf(true));
                newsnoticePolice.setUnreadnum(Integer.valueOf(newsnoticePolice.getUnreadnum() - 1));
                this.newsnoticePoliceDao.update(newsnoticePolice);
            }
        }
        return newsnoticeCompany;
    }

    public List<NewsnoticeCompany> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.newsnoticeCompanyDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(NewsnoticeCompany newsnoticeCompany) {
        NewsnoticeCompany dbnewsnoticeCompany;
        newsnoticeCompany.setUpdateflag(Boolean.valueOf(false));
        if (newsnoticeCompany.getActive() == null) {
            newsnoticeCompany.setActive(Boolean.valueOf(true));
        }
        if ((dbnewsnoticeCompany = this.newsnoticeCompanyDao.findById(newsnoticeCompany.getId().longValue())) != null) {
            if (dbnewsnoticeCompany.getActive() != newsnoticeCompany.getActive()) {
                newsnoticeCompany.setActive(dbnewsnoticeCompany.getActive());
                if (dbnewsnoticeCompany.getUpdateflag().booleanValue()) {
                    newsnoticeCompany.setUpdateflag(Boolean.valueOf(true));
                }
                this.newsnoticeCompanyDao.updateForDS(newsnoticeCompany);
            } else if (newsnoticeCompany.getUpdateTime().getTime() > dbnewsnoticeCompany.getUpdateTime().getTime()) {
                this.newsnoticeCompanyDao.updateForDS(newsnoticeCompany);
            }
        } else {
            this.newsnoticeCompanyDao.saveForDS(newsnoticeCompany);
        }
    }

    public List<NewsnoticeCompany> findDSOutList(String startDate) {
        return this.newsnoticeCompanyDao.searchFromInToOutForExport(startDate);
    }

    public void saveOrUpdateForImport(NewsnoticeCompany newsnoticeCompany) {
        try {
            newsnoticeCompany.setUpdateflag(Boolean.valueOf(false));
            NewsnoticeCompany dbNewsnoticeCompany = this.newsnoticeCompanyDao.findById(newsnoticeCompany.getId().longValue());
            if (dbNewsnoticeCompany == null) {
                newsnoticeCompany.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsnoticeCompany.getUpdateTime(), (int)1));
                this.newsnoticeCompanyDao.saveForDS(newsnoticeCompany);
            } else if (!dbNewsnoticeCompany.getActive().equals(newsnoticeCompany.getActive())) {
                dbNewsnoticeCompany.setUpdateTime(new Date());
                dbNewsnoticeCompany.setActive(newsnoticeCompany.getActive());
                dbNewsnoticeCompany.setUpdateTime(new Date());
                this.newsnoticeCompanyDao.updateForDS(dbNewsnoticeCompany);
            } else if (newsnoticeCompany.getUpdateTime().getTime() > dbNewsnoticeCompany.getUpdateTime().getTime() || StringUtil.isNotEmpty((String)dbNewsnoticeCompany.getUndoState()) && !dbNewsnoticeCompany.getUndoState().equals(newsnoticeCompany.getUndoState())) {
                newsnoticeCompany.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsnoticeCompany.getUpdateTime(), (int)1));
                newsnoticeCompany.setReadstate(dbNewsnoticeCompany.getReadstate());
                this.newsnoticeCompanyDao.updateForDS(newsnoticeCompany);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveOrUpdate(NewsnoticeCompany newsnoticeCompany) {
        User currentUser = this.arsUtil.getCurrentUser();
        NewsnoticeCompany dbNewsnoticeCompany = this.newsnoticeCompanyDao.findById(newsnoticeCompany.getId().longValue());
        BeanUtils.copyPropertiesIgnore((Object)newsnoticeCompany, (Object)dbNewsnoticeCompany, (Boolean)true);
        this.newsnoticeCompanyDao.update(dbNewsnoticeCompany);
        if (newsnoticeCompany.getSysAttachmentIds() != null && newsnoticeCompany.getSysAttachmentIds().length > 0) {
            SysAttachment dbSysAttachment = null;
            for (Long sysAttachmentId : newsnoticeCompany.getSysAttachmentIds()) {
                dbSysAttachment = this.sysAttachmentDao.findById(sysAttachmentId);
                dbSysAttachment.setBusinessid(newsnoticeCompany.getId());
                dbSysAttachment.setBusinesstype("004");
                dbSysAttachment.setUpdateBy(currentUser.getUsername());
                dbSysAttachment.setUpdateTime(new Date());
                dbSysAttachment.setUpdateflag(Boolean.valueOf(true));
                this.sysAttachmentDao.update(dbSysAttachment);
            }
        }
    }

    public void searchForPage(NewsnoticeCompanySearchDto dto, AjaxPageResponse<NewsnoticeCompany> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.newsnoticeCompanyDao.searchForPage(dto, page);
    }
}

